/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers.cofh;

import java.util.ArrayList;
import java.util.List;
import mariculture.core.helpers.cofh.FluidHelper;
import mariculture.core.helpers.cofh.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";

    private ItemHelper() {
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, stackSize);
        return stack;
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.field_77994_a = stackSize;
        return retStack;
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (other != null && other.field_77990_d != null) {
            container.field_77990_d = (NBTTagCompound)other.field_77990_d.func_74737_b();
        }
        return container;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound tag, String name) {
        if (name == "") {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound("tag");
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74766_a("display", new NBTTagCompound());
        }
        tag.func_74775_l("display").func_74778_a("Name", name);
        return tag;
    }

    public static String getNameFromItemStack(ItemStack stack) {
        if (stack == null || stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("display")) {
            return "";
        }
        return stack.field_77990_d.func_74775_l("display").func_74779_i("Name");
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[0] == null || Item.field_77698_e[dmgItems[0].field_77993_c] == null) {
            return null;
        }
        if (dmgItems[1] != null && dmgItems[0].field_77993_c == dmgItems[1].field_77993_c && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && Item.field_77698_e[dmgItems[0].field_77993_c].isRepairable()) {
            Item theItem = Item.field_77698_e[dmgItems[0].field_77993_c];
            int var13 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int var8 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int var9 = var13 + var8 + theItem.func_77612_l() * 5 / 100;
            int var10 = Math.max(0, theItem.func_77612_l() - var9);
            return new ItemStack(dmgItems[0].field_77993_c, 1, var10);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static int getHashCode(ItemStack stack) {
        return stack.func_77960_j() | stack.field_77993_c << 16;
    }

    public static int getHashCode(int id, int metadata) {
        return metadata | id << 16;
    }

    public static int getIDFromHashCode(int hashCode) {
        return hashCode >> 16;
    }

    public static int getMetaFromHashCode(int hashCode) {
        return hashCode & 0xFF;
    }

    public static boolean hasOreName(ItemStack stack) {
        return !ItemHelper.getOreName(stack).equals("Unknown");
    }

    public static String getOreName(ItemStack stack) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack));
    }

    public static boolean isOreID(ItemStack stack, int oreID) {
        return OreDictionary.getOreID((ItemStack)stack) == oreID;
    }

    public static boolean isOreName(ItemStack stack, String oreName) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack)).equals(oreName);
    }

    public static boolean oreNameExists(String oreName) {
        return !OreDictionary.getOres((String)oreName).isEmpty();
    }

    public static ItemStack getOre(String oreName) {
        if (!ItemHelper.oreNameExists(oreName)) {
            return null;
        }
        return ItemHelper.cloneStack((ItemStack)OreDictionary.getOres((String)oreName).get(0), 1);
    }

    public static boolean isBlock(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(LOG);
    }

    public static final boolean isPlayerHoldingFluidContainer(EntityPlayer player) {
        return FluidContainerRegistry.isContainer((ItemStack)player.func_71045_bC());
    }

    public static final boolean isPlayerHoldingFluidContainerItem(EntityPlayer player) {
        return FluidHelper.isPlayerHoldingFluidContainerItem(player);
    }

    public static final boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        Item equipped;
        Item item2 = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return item == null ? equipped == null : item.equals(equipped);
    }

    public static final boolean isPlayerHoldingItemStack(ItemStack stack, EntityPlayer player) {
        ItemStack equipped;
        ItemStack itemStack = equipped = player.func_71045_bC() != null ? player.func_71045_bC() : null;
        return stack == null ? equipped == null : equipped != null && stack.func_77969_a(equipped) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)equipped);
    }

    public static final boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return ItemStack.func_77989_b((ItemStack)stackA, (ItemStack)stackB);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean areItemStackEqualNoNull(ItemStack stackA, ItemStack stackB) {
        if (!stackA.func_77969_a(stackB)) return false;
        if (stackA.field_77990_d != null) {
            if (stackB.field_77990_d == null) return false;
            if (!stackA.field_77990_d.equals((Object)stackB.field_77990_d)) return false;
            return true;
        }
        if (stackB.field_77990_d == null) return true;
        return false;
    }

    public static boolean areItemStacksEqualNoNBT(ItemStack stackA, ItemStack stackB) {
        if (stackB == null) {
            return false;
        }
        return stackA.field_77993_c == stackB.field_77993_c && (stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || !stackA.func_77981_g() || stackB.func_77960_j() == stackA.func_77960_j());
    }

    public static boolean craftingEquivalent(ItemStack checked, ItemStack source, String oreDict, ItemStack output) {
        return output == null ? (ItemHelper.areItemStacksEqualNoNBT(checked, source) ? true : (oreDict == null ? false : (oreDict.equals("Unknown") ? false : ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict)))) : (ItemHelper.isBlacklist(output) ? ItemHelper.areItemStacksEqualNoNBT(checked, source) : (ItemHelper.areItemStacksEqualNoNBT(checked, source) ? true : (oreDict == null ? false : (oreDict.equals("Unknown") ? false : ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict)))));
    }

    public static boolean isBlacklist(ItemStack output) {
        return output.field_77993_c == Block.field_72072_bX.field_71990_ca || output.field_77993_c == Block.field_72070_bY.field_71990_ca || output.field_77993_c == Block.field_72063_at.field_71990_ca || output.field_77993_c == Block.field_72074_bW.field_71990_ca || output.field_77993_c == Block.field_71988_x.field_71990_ca || output.field_77993_c == Block.field_72092_bO.field_71990_ca;
    }

    public static String getItemNBTString(ItemStack theItem, String nbtKey, String invalidReturn) {
        return theItem.field_77990_d != null ? (theItem.field_77990_d.func_74764_b(nbtKey) ? theItem.field_77990_d.func_74779_i(nbtKey) : invalidReturn) : invalidReturn;
    }

    public static Item getItemFromStack(ItemStack theStack) {
        return theStack == null ? null : theStack.func_77973_b();
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB) {
        return stackA == null ? stackB == null : stackB != null && stackA.field_77993_c == stackB.field_77993_c && (!stackA.func_77981_g() || stackA.func_77960_j() == stackB.func_77960_j());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB) {
        return stackA == null ? stackB == null : stackB != null && stackA.field_77993_c == stackB.field_77993_c;
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return stackA == null ? stackB == null : stackB != null && stackA.field_77993_c == stackB.field_77993_c && stackA.func_77960_j() == stackB.func_77960_j() && (!checkNBT || ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return stackA == null ? stackB == null : stackB != null && stackA.field_77993_c == stackB.field_77993_c && (!checkNBT || ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean doOreIDsMatch(ItemStack stackA, ItemStack stackB) {
        return OreDictionary.getOreID((ItemStack)stackA) >= 0 && OreDictionary.getOreID((ItemStack)stackA) == OreDictionary.getOreID((ItemStack)stackB);
    }

    public static boolean doNBTsMatch(NBTTagCompound nbtA, NBTTagCompound nbtB) {
        return nbtA == null ? nbtB == null : (nbtB == null ? false : nbtA.equals((Object)nbtB));
    }

    public static void addInventoryInformation(ItemStack stack, List list) {
        ItemHelper.addInventoryInformation(stack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack stack, List list, int minSlot, int maxSlot) {
        if (stack.field_77990_d.func_74764_b("Inventory") && stack.field_77990_d.func_74761_m("Inventory").func_74745_c() > 0) {
            if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
                list.add(StringHelper.shiftForInfo);
            }
            if (!StringHelper.isShiftKeyDown()) {
                return;
            }
            list.add(StringHelper.localize("info.cofh.contents") + ":");
            NBTTagList nbtList = stack.field_77990_d.func_74761_m("Inventory");
            ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
            boolean[] visited = new boolean[nbtList.func_74745_c()];
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)nbtList.func_74743_b(i);
                int slot = tag.func_74762_e("Slot");
                if (visited[i] || slot < minSlot || slot > maxSlot) continue;
                visited[i] = true;
                ItemStack curStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                if (curStack == null) continue;
                containedItems.add(curStack);
                for (int j = 0; j < nbtList.func_74745_c(); ++j) {
                    ItemStack curStack2;
                    NBTTagCompound tag2 = (NBTTagCompound)nbtList.func_74743_b(j);
                    int slot2 = tag.func_74762_e("Slot");
                    if (visited[j] || slot < minSlot || slot > maxSlot || (curStack2 = ItemStack.func_77949_a((NBTTagCompound)tag2)) == null || !ItemHelper.itemsEqualWithMetadata(curStack, curStack2)) continue;
                    curStack.field_77994_a += curStack2.field_77994_a;
                    visited[j] = true;
                }
            }
            for (ItemStack item : containedItems) {
                int maxStackSize = item.func_77976_d();
                if (!StringHelper.displayStackCount || item.field_77994_a < maxStackSize || maxStackSize == 1) {
                    list.add("    \u00a7a" + item.field_77994_a + " " + "\u00a78" + item.func_82833_r());
                    continue;
                }
                if (item.field_77994_a % maxStackSize != 0) {
                    list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + "+" + item.field_77994_a % maxStackSize + " " + "\u00a78" + item.func_82833_r());
                    continue;
                }
                list.add("    \u00a7a" + maxStackSize + "x" + item.field_77994_a / maxStackSize + " " + "\u00a78" + item.func_82833_r());
            }
        }
    }
}

