/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.util.IItemDropBlacklist;
import mariculture.core.util.Rand;
import mariculture.fishery.blocks.TileFishTank;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;

public class BlockHelper {
    public static boolean isWater(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        return id == Block.field_71943_B.field_71990_ca || id == Block.field_71942_A.field_71990_ca;
    }

    public static boolean isHPWater(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Core.highPressureWaterBlock.field_71990_ca;
    }

    public static boolean isLava(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        return id == Block.field_71938_D.field_71990_ca || id == Block.field_71944_C.field_71990_ca;
    }

    public static boolean isFishLiveable(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76575_d) {
            return BlockHelper.isLava(world, x, y, z);
        }
        return BlockHelper.isWater(world, x, y, z);
    }

    public static boolean isFishable(World world, int x, int y, int z) {
        return BlockHelper.isWater(world, x, y, z) || BlockHelper.isLava(world, x, y, z) && world.field_73011_w.field_76575_d;
    }

    public static boolean isAir(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_72799_c(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setBlock(World world, int x, int y, int z, int id, int meta) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                world.func_72832_d(x, y, z, id, meta, 3);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static int getID(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_72798_a(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getMeta(World world, int x, int y, int z) {
        if (world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            try {
                return world.func_72805_g(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean chunkExists(World world, int x, int z) {
        return world.func_72863_F().func_73149_a(x >> 4, z >> 4);
    }

    public static String getName(ItemStack stack) {
        if (stack != null) {
            return Item.field_77698_e[stack.field_77993_c].func_77628_j(stack);
        }
        return "";
    }

    public static String getName(TileEntity tile) {
        if (tile == null) {
            return "";
        }
        int id = tile.func_70311_o().field_71990_ca;
        if (Item.field_77698_e[id] != null) {
            Item block = Item.field_77698_e[id];
            return StatCollector.func_74838_a((String)(block.func_77667_c(new ItemStack(id, 1, tile.func_70322_n())) + ".name"));
        }
        return "";
    }

    public static ForgeDirection rotate(ForgeDirection dir) {
        if (dir == ForgeDirection.NORTH) {
            return ForgeDirection.EAST;
        }
        if (dir == ForgeDirection.EAST) {
            return ForgeDirection.SOUTH;
        }
        if (dir == ForgeDirection.SOUTH) {
            return ForgeDirection.WEST;
        }
        if (dir == ForgeDirection.WEST) {
            return ForgeDirection.UP;
        }
        if (dir == ForgeDirection.UP) {
            return ForgeDirection.DOWN;
        }
        return ForgeDirection.NORTH;
    }

    public static void dropItems(World world, int x, int y, int z) {
        Random rand = Rand.rand;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof IInventory)) {
            return;
        }
        if (tile instanceof TileMultiBlock) {
            TileMultiBlock multi = (TileMultiBlock)tile;
            if (multi.master != null && !multi.isMaster()) {
                return;
            }
        }
        IInventory inventory = (IInventory)tile;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item;
            boolean drop = true;
            if (tile instanceof IItemDropBlacklist) {
                drop = ((IItemDropBlacklist)tile).doesDrop(i);
            }
            if (!drop || (item = inventory.func_70301_a(i)) == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.6f + 0.1f;
            float ry = rand.nextFloat() * 0.6f + 0.1f;
            float rz = rand.nextFloat() * 0.6f + 0.1f;
            EntityItem entity_item = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.field_77993_c, item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entity_item.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entity_item.field_70159_w = rand.nextGaussian() * (double)factor;
            entity_item.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entity_item.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entity_item);
            item.field_77994_a = 0;
        }
    }

    public static void dropFish(World world, int x, int y, int z) {
        Random rand = Rand.rand;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileFishTank) {
            HashMap<Integer, ItemStack> fish = ((TileFishTank)tile).fish;
            for (Map.Entry<Integer, ItemStack> pairs : fish.entrySet()) {
                ItemStack stack = pairs.getValue();
                if (stack == null || stack.field_77994_a <= 0) continue;
                float rx = rand.nextFloat() * 0.6f + 0.1f;
                float ry = rand.nextFloat() * 0.6f + 0.1f;
                float rz = rand.nextFloat() * 0.6f + 0.1f;
                EntityItem entity_item = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(stack.field_77993_c, stack.field_77994_a, stack.func_77960_j()));
                if (stack.func_77942_o()) {
                    entity_item.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entity_item.field_70159_w = rand.nextGaussian() * (double)factor;
                entity_item.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                entity_item.field_70179_y = rand.nextGaussian() * (double)factor;
                world.func_72838_d((Entity)entity_item);
                stack.field_77994_a = 0;
            }
        }
        BlockHelper.dropItems(world, x, y, z);
    }

    public static void destroyBlock(World world, int x, int y, int z) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block.func_71934_m(world, x, y, z) < 0.0f) {
            return;
        }
        FakePlayer player = new FakePlayer(world, "Mariculture");
        int meta = world.func_72805_g(x, y, z);
        if (block.removeBlockByPlayer(world, (EntityPlayer)player, x, y, z)) {
            block.func_71898_d(world, x, y, z, meta);
        }
        block.func_71893_a(world, (EntityPlayer)player, x, y, z, meta);
        block.func_71846_a(world, x, y, z, meta, (EntityPlayer)player);
        world.func_72902_n(x, y, z);
    }
}

