/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.ArrayList;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.lib.Extra;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomItem;

public class PearlGenHandler {
    private static ArrayList<GeneratedPearls> pearls = new ArrayList();

    public static void addPearl(ItemStack item, int rarity) {
        PearlGenHandler.addPearl(item, rarity, 1, 1);
    }

    private static float addPearl(ItemStack item, int rarity, int minCount, int maxCount) {
        for (GeneratedPearls loot : pearls) {
            if (!loot.equals(item, minCount, maxCount)) continue;
            return loot.field_76292_a += rarity;
        }
        pearls.add(new GeneratedPearls(rarity, item, minCount, maxCount));
        return rarity;
    }

    public static ItemStack getRandomPearl(Random rand) {
        GeneratedPearls ret = (GeneratedPearls)WeightedRandom.func_76271_a((Random)rand, pearls);
        if (ret != null) {
            return ret.generateStack(rand);
        }
        return null;
    }

    static {
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 9), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 8), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 6), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 5), 5);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 1), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 3), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 10), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 7), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 4), 10);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 11), 6);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 0), 7);
        PearlGenHandler.addPearl(new ItemStack(Core.pearls, 1, 2), 6);
        PearlGenHandler.addPearl(new ItemStack(Block.field_71939_E), 15);
        if (Extra.GEN_ENDER_PEARLS) {
            PearlGenHandler.addPearl(new ItemStack(Item.field_77730_bn), 1);
        }
    }

    private static class GeneratedPearls
    extends WeightedRandomItem {
        private ItemStack itemStack;
        private int minCount = 1;
        private int maxCount = 1;

        private GeneratedPearls(int weight, ItemStack item, int min, int max) {
            super(weight);
            this.itemStack = item;
            this.minCount = min;
            this.maxCount = max;
        }

        private ItemStack generateStack(Random rand) {
            ItemStack ret = this.itemStack.func_77946_l();
            ret.field_77994_a = this.minCount + rand.nextInt(this.maxCount - this.minCount + 1);
            return ret;
        }

        private boolean equals(ItemStack item, int min, int max) {
            return min == this.minCount && max == this.maxCount && item.func_77969_a(this.itemStack);
        }

        public boolean equals(ItemStack item) {
            return item.func_77969_a(this.itemStack);
        }
    }
}

