/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.HashMap;
import java.util.Map;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.ISmelterHandler;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.util.Rand;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class LiquifierHandler
implements ISmelterHandler {
    private final Map fuels = new HashMap();
    private final HashMap<String, RecipeSmelter> recipes = new HashMap();

    @Override
    public void addRecipe(RecipeSmelter recipe) {
        if (recipe.input2 != null) {
            this.recipes.put(OreDicHelper.convert(recipe.input) + "|" + OreDicHelper.convert(recipe.input2), recipe);
        } else {
            this.recipes.put(OreDicHelper.convert(recipe.input), recipe);
        }
    }

    @Override
    public RecipeSmelter getResult(ItemStack input, ItemStack input2, int temp) {
        RecipeSmelter recipe = this.recipes.get(OreDicHelper.convert(input) + "|" + OreDicHelper.convert(input2));
        if (recipe == null) {
            recipe = this.recipes.get(OreDicHelper.convert(input2) + "|" + OreDicHelper.convert(input));
        }
        if (recipe == null) {
            recipe = this.recipes.get(OreDicHelper.convert(input));
        }
        if (recipe != null) {
            FluidStack fluid = recipe.fluid.copy();
            if (temp < recipe.temp && temp != -1) {
                return null;
            }
            if (recipe.input2 != null) {
                if (input2.field_77994_a < recipe.input.field_77994_a) {
                    return null;
                }
            } else {
                if (input.field_77994_a < recipe.input.field_77994_a) {
                    return null;
                }
                if (recipe.random != null) {
                    for (int i = 0; i < recipe.random.length; ++i) {
                        if (!Rand.nextInt(recipe.rands[i]) || (fluid = recipe.random[i]) == null) continue;
                        return new RecipeSmelter(recipe.input, null, recipe.temp, fluid, recipe.output, recipe.chance, new Integer[]{0});
                    }
                    return new RecipeSmelter(recipe.input, null, recipe.temp, recipe.random[0], recipe.output, recipe.chance, new Integer[]{0});
                }
                if (input.func_77984_f()) {
                    double mod = (double)(input.func_77958_k() - input.func_77960_j()) / (double)input.func_77958_k();
                    fluid.amount = (int)((double)fluid.amount * mod);
                }
            }
            return new RecipeSmelter(recipe.input, recipe.input2, recipe.temp, fluid, recipe.output, recipe.chance);
        }
        return null;
    }

    public String getName(FluidStack fluid) {
        if (fluid.getFluid() == null) {
            return "null";
        }
        return fluid.getFluid().getName();
    }

    @Override
    public void addFuel(Object fuel, FuelInfo info) {
        if (fuel instanceof ItemStack) {
            this.fuels.put(OreDicHelper.convert((ItemStack)fuel), info);
        }
        if (fuel instanceof FluidStack) {
            this.fuels.put(this.getName((FluidStack)fuel), info);
        } else if (fuel instanceof String) {
            this.fuels.put((String)fuel, info);
        }
    }

    @Override
    public FuelInfo getFuelInfo(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ItemStack) {
            return (FuelInfo)this.fuels.get(OreDicHelper.convert((ItemStack)obj));
        }
        if (obj instanceof FluidStack) {
            return (FuelInfo)this.fuels.get(this.getName((FluidStack)obj));
        }
        return null;
    }

    @Override
    public int getMeltingPoint(ItemStack stack) {
        RecipeSmelter recipe = this.recipes.get(OreDicHelper.convert(stack));
        if (recipe != null) {
            return recipe.temp;
        }
        return -1;
    }

    @Override
    public HashMap<String, RecipeSmelter> getRecipes() {
        return this.recipes;
    }
}

