/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.HashMap;
import mariculture.api.core.Environment;
import mariculture.api.core.IEnvironmentHandler;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;

public class EnvironmentHandler
implements IEnvironmentHandler {
    public static final HashMap<BiomeGenBase, BiomeData> environments = new HashMap();

    @Override
    public void addEnvironment(BiomeGenBase biome, Environment.Salinity salinity, int temperature) {
        environments.put(biome, new BiomeData(temperature, salinity));
    }

    @Override
    public Environment.Salinity getSalinity(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeData data = environments.get(biome);
        return data == null ? Environment.Salinity.FRESH : data.salinity;
    }

    @Override
    public int getBiomeTemperature(World world, int x, int y, int z) {
        int temperature = 10;
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeData data = environments.get(biome);
        if (data != null) {
            temperature = data.temperature;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            temperature = 100;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT)) {
            temperature = 50;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
            temperature = -30;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            temperature = 8;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            temperature = 25;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            temperature = 10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS)) {
            temperature = 10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            temperature = 45;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            temperature = -10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            temperature = 3;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
            temperature = 20;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            temperature = 15;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            temperature = -10;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) {
            temperature = -2;
        }
        return temperature;
    }

    @Override
    public int getTemperature(World world, int x, int y, int z) {
        int temperature = this.getBiomeTemperature(world, x, y, z) - 3;
        temperature = (int)((float)temperature + (this.getSunBrightness(world, 1.0f) * 9.0f - 2.0f));
        if (y > 60) {
            temperature = (int)((double)(60 - y) * 0.11255) + temperature;
        } else if (y < 68) {
            temperature = (int)((double)temperature - (double)(68 - y) * 0.11255);
        }
        return temperature -= (int)((double)world.func_72867_j(1.0f) * 0.15);
    }

    public int getLightBrightnessForSkyBlocks(World world, int par1, int par2, int par3, int par4) {
        int i1 = this.getSkyBlockTypeBrightness(world, EnumSkyBlock.Sky, par1, par2, par3);
        int j1 = this.getSkyBlockTypeBrightness(world, EnumSkyBlock.Block, par1, par2, par3);
        if (j1 < par4) {
            j1 = par4;
        }
        return i1 << 20 | j1 << 4;
    }

    public int getSkyBlockTypeBrightness(World world, EnumSkyBlock par1EnumSkyBlock, int par2, int par3, int par4) {
        if (world.field_73011_w.field_76576_e && par1EnumSkyBlock == EnumSkyBlock.Sky) {
            return 0;
        }
        if (par3 < 0) {
            par3 = 0;
        }
        if (par3 >= 256) {
            return par1EnumSkyBlock.field_77198_c;
        }
        if (par2 >= -30000000 && par4 >= -30000000 && par2 < 30000000 && par4 < 30000000) {
            int l = par2 >> 4;
            int i1 = par4 >> 4;
            if (!world.func_72863_F().func_73149_a(l, i1)) {
                return par1EnumSkyBlock.field_77198_c;
            }
            if (Block.field_71982_s[world.func_72798_a(par2, par3, par4)]) {
                int j1 = world.func_72972_b(par1EnumSkyBlock, par2, par3 + 1, par4);
                int k1 = world.func_72972_b(par1EnumSkyBlock, par2 + 1, par3, par4);
                int l1 = world.func_72972_b(par1EnumSkyBlock, par2 - 1, par3, par4);
                int i2 = world.func_72972_b(par1EnumSkyBlock, par2, par3, par4 + 1);
                int j2 = world.func_72972_b(par1EnumSkyBlock, par2, par3, par4 - 1);
                if (k1 > j1) {
                    j1 = k1;
                }
                if (l1 > j1) {
                    j1 = l1;
                }
                if (i2 > j1) {
                    j1 = i2;
                }
                if (j2 > j1) {
                    j1 = j2;
                }
                return j1;
            }
            Chunk chunk = world.func_72964_e(l, i1);
            return chunk.func_76614_a(par1EnumSkyBlock, par2 & 0xF, par3, par4 & 0xF);
        }
        return par1EnumSkyBlock.field_77198_c;
    }

    public float getSunBrightness(World world, float par1) {
        float f1 = world.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(world.func_72867_j(par1) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(world.func_72819_i(par1) * 5.0f) / 16.0));
        return f2 * 0.8f + 0.2f;
    }

    @Override
    public boolean matches(Environment.Salinity salt, int temp, Environment.Salinity[] salinity, int[] temperature) {
        if (salinity == null || temperature == null) {
            return false;
        }
        if (temperature.length != 2) {
            return false;
        }
        if (temp >= temperature[0] && temp <= temperature[1]) {
            for (Environment.Salinity s : salinity) {
                if (s != salt) continue;
                return true;
            }
        }
        return false;
    }

    public static class BiomeData {
        int temperature;
        Environment.Salinity salinity;

        public BiomeData(int temperature, Environment.Salinity salinity) {
            this.temperature = temperature;
            this.salinity = salinity;
        }
    }
}

