/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.HashMap;
import mariculture.api.core.ICastingHandler;
import mariculture.api.core.RecipeCasting;
import mariculture.core.helpers.OreDicHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CastingHandler
implements ICastingHandler {
    private final HashMap<String, RecipeCasting> nuggets = new HashMap();
    private final HashMap<String, RecipeCasting> ingots = new HashMap();
    private final HashMap<String, RecipeCasting> blocks = new HashMap();

    @Override
    public void addRecipe(RecipeCasting recipe) {
        if (recipe instanceof RecipeCasting.RecipeNuggetCasting) {
            this.nuggets.put(recipe.fluid.getFluid().getName(), (RecipeCasting.RecipeNuggetCasting)recipe);
        }
        if (recipe instanceof RecipeCasting.RecipeIngotCasting) {
            this.ingots.put(recipe.fluid.getFluid().getName(), (RecipeCasting.RecipeIngotCasting)recipe);
        }
        if (recipe instanceof RecipeCasting.RecipeBlockCasting) {
            this.blocks.put(recipe.fluid.getFluid().getName(), (RecipeCasting.RecipeBlockCasting)recipe);
        }
    }

    @Override
    public RecipeCasting getNuggetResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.nuggets.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    @Override
    public RecipeCasting getIngotResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.ingots.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    @Override
    public RecipeCasting getBlockResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.blocks.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    public static Icon getTexture(ItemStack stack) {
        String name = OreDicHelper.getDictionaryName(stack);
        name = name.substring(5);
        name = "block" + name;
        if (OreDictionary.getOres((String)name).size() > 0) {
            ItemStack block = (ItemStack)OreDictionary.getOres((String)name).get(0);
            if (Block.field_71973_m[block.field_77993_c] != null) {
                return Block.field_71973_m[block.field_77993_c].func_71858_a(0, block.func_77960_j());
            }
        }
        return Block.field_72083_ai.func_71858_a(0, 0);
    }

    @Override
    public HashMap<String, RecipeCasting> getNuggetRecipes() {
        return this.nuggets;
    }

    @Override
    public HashMap<String, RecipeCasting> getIngotRecipes() {
        return this.ingots;
    }

    @Override
    public HashMap<String, RecipeCasting> getBlockRecipes() {
        return this.blocks;
    }
}

