/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.gui.feature;

import java.util.List;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.Feature;
import mariculture.core.util.ITank;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FeatureTank
extends Feature {
    private ITank tank;
    private int yPoz;
    private int xPoz;
    private TankSize size;

    public FeatureTank(ITank tank, int x, int y, TankSize size) {
        this.yPoz = y;
        this.xPoz = x;
        this.size = size;
        this.tank = tank;
    }

    @Override
    public void addTooltip(List tooltip, int mouseX, int mouseY) {
        int xPlus;
        int n = xPlus = this.size == TankSize.SINGLE ? 17 : 35;
        if (mouseX >= this.xPoz - 1 && mouseX <= this.xPoz + xPlus - 1 && mouseY >= this.yPoz - 1 && mouseY <= this.yPoz + 59 - 1) {
            tooltip.add(this.tank.getFluidName());
            tooltip = this.tank.getFluidQty(tooltip);
        }
    }

    @Override
    public void draw(GuiMariculture gui, int x, int y, int mouseX, int mouseY) {
        super.draw(gui, x, y, mouseX, mouseY);
        int height = this.tank.getTankScaled(58);
        FluidStack liquid = this.tank.getFluid();
        if (liquid == null) {
            return;
        }
        int start = 0;
        Icon liquidIcon = null;
        Fluid fluid = liquid.getFluid();
        if (fluid != null && fluid.getStillIcon() != null) {
            liquidIcon = fluid.getStillIcon();
        }
        this.tm.func_110577_a(TextureMap.field_110575_b);
        if (liquidIcon != null) {
            int i;
            do {
                if (height > 16) {
                    i = 16;
                    height -= 16;
                } else {
                    i = height;
                    height = 0;
                }
                gui.func_94065_a(x + this.xPoz, y + this.yPoz + 58 - i - start, liquidIcon, 16, 16 - (16 - i));
                if (this.size.equals((Object)TankSize.DOUBLE)) {
                    gui.func_94065_a(x + this.xPoz + 10, y + this.yPoz + 58 - i - start, liquidIcon, 16, 16 - (16 - i));
                    gui.func_94065_a(x + this.xPoz + 18, y + this.yPoz + 58 - i - start, liquidIcon, 16, 16 - (16 - i));
                }
                start += 16;
            } while (i != 0 && height != 0);
        }
        this.tm.func_110577_a(texture);
        int width = this.size.equals((Object)TankSize.DOUBLE) ? 34 : 16;
        int xStart = this.size.equals((Object)TankSize.DOUBLE) ? 16 : 0;
        gui.func_73729_b(x + this.xPoz, y + this.yPoz, xStart, 0, width, 60);
    }

    public static enum TankSize {
        SINGLE,
        DOUBLE,
        VAT,
        CASTER,
        BLOCK_CASTER;

    }
}

