/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks.base;

import java.util.List;
import mariculture.core.blocks.base.TileMultiStorage;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.core.util.ITank;
import mariculture.core.util.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileMultiStorageTank
extends TileMultiStorage
implements IFluidHandler,
ITank {
    public Tank tank;

    @Override
    public FluidStack getFluid(int transfer) {
        if (this.getMaster() == null) {
            return null;
        }
        TileMultiStorageTank mstr = (TileMultiStorageTank)this.field_70331_k.func_72796_p(this.master.xCoord, this.master.yCoord, this.master.zCoord);
        if (mstr.tank.getFluid() == null) {
            return null;
        }
        if (mstr.tank.getFluidAmount() - transfer < 0) {
            return null;
        }
        return new FluidStack(mstr.tank.getFluidID(), transfer);
    }

    @Override
    public int getTankScaled(int i) {
        int qty = this.tank.getFluidAmount();
        int max = this.tank.getCapacity();
        return max != 0 ? qty * i / max : 0;
    }

    @Override
    public FluidStack getFluid() {
        return this.getMaster() != null ? ((TileMultiStorageTank)this.field_70331_k.func_72796_p((int)this.master.xCoord, (int)this.master.yCoord, (int)this.master.zCoord)).tank.getFluid() : null;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        if (this.getMaster() != null) {
            ((TileMultiStorageTank)this.field_70331_k.func_72796_p((int)this.master.xCoord, (int)this.master.yCoord, (int)this.master.zCoord)).tank.setFluid(fluid);
        }
    }

    @Override
    public String getFluidName() {
        return StringHelper.getFluidName(this.tank.getFluid());
    }

    @Override
    public List getFluidQty(List tooltip) {
        return StringHelper.getFluidQty(tooltip, this.tank.getFluid(), this.tank.getCapacity());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.getMaster() != null ? ((TileMultiStorageTank)this.field_70331_k.func_72796_p((int)this.master.xCoord, (int)this.master.yCoord, (int)this.master.zCoord)).tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getMaster() != null ? ((TileMultiStorageTank)this.field_70331_k.func_72796_p((int)this.master.xCoord, (int)this.master.yCoord, (int)this.master.zCoord)).tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.getMaster() != null) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = ((TileMultiStorageTank)this.field_70331_k.func_72796_p((int)this.master.xCoord, (int)this.master.yCoord, (int)this.master.zCoord)).tank.getInfo();
        } else {
            fluidTankInfoArray = null;
        }
        return fluidTankInfoArray;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public FluidStack getFluid(byte tank) {
        return this.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        this.setFluid(fluid);
    }
}

