/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks.base;

import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.blocks.base.TileStorageTank;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.lib.Extra;
import mariculture.core.network.Packets;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IMachine;
import mariculture.core.util.IProgressable;
import mariculture.core.util.IRedstoneControlled;
import mariculture.core.util.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileMachineTank
extends TileStorageTank
implements IUpgradable,
IMachine,
ISidedInventory,
IRedstoneControlled,
IEjectable,
IProgressable {
    protected BlockTransferHelper helper;
    private int machineTick = 0;
    protected int purity = 0;
    protected int heat = 0;
    protected int storage = 0;
    protected int speed = 0;
    protected int rf = 0;
    protected FeatureEject.EjectSetting setting;
    protected FeatureRedstone.RedstoneMode mode;
    protected int offset = 6;
    protected int max;
    protected boolean canWork;
    protected int processed = 0;

    public TileMachineTank() {
        this.inventory = new ItemStack[5];
        this.tank = new Tank(this.getTankCapacity(0));
        this.mode = FeatureRedstone.RedstoneMode.LOW;
        this.setting = FeatureEject.EjectSetting.NONE;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public ItemStack[] getUpgrades() {
        return new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
    }

    @Override
    public void updateUpgrades() {
        this.purity = MaricultureHandlers.upgrades.getData("purity", this);
        this.heat = MaricultureHandlers.upgrades.getData("temp", this);
        this.storage = MaricultureHandlers.upgrades.getData("storage", this);
        this.speed = MaricultureHandlers.upgrades.getData("speed", this);
        this.rf = MaricultureHandlers.upgrades.getData("rf", this);
        this.tank.setCapacity(this.getTankCapacity(this.storage));
        if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
            this.tank.setFluidAmount(this.tank.getCapacity());
        }
    }

    public int getTankCapacity(int storage) {
        int tankRate = 1000;
        return tankRate * 20 + storage * tankRate;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        ++this.machineTick;
        if (this.onTick(20)) {
            FluidHelper.process(this, 3, 4);
            this.updateUpgrades();
        }
        if (this.onTick(Extra.CAN_WORK_TICK)) {
            this.canWork = this.canWork();
        }
        this.updateMachine();
    }

    public abstract boolean canWork();

    public abstract void updateMachine();

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.mode = FeatureRedstone.RedstoneMode.values()[value];
                break;
            }
            case 1: {
                this.setting = FeatureEject.EjectSetting.values()[value];
                break;
            }
            case 2: {
                this.processed = value;
                break;
            }
            case 3: {
                this.tank.setFluidID(value);
                break;
            }
            case 4: {
                this.tank.setFluidAmount(value);
                break;
            }
            case 5: {
                this.tank.setCapacity(value);
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        Packets.updateGUI(player, container, 0, this.mode.ordinal());
        Packets.updateGUI(player, container, 1, this.setting.ordinal());
        Packets.updateGUI(player, container, 2, this.processed);
        Packets.updateGUI(player, container, 3, this.tank.getFluidID());
        Packets.updateGUI(player, container, 4, this.tank.getFluidAmount());
        Packets.updateGUI(player, container, 5, this.tank.getCapacity());
    }

    @Override
    public FeatureRedstone.RedstoneMode getRSMode() {
        return this.mode != null ? this.mode : FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public void setRSMode(FeatureRedstone.RedstoneMode mode) {
        this.mode = mode;
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return this.setting != null ? this.setting : FeatureEject.EjectSetting.NONE;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
        this.setting = setting;
    }

    @Override
    public int getProgressScaled(int scale) {
        return this.processed * scale / this.max;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setting = FeatureEject.EjectSetting.readFromNBT(nbt);
        this.mode = FeatureRedstone.RedstoneMode.readFromNBT(nbt);
        this.purity = nbt.func_74762_e("Purity");
        this.heat = nbt.func_74762_e("Heat");
        this.storage = nbt.func_74762_e("Storage");
        this.speed = nbt.func_74762_e("Speed");
        this.rf = nbt.func_74762_e("RF");
        this.canWork = nbt.func_74767_n("CanWork");
        this.processed = nbt.func_74762_e("Processed");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        FeatureEject.EjectSetting.writeToNBT(nbt, this.setting);
        FeatureRedstone.RedstoneMode.writeToNBT(nbt, this.mode);
        nbt.func_74768_a("Purity", this.purity);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74768_a("Storage", this.storage);
        nbt.func_74768_a("Speed", this.speed);
        nbt.func_74768_a("RF", this.rf);
        nbt.func_74757_a("CanWork", this.canWork);
        nbt.func_74768_a("Processed", this.processed);
    }
}

