/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import mariculture.core.blocks.base.TileMachine;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.network.Packets;
import mariculture.core.util.IPowered;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileMachinePowered
extends TileMachine
implements IEnergyHandler,
IPowered {
    protected EnergyStorage energyStorage = new EnergyStorage(this.getRFCapacity());

    public TileMachinePowered() {
        this.inventory = new ItemStack[4];
        this.offset = 4;
    }

    public abstract int getRFCapacity();

    @Override
    public void updateUpgrades() {
        super.updateUpgrades();
        this.energyStorage.setCapacity(this.getRFCapacity() + this.rf);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    public String getPowerText() {
        return this.getEnergyStored(ForgeDirection.UNKNOWN) + " / " + this.getMaxEnergyStored(ForgeDirection.UNKNOWN) + " RF";
    }

    @Override
    public int getPowerScaled(int i) {
        return this.energyStorage.getEnergyStored() * i / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.inventory[3] != null) {
            int drain;
            int rf;
            int n = rf = this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IEnergyContainerItem ? ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], 1000, true) : 0;
            if (rf > 0 && (drain = this.receiveEnergy(ForgeDirection.UP, rf, true)) > 0) {
                ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], drain, false);
                this.receiveEnergy(ForgeDirection.UP, drain, false);
            }
        }
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 3: {
                this.energyStorage.setEnergyStored(value);
                break;
            }
            case 4: {
                this.energyStorage.setCapacity(value);
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        super.sendGUINetworkData(container, player);
        Packets.updateGUI(player, container, 3, this.energyStorage.getEnergyStored());
        Packets.updateGUI(player, container, 4, this.energyStorage.getMaxEnergyStored());
    }
}

