/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import java.util.List;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.core.network.Packet118FluidUpdate;
import mariculture.core.network.Packets;
import mariculture.core.util.ITank;
import mariculture.core.util.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTankBlock
extends TileEntity
implements IFluidHandler,
ITank {
    public Tank tank = new Tank(16000);

    public float getFluidAmountScaled() {
        return (float)this.tank.getFluid().amount / ((float)this.tank.getCapacity() * 1.01f);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public boolean canUpdate() {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public FluidStack getFluid(int transfer) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        if (this.tank.getFluidAmount() - transfer < 0) {
            return null;
        }
        return new FluidStack(this.tank.getFluidID(), transfer);
    }

    @Override
    public String getFluidName() {
        return StringHelper.getFluidName(this.tank.getFluid());
    }

    @Override
    public List getFluidQty(List tooltip) {
        return StringHelper.getFluidQty(tooltip, this.tank.getFluid(), this.tank.getCapacity());
    }

    @Override
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Override
    public int getTankScaled(int i) {
        int qty = this.tank.getFluidAmount();
        int max = this.tank.getCapacity();
        return max != 0 ? qty * i / max : 0;
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid(byte tank) {
        return this.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        this.setFluid(fluid);
    }

    public double getCapacity() {
        return this.tank.getCapacity();
    }
}

