/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import mariculture.core.blocks.base.TileStorageTank;
import mariculture.core.network.Packet118FluidUpdate;
import mariculture.core.network.Packet120ItemSync;
import mariculture.core.network.Packets;
import mariculture.core.util.Tank;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileCooling
extends TileStorageTank
implements ISidedInventory {
    public boolean canWork;
    public int freezeTick;
    private int cooling;

    public TileCooling() {
        this.inventory = new ItemStack[this.getInventorySize()];
        this.tank = new Tank(this.getTankSize());
    }

    public abstract int getInventorySize();

    public abstract int getTankSize();

    public abstract int getTime();

    public abstract RecipeCasting getResult();

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.cooling <= 0) {
                this.cooling = Math.max(1, Environment.Temperature.getCoolingSpeed(MaricultureHandlers.environment.getBiomeTemperature(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)));
            }
            if (this.canWork) {
                this.freezeTick += this.cooling;
                if (this.freezeTick >= this.getTime()) {
                    RecipeCasting result = this.getResult();
                    if (result != null) {
                        for (int i = 0; i < this.inventory.length; ++i) {
                            if (this.inventory[i] != null || this.tank.getFluidAmount() < result.fluid.amount) continue;
                            this.drain(ForgeDirection.UP, result.fluid.amount, true);
                            this.func_70299_a(i, result.output.func_77946_l());
                            if (!this.canWork) break;
                        }
                    }
                    this.freezeTick = 0;
                }
            }
        }
    }

    public boolean canWork() {
        return !this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.hasRoom() && this.canFreeze();
    }

    public boolean canFreeze() {
        return this.getResult() != null;
    }

    public boolean hasRoom() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            return true;
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_70331_k.field_72995_K) {
            this.canWork = this.canWork();
            Packets.updateTile(this, new Packet120ItemSync(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.inventory).build());
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (doFill) {
            if (amount > 0) {
                Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
                this.freezeTick = 0;
            }
            this.canWork = this.canWork();
        }
        return amount;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (doDrain) {
            if (amount != null) {
                Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
            }
            this.canWork = this.canWork();
        }
        return amount;
    }

    public abstract int[] func_94128_d(int var1);

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.freezeTick = nbt.func_74762_e("FreezeTick");
        this.cooling = nbt.func_74762_e("CoolingSpeed");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("FreezeTick", this.freezeTick);
        nbt.func_74768_a("CoolingSpeed", this.cooling);
    }
}

