/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mariculture.api.core.IAnvilHandler;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileStorage;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.items.ItemWorked;
import mariculture.core.network.Packet120ItemSync;
import mariculture.core.network.Packets;
import mariculture.core.util.Rand;
import mariculture.magic.Magic;
import mariculture.magic.jewelry.ItemJewelry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;

public class TileAnvil
extends TileStorage
implements ISidedInventory,
IAnvilHandler {
    private static final HashMap<String, IAnvilHandler.RecipeAnvil> recipes = new HashMap();

    public TileAnvil() {
        this.inventory = new ItemStack[1];
    }

    @Override
    public void addRecipe(IAnvilHandler.RecipeAnvil recipe) {
        recipes.put(OreDicHelper.convert(recipe.input), recipe);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_70331_k.field_72995_K) {
            Packets.updateTile(this, new Packet120ItemSync(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.inventory).build());
        }
    }

    public boolean canBeWorked(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemWorked) {
            return true;
        }
        IAnvilHandler.RecipeAnvil result = recipes.get(OreDicHelper.convert(stack));
        return result != null;
    }

    public boolean canBeRepaired(ItemStack stack) {
        return stack.func_77984_f() && stack.func_77951_h() && stack.func_77973_b().isRepairable() ? stack.func_77960_j() > 0 : stack.func_77973_b() instanceof ItemJewelry && stack.func_77960_j() > 0;
    }

    public boolean workItem(EntityPlayer player, ItemStack hammer) {
        if (hammer == null) {
            return false;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return false;
        }
        if (!this.canBeWorked(stack)) {
            float drop;
            int modifier = 1;
            if (stack.func_77948_v()) {
                LinkedHashMap maps = (LinkedHashMap)EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Map.Entry i : maps.entrySet()) {
                    int total = (Integer)maps.entrySet().iterator().next().getValue();
                    Enchantment enchant = Enchantment.field_77331_b[(Integer)maps.keySet().iterator().next()];
                    int bonus = enchant.func_77317_b(1) - enchant.func_77321_a(1);
                    modifier += total + bonus;
                }
                int n = modifier = (modifier /= 3) >= 1 ? modifier : 1;
                if (stack.func_77973_b() instanceof ItemJewelry) {
                    modifier *= 2;
                }
            }
            if ((player.field_71106_cc >= (drop = 1.0f / (float)(player.func_71050_bK() * 1) / 4.0f * (float)modifier) || player.field_71068_ca > 0) && this.canBeRepaired(stack)) {
                float experience;
                if (EnchantHelper.hasEnchantment(Magic.luck, hammer)) {
                    for (int i = 0; i < EnchantmentHelper.func_77506_a((int)Magic.luck.field_77352_x, (ItemStack)hammer); ++i) {
                        if (!Rand.nextInt(3)) continue;
                        stack.func_77964_b(stack.func_77960_j() - 1);
                    }
                }
                stack.func_77964_b(stack.func_77960_j() - 1);
                if (stack.func_77960_j() < 0) {
                    stack.func_77964_b(0);
                }
                if ((experience = player.field_71106_cc - drop) <= 0.0f) {
                    player.field_71106_cc = 1.0f;
                    --player.field_71068_ca;
                } else {
                    player.field_71106_cc = experience;
                }
                if (stack.func_77960_j() == 0) {
                    this.field_70331_k.func_72869_a("hugeexplosion", (double)this.field_70329_l + 0.5, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.5, 0.0, 0.0, 0.0);
                } else {
                    this.field_70331_k.func_72869_a("explode", (double)this.field_70329_l + 0.5, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.5, 0.0, 0.0, 0.0);
                }
                if (this.field_70331_k.field_72995_K) {
                    this.field_70331_k.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemWorked)) {
            IAnvilHandler.RecipeAnvil recipe = recipes.get(OreDicHelper.convert(stack));
            this.func_70299_a(0, this.createWorkedItem(recipe.output.func_77946_l(), recipe.hits));
            this.field_70331_k.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
            return true;
        }
        int workedVal = stack.field_77990_d.func_74762_e("Worked") + 1;
        if (EnchantHelper.hasEnchantment(Magic.luck, hammer)) {
            for (int i = 0; i < EnchantmentHelper.func_77506_a((int)Magic.luck.field_77352_x, (ItemStack)hammer); ++i) {
                if (!Rand.nextInt(3)) continue;
                ++workedVal;
            }
        }
        stack.field_77990_d.func_74768_a("Worked", workedVal);
        if (workedVal >= stack.field_77990_d.func_74762_e("Required")) {
            ItemStack result = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("WorkedItem"));
            this.func_70299_a(0, result);
            this.field_70331_k.func_72869_a("hugeexplosion", (double)this.field_70329_l + 0.5, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.5, 0.0, 0.0, 0.0);
            this.field_70331_k.func_72956_a((Entity)player, "mariculture:bang", 1.0f, 1.0f);
            return true;
        }
        this.field_70331_k.func_72869_a("explode", (double)this.field_70329_l + 0.5, (double)(this.field_70330_m + 1), (double)this.field_70327_n + 0.5, 0.0, 0.0, 0.0);
        this.field_70331_k.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
        return true;
    }

    @Override
    public ItemStack createWorkedItem(ItemStack output, int hits) {
        ItemStack worked = new ItemStack(Core.worked);
        worked.func_77982_d(new NBTTagCompound());
        worked.field_77990_d.func_74768_a("Worked", 0);
        worked.field_77990_d.func_74768_a("Required", hits);
        worked.field_77990_d.func_74766_a("WorkedItem", output.func_77955_b(new NBTTagCompound()));
        return worked;
    }

    public Packet func_70319_e() {
        return new Packet120ItemSync(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.inventory).build();
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side == ForgeDirection.UP.ordinal() && this.inventory[0] == null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (stack.func_77973_b() instanceof ItemWorked) {
            return side == ForgeDirection.UP.ordinal();
        }
        return true;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public HashMap<String, IAnvilHandler.RecipeAnvil> getRecipes() {
        return recipes;
    }
}

