/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.core.Core;
import mariculture.core.blocks.BlockMachine;
import mariculture.core.blocks.TileBookshelf;
import mariculture.core.blocks.TileLiquifier;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.Modules;
import mariculture.core.network.Packet101Sponge;
import mariculture.core.network.Packets;
import mariculture.core.util.IHasGUI;
import mariculture.factory.blocks.TileDictionary;
import mariculture.factory.blocks.TileFishSorter;
import mariculture.factory.blocks.TileSawmill;
import mariculture.factory.blocks.TileSluice;
import mariculture.factory.blocks.TileSponge;
import mariculture.fishery.blocks.TileAutofisher;
import mariculture.fishery.blocks.TileIncubator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockUtil
extends BlockMachine {
    private Icon[] incubatorIcons;
    private Icon sluiceBack;
    private Icon sluiceUp;
    private Icon sluiceDown;
    private Icon[] liquifierIcons;
    private Icon[] fishSorter;

    public BlockUtil(int i) {
        super(i, Material.field_76233_E);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 2: {
                return 1.5f;
            }
            case 6: {
                return 1.0f;
            }
            case 10: {
                return 2.0f;
            }
            case 0: {
                return 10.0f;
            }
            case 1: {
                return 6.0f;
            }
            case 3: {
                return 5.0f;
            }
            case 7: {
                return 2.0f;
            }
            case 8: {
                return 4.0f;
            }
            case 9: {
                return 3.0f;
            }
            case 4: {
                return 1.0f;
            }
        }
        return 3.0f;
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 6 ? 5.0f : 0.0f;
    }

    @Override
    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockBreak();
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public Icon func_71858_a(int side, int meta) {
        if (meta < this.getMetaCount()) {
            switch (meta) {
                case 3: {
                    return side > 1 ? this.icons[meta] : Core.ores.func_71858_a(side, 13);
                }
                case 7: {
                    return side > 1 ? this.icons[meta] : Core.wood.func_71858_a(side, 0);
                }
                case 2: {
                    return side > 1 ? this.icons[meta] : Core.wood.func_71858_a(side, 0);
                }
                case 10: {
                    return side > 1 ? this.icons[meta] : Core.wood.func_71858_a(side, 0);
                }
                case 8: {
                    return side == 4 ? this.icons[meta] : Core.ores.func_71858_a(side, 14);
                }
                case 9: {
                    return side > 1 ? this.icons[meta] : Core.ores.func_71858_a(side, 14);
                }
                case 4: {
                    return this.fishSorter[side];
                }
            }
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        if (block.func_72796_p(x, y, z) instanceof TileBookshelf) {
            return Block.field_72093_an.func_71858_a(side, 0);
        }
        if (block.func_72796_p(x, y, z) instanceof TileSluice) {
            TileSluice tile = (TileSluice)block.func_72796_p(x, y, z);
            if (tile.direction.ordinal() == side) {
                return side > 1 ? this.icons[8] : this.sluiceUp;
            }
            if (tile.direction.getOpposite().ordinal() == side) {
                return side > 1 ? this.sluiceBack : this.sluiceDown;
            }
            return Core.ores.func_71858_a(side, 14);
        }
        if (side > 1 && side > 1) {
            TileEntity tile = block.func_72796_p(x, y, z);
            if (tile instanceof TileLiquifier) {
                TileLiquifier crucible = (TileLiquifier)tile;
                if (crucible.master == null) {
                    return this.func_71858_a(side, 3);
                }
                if (crucible.isMaster()) {
                    return this.liquifierIcons[1];
                }
                return this.liquifierIcons[0];
            }
            if (tile instanceof TileIncubator && block.func_72805_g(x, y, z) != 0) {
                TileIncubator incubator = (TileIncubator)tile;
                if (incubator.master == null) {
                    return this.func_71858_a(side, 1);
                }
                if (incubator.facing == ForgeDirection.DOWN) {
                    return this.incubatorIcons[0];
                }
                return this.incubatorIcons[1];
            }
        }
        return this.func_71858_a(side, block.func_72805_g(x, y, z));
    }

    public int func_71885_a(int i, Random random, int j) {
        return this.field_71990_ca;
    }

    public int func_71899_b(int i) {
        return i;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_72796_p(x, y, z);
        int facing = BlockPistonBase.func_72116_b((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        if (tile != null && tile instanceof TileSluice) {
            ((TileSluice)tile).direction = ForgeDirection.getOrientation((int)facing);
            Packets.updateTile((TileSluice)tile, ((TileSluice)tile).func_70319_e());
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int i, float f, float g, float t) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null && world.func_72805_g(x, y, z) != 1 || player.func_70093_af()) {
            return false;
        }
        if (tile instanceof TileSluice) {
            return false;
        }
        if (tile instanceof TileMultiBlock) {
            TileMultiBlock multi = (TileMultiBlock)tile;
            if (multi.master != null) {
                player.openGui((Object)Mariculture.instance, -1, world, multi.master.xCoord, multi.master.yCoord, multi.master.zCoord);
                return true;
            }
            return false;
        }
        if (tile instanceof IHasGUI) {
            player.openGui((Object)Mariculture.instance, -1, world, x, y, z);
            return true;
        }
        if (tile instanceof TileSponge) {
            Item currentItem;
            if (world.field_72995_K && player instanceof EntityClientPlayerMP) {
                ((EntityClientPlayerMP)player).field_71174_a.func_72552_c(new Packet101Sponge(x, y, z).build());
            } else if (player.func_71045_bC() != null && !world.field_72995_K && (currentItem = player.func_71045_bC().func_77973_b()) instanceof IEnergyContainerItem && !world.field_72995_K) {
                int powerAdd = ((IEnergyContainerItem)currentItem).extractEnergy(player.func_71045_bC(), 5000, true);
                int reduce = ((IEnergyHandler)tile).receiveEnergy(ForgeDirection.UNKNOWN, powerAdd, false);
                ((IEnergyContainerItem)currentItem).extractEnergy(player.func_71045_bC(), reduce, false);
            }
            return true;
        }
        return true;
    }

    @Override
    public void func_71861_g(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockPlaced();
        }
        super.func_71861_g(world, x, y, z);
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileIncubator();
            }
            case 1: {
                return new TileIncubator();
            }
            case 2: {
                return new TileAutofisher();
            }
            case 3: {
                return new TileLiquifier();
            }
            case 6: {
                return new TileBookshelf();
            }
            case 7: {
                return new TileSawmill();
            }
            case 8: {
                return new TileSluice();
            }
            case 10: {
                return new TileDictionary();
            }
            case 9: {
                return new TileSponge();
            }
            case 4: {
                return new TileFishSorter();
            }
        }
        return null;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int i, int meta) {
        BlockHelper.dropItems(world, x, y, z);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockBreak();
        }
        super.func_71852_a(world, x, y, z, i, meta);
        if (meta == 8) {
            this.clearWater(world, x + 1, y, z);
            this.clearWater(world, x - 1, y, z);
            this.clearWater(world, x, y, z + 1);
            this.clearWater(world, x, y, z - 1);
        }
    }

    private void clearWater(World world, int x, int y, int z) {
        if (world.func_72803_f(x, y, z) == Material.field_76244_g) {
            world.func_94571_i(x, y, z);
        }
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 2: {
                return Modules.isActive(Modules.fishery);
            }
            case 7: {
                return Modules.isActive(Modules.factory);
            }
            case 0: {
                return Modules.isActive(Modules.fishery);
            }
            case 1: {
                return Modules.isActive(Modules.fishery);
            }
            case 8: {
                return Modules.isActive(Modules.factory);
            }
            case 9: {
                return Modules.isActive(Modules.factory);
            }
            case 10: {
                return Modules.isActive(Modules.factory);
            }
            case 4: {
                return Modules.isActive(Modules.factory);
            }
            case 5: {
                return false;
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        int i;
        this.incubatorIcons = new Icon[2];
        this.incubatorIcons[0] = iconRegister.func_94245_a("mariculture:incubatorBottom");
        this.incubatorIcons[1] = iconRegister.func_94245_a("mariculture:incubatorTopTop");
        this.liquifierIcons = new Icon[2];
        this.liquifierIcons[0] = iconRegister.func_94245_a("mariculture:liquifierTop");
        this.liquifierIcons[1] = iconRegister.func_94245_a("mariculture:liquifierBottom");
        this.fishSorter = new Icon[6];
        for (i = 0; i < 6; ++i) {
            this.fishSorter[i] = iconRegister.func_94245_a("mariculture:fishsorter" + (i + 1));
        }
        this.sluiceBack = iconRegister.func_94245_a("mariculture:sluiceBack");
        this.sluiceUp = iconRegister.func_94245_a("mariculture:sluiceUp");
        this.sluiceDown = iconRegister.func_94245_a("mariculture:sluiceDown");
        this.icons = new Icon[this.getMetaCount()];
        for (i = 0; i < this.icons.length; ++i) {
            if (!this.isActive(i)) continue;
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, i)));
        }
    }

    @Override
    public int getMetaCount() {
        return 11;
    }
}

