/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.core.Core;
import mariculture.core.blocks.TileTankBlock;
import mariculture.core.blocks.TileVoidBottle;
import mariculture.core.blocks.base.BlockConnected;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.Packet118FluidUpdate;
import mariculture.core.network.Packets;
import mariculture.factory.blocks.TileHDFPV;
import mariculture.fishery.blocks.TileFishTank;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockTank
extends BlockConnected {
    private static Icon[] fishTank = new Icon[47];

    public BlockTank(int i) {
        super(i, Material.field_76233_E);
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return RenderIds.BLOCK_TANKS;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileFishTank) {
            if (player.func_70093_af()) {
                return false;
            }
            player.openGui((Object)Mariculture.instance, -1, world, x, y, z);
            return true;
        }
        return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_72796_p(x, y, z), player, ForgeDirection.UP);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 2: {
                return new TileVoidBottle();
            }
            case 0: {
                return new TileTankBlock();
            }
            case 1: {
                return new TileFishTank();
            }
            case 3: {
                return new TileHDFPV();
            }
        }
        return new TileTankBlock();
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileTankBlock tank;
        FluidStack fluid;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTankBlock && (fluid = (tank = (TileTankBlock)tile).getFluid()) != null) {
            return fluid.getFluid().getLuminosity();
        }
        return 0;
    }

    @Override
    public int getMetaCount() {
        return 4;
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        if (block.func_72805_g(x, y, z) != 2) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_71905_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 2 ? null : super.func_71872_e(world, x, y, z);
    }

    @Override
    public int func_71885_a(int meta, Random random, int j) {
        switch (meta) {
            case 0: {
                return 0;
            }
            case 2: {
                return Core.bottles.field_77779_bT;
            }
        }
        return this.field_71990_ca;
    }

    @Override
    public int func_71899_b(int meta) {
        switch (meta) {
            case 2: {
                return 0;
            }
        }
        return meta;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int facing = BlockPistonBase.func_72116_b((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null) {
            return;
        }
        if (tile instanceof TileFishTank) {
            ((TileFishTank)tile).orientation = ForgeDirection.getOrientation((int)facing);
        }
        if (stack.func_77942_o() && world.func_72805_g(x, y, z) == 0 && tile instanceof TileTankBlock) {
            TileTankBlock tank = (TileTankBlock)tile;
            tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d));
            if (!world.field_72995_K) {
                Packets.updateTile(tank, new Packet118FluidUpdate(x, y, z, tank.getFluid()).build());
            }
        }
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 0 && !player.field_71075_bZ.field_75098_d) {
            ItemStack drop = new ItemStack(Core.tanks, 1, 0);
            TileTankBlock tank = (TileTankBlock)world.func_72796_p(x, y, z);
            if (tank != null && tank.getFluid() != null) {
                if (!drop.func_77942_o()) {
                    drop.func_77982_d(new NBTTagCompound());
                }
                tank.getFluid().writeToNBT(drop.field_77990_d);
            }
            EntityItem entity = new EntityItem(world, (double)x, (double)((float)y + 1.0f), (double)z, new ItemStack(drop.field_77993_c, 1, drop.func_77960_j()));
            if (drop.func_77942_o()) {
                entity.func_92059_d().func_77982_d((NBTTagCompound)drop.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entity);
        }
        return world.func_94571_i(x, y, z);
    }

    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            for (int j = 0; j < 2; ++j) {
                float f = rand.nextFloat() - rand.nextFloat();
                float f1 = rand.nextFloat() - rand.nextFloat();
                float f2 = rand.nextFloat() - rand.nextFloat();
                world.func_72869_a("magicCrit", (double)x + 0.5 + (double)f, (double)y + 0.5 + (double)f1, (double)z + 0.5 + (double)f2, 0.0, 0.0, 0.0);
                world.func_72869_a("witchMagic", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 1: {
                return Modules.isActive(Modules.fishery);
            }
            case 3: {
                return false;
            }
        }
        return meta != 2;
    }

    public void func_71852_a(World world, int x, int y, int z, int i, int j) {
        BlockHelper.dropFish(world, x, y, z);
        super.func_71852_a(world, x, y, z, i, j);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, i)) + "Tank");
        }
        this.registerConnectedTextures(iconRegister);
    }

    @Override
    public Icon[] getTexture(int meta) {
        return meta == 1 ? fishTank : null;
    }

    @Override
    public void registerConnectedTextures(IconRegister iconRegister) {
        for (int i = 0; i < 47; ++i) {
            BlockTank.fishTank[i] = iconRegister.func_94245_a("mariculture:fishTank/" + (i + 1));
        }
    }
}

