/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RodQuality;
import mariculture.core.Core;
import mariculture.core.blocks.BlockMachine;
import mariculture.core.blocks.TileOyster;
import mariculture.core.handlers.PearlGenHandler;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.render.RenderOyster;
import mariculture.core.util.Rand;
import mariculture.fishery.Fishery;
import mariculture.fishery.items.ItemFishy;
import mariculture.plugins.enchiridion.EventHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockOyster
extends BlockMachine {
    private final Random rand = new Random();
    public static int NET = 4;

    public BlockOyster(int i) {
        super(i, Material.field_76260_u);
        this.func_71907_b(true);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != NET) {
            return this.field_71989_cb;
        }
        return 0.05f;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return RenderIds.BLOCK_SINGLE;
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == NET) {
            return true;
        }
        if (world.func_72803_f(x, y + 1, z) != Material.field_76244_g) {
            return false;
        }
        return world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP);
    }

    public void func_71863_a(World world, int x, int y, int z, int par5) {
        if (world.func_72805_g(x, y, z) != NET) {
            if (!this.func_71854_d(world, x, y, z)) {
                this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_94575_c(x, y, z, 0);
            }
        } else if (Modules.isActive(Modules.fishery) && !BlockHelper.isFishable(world, x, y - 1, z)) {
            SpawnItemHelper.spawnItem(world, x, y, z, new ItemStack(Fishery.net));
            world.func_94575_c(x, y, z, 0);
        }
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        if (block.func_72805_g(x, y, z) != NET) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1f, 1.0f);
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.015625f, 1.0f);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != NET) {
            return super.func_71872_e(world, x, y, z);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    public int func_71885_a(int i, Random random, int j) {
        if (i != NET) {
            return this.field_71990_ca;
        }
        return Fishery.net.field_77779_bT;
    }

    public int func_71899_b(int i) {
        return 0;
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            int facing = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            if (facing == 0) {
                world.func_72921_c(x, y, z, 0, 2);
            }
            if (facing == 1) {
                world.func_72921_c(x, y, z, 3, 2);
            }
            if (facing == 2) {
                world.func_72921_c(x, y, z, 1, 2);
            }
            if (facing == 3) {
                world.func_72921_c(x, y, z, 2, 2);
            }
        }
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        if (!Extra.DEBUG_ON && !BlockHelper.isWater(world, x, y + 1, z)) {
            return false;
        }
        int id = world.func_72798_a(x, y, z);
        return id == 0 || BlockOyster.field_71973_m[id].field_72018_cp.func_76222_j();
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity tile_entity = world.func_72796_p(x, y, z);
        if (tile_entity == null || player.func_70093_af() && !Extra.DEBUG_ON) {
            return false;
        }
        if (tile_entity instanceof TileOyster) {
            TileOyster oyster = (TileOyster)tile_entity;
            if (Extra.SPAWN_BOOKS && Modules.isActive(Modules.magic)) {
                EventHandler.spawnBook(player, 3);
            }
            if (!player.func_70093_af() && !world.field_72995_K) {
                if (player.func_71045_bC() != null && player.func_71045_bC().field_77993_c == Block.field_71939_E.field_71990_ca && !oyster.hasContents()) {
                    oyster.func_70299_a(0, new ItemStack(Block.field_71939_E));
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    return true;
                }
                BlockHelper.dropItems(world, x, y, z);
                oyster.func_70299_a(0, null);
                return true;
            }
            if (player.func_70093_af() && Extra.DEBUG_ON) {
                player.openGui((Object)Mariculture.instance, 0, world, x, y, z);
                return true;
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta != NET ? new TileOyster() : null;
    }

    @Override
    public String getName(ItemStack stack) {
        return stack.func_77960_j() != NET ? "oyster" : "net";
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        ItemStack loot;
        if (world.func_72805_g(x, y, z) != NET) {
            TileOyster oyster = (TileOyster)world.func_72796_p(x, y, z);
            if (!world.field_72995_K && oyster != null && oyster.hasSand() && BlockHelper.isWater(world, x, y + 1, z) && rand.nextInt(Extra.PEARL_GEN_CHANCE) == 0) {
                if (world.field_73011_w.field_76574_g == 1) {
                    oyster.func_70299_a(0, new ItemStack(Item.field_77730_bn));
                } else if (world.func_72798_a(x, y - 1, z) == Core.pearl.field_71990_ca) {
                    oyster.func_70299_a(0, new ItemStack(Core.pearls, 1, world.func_72805_g(x, y - 1, z)));
                } else {
                    oyster.func_70299_a(0, PearlGenHandler.getRandomPearl(rand));
                }
            }
        } else if (Rand.nextInt(MachineSpeeds.getNetSpeed()) && (loot = this.getFish(world, x, y, z)) != null) {
            if (loot.func_77973_b() instanceof ItemFishy) {
                SpawnItemHelper.spawnItem(world, x, y, z, loot, true, Short.MAX_VALUE);
            } else {
                SpawnItemHelper.spawnItem(world, x, y, z, loot, true, Short.MAX_VALUE);
            }
        }
    }

    private ItemStack getFish(World world, int x, int y, int z) {
        ItemStack loot = Fishing.loot.getLoot(this.rand, RodQuality.OLD, world, x, y, z);
        for (int i = 0; i < 20; ++i) {
            if (loot != null && loot.func_77973_b() instanceof ItemFishy) {
                return loot;
            }
            loot = Fishing.loot.getLoot(this.rand, RodQuality.OLD, world, x, y, z);
        }
        return new ItemStack(Item.field_77754_aU);
    }

    @Override
    public Icon func_71858_a(int side, int meta) {
        return meta < NET ? this.icons[0] : this.icons[1];
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) < NET ? 1 : 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == NET && Modules.isActive(Modules.fishery)) {
            return new ItemStack(Fishery.net, 1, 0);
        }
        return new ItemStack((Block)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[2];
        this.icons[0] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, 0)));
        this.icons[1] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, NET)));
        RenderOyster.lid_blur = iconRegister.func_94245_a("mariculture:oysterLidBlur");
        RenderOyster.lid = iconRegister.func_94245_a("mariculture:oysterLid");
        RenderOyster.tongue = iconRegister.func_94245_a("mariculture:oysterTongue");
    }
}

