/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.util.IItemRegistry;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockMachine
extends BlockContainer
implements IItemRegistry {
    protected Icon[] icons;

    public BlockMachine(int i, Material material) {
        super(i, material);
        this.func_71849_a(MaricultureTab.tabMariculture);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockBreak();
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public void func_71861_g(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockPlaced();
        }
        super.func_71861_g(world, x, y, z);
    }

    public void func_71852_a(World world, int x, int y, int z, int i, int meta) {
        BlockHelper.dropItems(world, x, y, z);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultiBlock) {
            ((TileMultiBlock)tile).onBlockBreak();
        }
        super.func_71852_a(world, x, y, z, i, meta);
    }

    @Override
    public void register() {
        for (int j = 0; j < this.getMetaCount(); ++j) {
            MaricultureRegistry.register(this.getName(new ItemStack(this.field_71990_ca, 1, j)), new ItemStack(this.field_71990_ca, 1, j));
        }
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return RegistryHelper.getName(stack);
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public boolean isActive(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs creative, List list) {
        for (int meta = 0; meta < this.getMetaCount(); ++meta) {
            if (!this.isActive(meta)) continue;
            list.add(new ItemStack(id, 1, meta));
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta < this.getMetaCount()) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, i)));
        }
    }
}

