/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidMari
extends BlockFluidClassic {
    public Icon[] still;
    public Icon[] flowing;
    private int tick;

    public BlockFluidMari(int id, Fluid fluid, Material material) {
        super(id, fluid, material);
        this.quantaPerBlock = 16;
        this.quantaPerBlockFloat = 16.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return meta == 0 ? Block.field_71943_B.func_71858_a(side, meta) : Block.field_71942_A.func_71858_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.flowing = new Icon[32];
        this.still = new Icon[32];
        for (int i = 0; i < this.flowing.length; ++i) {
            ItemStack bottle = new ItemStack(Core.bottles, 1, i);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bottle);
            if (fluid == null || fluid.getFluid() == null) continue;
            String name = fluid.getFluid().getName().replaceAll("\\.", "");
            if (name.contains("molten")) {
                name = "molten" + name.replaceAll("molten", "");
            }
            if (name.contains("fish")) {
                name = "fish" + name.replaceAll("fish", "");
            }
            if (name.contains("natural")) {
                name = "natural" + name.replaceAll("natural", "");
            }
            if (name.contains("normal") || name.contains("water") || name.contains("lava")) continue;
            this.flowing[i] = iconRegister.func_94245_a("mariculture:liquids/" + name + "_flow");
            this.still[i] = iconRegister.func_94245_a("mariculture:liquids/" + name + "_still");
        }
    }

    public FluidStack drain(World world, int x, int y, int z, boolean doDrain) {
        return null;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        super.func_71847_b(world, x, y, z, rand);
        ++this.tick;
        if (this.tick % 25 == 0 && !world.field_72995_K) {
            int z2;
            ForgeDirection dir = ForgeDirection.values()[rand.nextInt(6)];
            int x2 = x + dir.offsetX;
            int y2 = y - rand.nextInt(2);
            Block block = Block.field_71973_m[world.func_72798_a(x2, y2, z2 = z + dir.offsetZ)];
            if (block != null) {
                float hardnessMax = Block.field_71981_t.field_71989_cb;
                float blockHardness = block.func_71934_m(world, x2, y2, z2);
                if (blockHardness <= hardnessMax) {
                    BlockHelper.destroyBlock(world, x2, y2, z2);
                }
            }
        }
    }

    public void func_71901_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        Vec3 vec_flow = this.getFlowVector((IBlockAccess)world, x, y, z);
        double xSpeed = vec_flow.field_72450_a * 0.0845;
        double zSpeed = vec_flow.field_72449_c * 0.0845;
        entity.func_70024_g(xSpeed, 0.0, zSpeed);
    }
}

