/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.core.blocks.BlockMachine;
import mariculture.core.blocks.TileVat;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.Packet117AirCompressorUpdate;
import mariculture.core.network.Packets;
import mariculture.core.util.IHasGUI;
import mariculture.diving.Diving;
import mariculture.diving.TileAirCompressor;
import mariculture.factory.blocks.TilePressureVessel;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockDouble
extends BlockMachine {
    public Icon bar1;

    public BlockDouble(int i) {
        super(i, Material.field_76243_f);
        this.func_71868_h(0);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 5.0f;
            }
            case 1: {
                return 3.0f;
            }
            case 2: {
                return 6.0f;
            }
            case 3: {
                return 2.0f;
            }
        }
        return 3.0f;
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 2) {
            return true;
        }
        int count = 0;
        if (world.func_72798_a(x - 1, y, z) == this.field_71990_ca) {
            ++count;
        }
        if (world.func_72798_a(x + 1, y, z) == this.field_71990_ca) {
            ++count;
        }
        if (world.func_72798_a(x, y, z - 1) == this.field_71990_ca) {
            ++count;
        }
        if (world.func_72798_a(x, y, z + 1) == this.field_71990_ca) {
            ++count;
        }
        return count > 1 ? false : (this.isThereSameBlock(world, x - 1, y, z) ? false : (this.isThereSameBlock(world, x + 1, y, z) ? false : (this.isThereSameBlock(world, x, y, z - 1) ? false : !this.isThereSameBlock(world, x, y, z + 1))));
    }

    private boolean isThereSameBlock(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) != this.field_71990_ca ? false : (world.func_72798_a(x - 1, y, z) == this.field_71990_ca ? true : (world.func_72798_a(x + 1, y, z) == this.field_71990_ca ? true : (world.func_72798_a(x, y, z - 1) == this.field_71990_ca ? true : world.func_72798_a(x, y, z + 1) == this.field_71990_ca)));
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int j, float f, float g, float t) {
        TileAirCompressor compressor;
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null) {
            return false;
        }
        ItemStack held = player.func_71045_bC();
        if (tile instanceof TileMultiBlock && tile instanceof IHasGUI) {
            if (player.func_70093_af()) {
                return false;
            }
            TileMultiBlock multi = (TileMultiBlock)tile;
            if (multi.master != null) {
                player.openGui((Object)Mariculture.instance, -1, world, multi.master.xCoord, multi.master.yCoord, multi.master.zCoord);
                return true;
            }
            return false;
        }
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem != null && tile instanceof TileAirCompressor && (compressor = (TileAirCompressor)((TileAirCompressor)tile).getMaster()) != null) {
            int rf;
            int n = rf = heldItem.func_77973_b() instanceof IEnergyContainerItem ? ((IEnergyContainerItem)heldItem.func_77973_b()).extractEnergy(heldItem, 5000, true) : 0;
            if (rf > 0) {
                int drain = compressor.receiveEnergy(ForgeDirection.UP, rf, true);
                if (drain > 0) {
                    ((IEnergyContainerItem)heldItem.func_77973_b()).extractEnergy(heldItem, drain, false);
                    compressor.receiveEnergy(ForgeDirection.UP, drain, false);
                }
                return true;
            }
            if (heldItem.func_77973_b().field_77779_bT == Diving.scubaTank.field_77779_bT && heldItem.func_77960_j() > 1 && compressor.storedAir > 0) {
                heldItem.func_77964_b(heldItem.func_77960_j() - 1);
                if (!world.field_72995_K) {
                    --compressor.storedAir;
                    Packets.updateTile(compressor, new Packet117AirCompressorUpdate(compressor.field_70329_l, compressor.field_70330_m, compressor.field_70327_n, compressor.storedAir, compressor.getEnergyStored(ForgeDirection.UP)).build());
                }
                return true;
            }
        }
        if (tile instanceof TileVat) {
            TileVat vat = (TileVat)tile;
            ItemStack input = vat.func_70301_a(0);
            ItemStack output = vat.func_70301_a(1);
            if (FluidHelper.isFluidOrEmpty(held)) {
                return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_72796_p(x, y, z), player, ForgeDirection.UP);
            }
            if (output != null) {
                if (!player.field_71071_by.func_70441_a(vat.func_70301_a(1)) && !world.field_72995_K) {
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, vat.func_70301_a(1));
                }
                vat.func_70299_a(1, null);
                return true;
            }
            if (player.func_70093_af() && input != null) {
                if (!player.field_71071_by.func_70441_a(vat.func_70301_a(0)) && !world.field_72995_K) {
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, vat.func_70301_a(0));
                }
                vat.func_70299_a(0, null);
                return true;
            }
            if (held != null && !player.func_70093_af()) {
                if (input == null) {
                    if (!world.field_72995_K) {
                        ItemStack copy = held.func_77946_l();
                        copy.field_77994_a = 1;
                        vat.func_70299_a(0, copy);
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    }
                    return true;
                }
                if (ItemHelper.areItemStacksEqualNoNBT(input, held)) {
                    if (input.field_77994_a + 1 < input.func_77976_d()) {
                        if (!world.field_72995_K) {
                            ItemStack stack = input.func_77946_l();
                            ++stack.field_77994_a;
                            vat.func_70299_a(0, stack);
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        int meta = block.func_72805_g(x, y, z);
        switch (meta) {
            case 1: {
                this.func_71905_a(0.05f, 0.0f, 0.05f, 0.95f, 0.15f, 0.95f);
                break;
            }
            case 0: {
                this.func_71905_a(0.05f, 0.0f, 0.05f, 0.95f, 1.0f, 0.95f);
                break;
            }
            default: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.95f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 3) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + (double)0.50001f, (double)z + this.field_72019_cm);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileAirCompressor();
            }
            case 1: {
                return new TileAirCompressor();
            }
            case 2: {
                return new TilePressureVessel();
            }
            case 3: {
                return new TileVat();
            }
        }
        return null;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return RenderIds.BLOCK_DOUBLE;
    }

    public int func_71885_a(int i, Random random, int j) {
        return this.field_71990_ca;
    }

    public int func_71899_b(int i) {
        return i;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 0: {
                return Modules.isActive(Modules.diving);
            }
            case 1: {
                return Modules.isActive(Modules.diving);
            }
            case 2: {
                return Modules.isActive(Modules.factory);
            }
        }
        return true;
    }

    @Override
    public int getMetaCount() {
        return 4;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.bar1 = iconRegister.func_94245_a("mariculture:bar1");
        this.icons = new Icon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, i)));
        }
    }
}

