/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.blocks.BlockDecorative;
import mariculture.core.util.Rand;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockAir
extends BlockDecorative {
    public BlockAir(int i) {
        super(i, Material.field_76249_a);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isAirBlock(World world, int x, int y, int z) {
        return true;
    }

    public void setFire(World world, int x, int y, int z) {
        if (world.func_72799_c(x, y + 1, z)) {
            world.func_94575_c(x, y + 1, z, Block.field_72067_ar.field_71990_ca);
        } else if (world.func_72799_c(x, y - 1, z)) {
            world.func_94575_c(x, y - 1, z, Block.field_72067_ar.field_71990_ca);
        } else if (world.func_72799_c(x - 1, y, z)) {
            world.func_94575_c(x - 1, y, z, Block.field_72067_ar.field_71990_ca);
        } else if (world.func_72799_c(x, y, z - 1)) {
            world.func_94575_c(x, y, z - 1, Block.field_72067_ar.field_71990_ca);
        } else if (world.func_72799_c(x + 1, y, z)) {
            world.func_94575_c(x + 1, y, z, Block.field_72067_ar.field_71990_ca);
        } else if (world.func_72799_c(x, y, z + 1)) {
            world.func_94575_c(x, y, z + 1, Block.field_72067_ar.field_71990_ca);
        }
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        if (Rand.nextInt(4) && world.func_72957_l(x, y, z) > 8) {
            this.setFire(world, x, y, z);
        }
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_71913_a(int meta, boolean par2) {
        return false;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.isNaturalGas(world, x, y, z) ? false : (side == 1 ? true : super.func_71877_c(world, x, y, z, side));
    }

    private boolean isNaturalGas(IBlockAccess world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Core.air.field_71990_ca && world.func_72805_g(x, y, z) == 0;
    }

    public boolean func_71924_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        if (Rand.nextInt(4) && world.func_72957_l(x, y, z) > 8) {
            this.setFire(world, x, y, z);
        }
        return super.isBlockSolidOnSide(world, x, y, z, side);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 5, 2, true));
            living.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 5, 0, true));
        }
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 300;
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 1000;
    }

    @Override
    public int getMetaCount() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("mariculture:air");
    }

    @Override
    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    @Override
    public boolean isActive(int meta) {
        return false;
    }
}

