/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import mariculture.core.RetroData;
import mariculture.core.handlers.LogHandler;
import mariculture.core.handlers.WorldGenHandler;
import mariculture.core.lib.Modules;
import mariculture.core.lib.OreGeneration;
import mariculture.core.lib.RetroGeneration;
import mariculture.core.lib.WorldGeneration;
import mariculture.core.util.Rand;
import mariculture.world.WorldGen;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkEvent;

public class RetroGen {
    public static ArrayList<String> retro;

    public boolean doGen(RetroData data, String ore, Chunk chunk) {
        try {
            Field field = RetroGeneration.class.getField(ore.toUpperCase());
            boolean isEnabled = field.getBoolean(RetroGeneration.class);
            if ((isEnabled || RetroGeneration.ALL) && !data.hasRetroGenned(ore, chunk) && data.setHasRetroGenned(ore, chunk)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ore = ore.substring(0, 1).toUpperCase() + ore.substring(1);
            LogHandler.log(Level.WARNING, "Mariculture's Retro-Gen of " + ore + " Failed");
        }
        return false;
    }

    @ForgeSubscribe
    public void onChunk(ChunkEvent.Load event) {
        if (event.world.field_73011_w.field_76574_g == -1 || event.world.field_73011_w.field_76574_g == 1) {
            return;
        }
        if (!event.world.field_72995_K) {
            Chunk chunk = event.getChunk();
            RetroData data = (RetroData)event.world.field_72988_C.func_75742_a(RetroData.class, "retrogen-mariculture");
            if (data == null || data != null && data.getLastKey() != RetroGeneration.KEY) {
                data = new RetroData();
                event.world.func_72823_a("retrogen-mariculture", (WorldSavedData)data);
            }
            if (retro == null) {
                retro = new ArrayList();
            }
            if (chunk.field_76636_d) {
                try {
                    int x = chunk.field_76635_g * 16;
                    int z = chunk.field_76647_h * 16;
                    if (OreGeneration.NATURAL_GAS_ON && this.doGen(data, "gas", chunk)) {
                        WorldGenHandler.generateGas(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (OreGeneration.BAUXITE_ON && this.doGen(data, "bauxite", chunk)) {
                        WorldGenHandler.generateBauxite(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (OreGeneration.COPPER_ON && this.doGen(data, "copper", chunk)) {
                        WorldGenHandler.generateCopper(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (OreGeneration.LIMESTONE && this.doGen(data, "limestone", chunk)) {
                        WorldGenHandler.generateLimestone(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (OreGeneration.RUTILE && this.doGen(data, "rutile", chunk)) {
                        WorldGenHandler.generateRutile(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (WorldGeneration.OYSTER_ENABLED && this.doGen(data, "oyster", chunk)) {
                        WorldGenHandler.generateOyster(chunk.field_76637_e, Rand.rand, x, z);
                    }
                    if (Modules.isActive(Modules.worldplus)) {
                        if (WorldGeneration.KELP_PATCH_ENABLED && this.doGen(data, "kelppatch", chunk)) {
                            WorldGen.generateKelp(chunk.field_76637_e, Rand.rand, x, z);
                        }
                        if (WorldGeneration.KELP_FOREST_ENABLED && this.doGen(data, "kelpforest", chunk)) {
                            WorldGen.generateKelpForest(chunk.field_76637_e, Rand.rand, x, z);
                        }
                        if (WorldGeneration.CORAL_ENABLED && this.doGen(data, "coralreef", chunk)) {
                            WorldGen.generateCoral(chunk.field_76637_e, Rand.rand, x, z);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

