/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import java.util.ArrayList;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.Core;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.Items;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.FluidDictionary;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesSmelting {
    public static int iron = 1538;
    public static int gold = 1064;
    public static int tin = 232;
    public static int copper = 1085;
    public static int silver = 962;
    public static int lead = 328;
    public static int magnesium = 650;
    public static int nickel = 1455;
    public static int bronze = 950;
    public static int steel = 1370;
    public static int aluminum = 660;
    public static int titanium = 1662;
    public static int electrum = 1000;

    public static void addRecipe(String fluid, int[] volume, Object[] items, int temperature, ItemStack output, int chance) {
        String origFluid = fluid;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || volume[i] <= 0) continue;
            Object item = items[i];
            ItemStack stack = null;
            if (item instanceof String) {
                if (OreDictionary.getOres((String)((String)item)).size() > 0) {
                    stack = (ItemStack)OreDictionary.getOres((String)((String)item)).get(0);
                }
            } else if (item instanceof ItemStack) {
                stack = (ItemStack)item;
            } else if (item instanceof Item) {
                stack = new ItemStack((Item)item);
            } else if (item instanceof Block) {
                stack = new ItemStack((Block)item);
            }
            if (stack == null || FluidRegistry.getFluid((String)fluid) == null) continue;
            if (i == 0 || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemHoe) {
                RecipeHelper.addMelting(stack, temperature, FluidRegistry.getFluidStack((String)fluid, (int)volume[i]), output, chance);
                continue;
            }
            RecipeHelper.addMelting(stack, temperature, FluidRegistry.getFluidStack((String)fluid, (int)volume[i]));
        }
    }

    public static void add() {
        RecipesSmelting.addFuels();
        RecipesSmelting.addMetalRecipes();
    }

    public static void postAdd() {
        ItemStack sulfur = RecipesSmelting.fetchItem(new String[]{"dustSulfur", "crystalSulfur"});
        ItemStack salt = new ItemStack(Core.materials, 1, 12);
        ItemStack silicon = RecipesSmelting.fetchItem(new String[]{"itemSilicon", "dustSiliconDioxide"});
        ItemStack platinum = RecipesSmelting.fetchItem(new String[]{"dustPlatinum", "ingotPlatinum"});
        LinkedMetal[] coppers = new LinkedMetal[]{new LinkedMetal("ingotIron", FluidDictionary.iron, 4), new LinkedMetal("ingotSilver", FluidDictionary.silver, 7), new LinkedMetal("ingotGold", FluidDictionary.gold, 10), new LinkedMetal("ingotCobalt", FluidDictionary.cobalt, 15), new LinkedMetal("ingotNickel", FluidDictionary.nickel, 8), new LinkedMetal("ingotLead", FluidDictionary.lead, 7), new LinkedMetal("ingotTin", FluidDictionary.tin, 6)};
        RecipesSmelting.addDust(9, copper, sulfur, 10, coppers);
        LinkedMetal[] golds = new LinkedMetal[]{new LinkedMetal("ingotElectrum", FluidDictionary.electrum, 3), new LinkedMetal("ingotSilver", FluidDictionary.silver, 7)};
        RecipesSmelting.addDust(10, gold, null, 0, golds);
        LinkedMetal[] irons = new LinkedMetal[]{new LinkedMetal("ingotAluminum", FluidDictionary.aluminum, 3), new LinkedMetal("ingotTin", FluidDictionary.iron, 8), new LinkedMetal("ingotCopper", FluidDictionary.copper, 6)};
        RecipesSmelting.addDust(11, iron, silicon, 6, irons);
        LinkedMetal[] leads = new LinkedMetal[]{new LinkedMetal("ingotSilver", FluidDictionary.silver, 3), new LinkedMetal("ingotIron", FluidDictionary.iron, 6), new LinkedMetal("ingotCopper", FluidDictionary.copper, 8), new LinkedMetal("ingotTin", FluidDictionary.tin, 10)};
        RecipesSmelting.addDust(7, lead, null, 0, leads);
        LinkedMetal[] silvers = new LinkedMetal[]{new LinkedMetal("ingotLead", FluidDictionary.lead, 2), new LinkedMetal("ingotElectrum", FluidDictionary.electrum, 4)};
        RecipesSmelting.addDust(6, silver, sulfur, 5, silvers);
        LinkedMetal[] tins = new LinkedMetal[]{new LinkedMetal("ingotCopper", FluidDictionary.copper, 3), new LinkedMetal("ingotIron", FluidDictionary.iron, 6), new LinkedMetal("ingotLead", FluidDictionary.lead, 8)};
        RecipesSmelting.addDust(8, tin, sulfur, 7, tins);
        RecipesSmelting.addMetal(FluidDictionary.tin, "Tin", tin, new ItemStack(Core.materials, 1, 8), 10);
        RecipesSmelting.addMetal(FluidDictionary.copper, "Copper", copper, new ItemStack(Core.materials, 1, 9), 10);
        RecipesSmelting.addMetal(FluidDictionary.silver, "Silver", silver, new ItemStack(Core.materials, 1, 6), 10);
        RecipesSmelting.addMetal(FluidDictionary.lead, "Lead", lead, new ItemStack(Core.materials, 1, 7), 10);
        RecipesSmelting.addMetal(FluidDictionary.magnesium, "Magnesium", magnesium, null, 0);
        RecipesSmelting.addMetal(FluidDictionary.nickel, "Nickel", nickel, platinum, 10);
        RecipesSmelting.addMetal(FluidDictionary.bronze, "Bronze", bronze, null, 0);
        RecipesSmelting.addMetal(FluidDictionary.steel, "Steel", steel, null, 0);
        RecipesSmelting.addMetal(FluidDictionary.electrum, "Electrum", electrum, null, 0);
        if (OreDictionary.getOres((String)"ingotElectrum").size() > 0 && OreDictionary.getOres((String)"ingotSilver").size() > 0) {
            FluidStack moltenSilver = FluidRegistry.getFluidStack((String)FluidDictionary.silver, (int)MetalRates.NUGGET);
            FluidStack moltenGold = FluidRegistry.getFluidStack((String)FluidDictionary.gold, (int)MetalRates.NUGGET);
            FluidStack moltenElectrum = FluidRegistry.getFluidStack((String)FluidDictionary.electrum, (int)(MetalRates.NUGGET * 2));
            RecipeHelper.addFluidAlloy(moltenSilver, moltenGold, moltenElectrum, 1);
            RecipeHelper.addMeltingAlloy((ItemStack)OreDictionary.getOres((String)"ingotSilver").get(0), new ItemStack(Item.field_77717_p), electrum, RecipesSmelting.get(FluidDictionary.electrum, MetalRates.INGOT * 2));
        }
    }

    private static void addDust(int meta, int temp, ItemStack bonus, int chance, LinkedMetal[] metals) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ArrayList<Integer> chances = new ArrayList<Integer>();
        for (LinkedMetal metal : metals) {
            if (OreDictionary.getOres((String)metal.ingot).size() <= 0 || RecipesSmelting.get(metal.fluid) == null) continue;
            fluids.add(RecipesSmelting.get(metal.fluid));
            chances.add(metal.chance);
        }
        if (fluids.size() > 0) {
            MaricultureHandlers.smelter.addRecipe(new RecipeSmelter(new ItemStack(Core.materials, 1, meta), temp, fluids.toArray(new FluidStack[fluids.size()]), chances.toArray(new Integer[chances.size()]), bonus, chance));
        }
    }

    private static ItemStack fetchItem(String[] array) {
        for (String arr : array) {
            if (OreDictionary.getOres((String)arr).size() <= 0) continue;
            return (ItemStack)OreDictionary.getOres((String)arr).get(0);
        }
        return null;
    }

    private static void addFuels() {
        RecipeHelper.addFuel("blockCoal", new FuelInfo(2000, 378, 10800));
        RecipeHelper.addFuel(new ItemStack(Item.field_77705_m, 1, 0), new FuelInfo(2000, 42, 1200));
        RecipeHelper.addFuel(new ItemStack(Item.field_77705_m, 1, 1), new FuelInfo(1600, 32, 900));
        RecipeHelper.addFuel("logWood", new FuelInfo(480, 12, 300));
        RecipeHelper.addFuel("plankWood", new FuelInfo(320, 8, 200));
        RecipeHelper.addFuel("stickWood", new FuelInfo(160, 4, 100));
        RecipeHelper.addFuel(FluidDictionary.natural_gas, new FuelInfo(2000, 35, 1200));
        RecipeHelper.addFuel("gascraft_naturalgas", new FuelInfo(2000, 35, 1000));
        RecipeHelper.addFuel("fuel", new FuelInfo(2000, 35, 1000));
        RecipeHelper.addFuel("pyrotheum", new FuelInfo(2000, 100, 100));
        RecipeHelper.addFuel("coal", new FuelInfo(2000, 40, 300));
        RecipeHelper.addFuel("biofuel", new FuelInfo(1800, 20, 2000));
        RecipeHelper.addFuel("oil", new FuelInfo(1750, 20, 400));
        RecipeHelper.addFuel("lava", new FuelInfo(1500, 20, 360));
        RecipeHelper.addFuel("biomass", new FuelInfo(1500, 10, 1800));
    }

    public static void addFullSet(String fluid, Object[] items, int temp, ItemStack output, int chance) {
        RecipesSmelting.addRecipe(fluid, MetalRates.MATERIALS, new Object[]{items[0], items[1], items[2], items[3], items[4]}, temp, output, chance);
        RecipesSmelting.addRecipe(fluid, MetalRates.TOOLS, new Object[]{items[5], items[6], items[7], items[8], items[9]}, temp, new ItemStack(Item.field_77669_D), 1);
        RecipesSmelting.addRecipe(fluid, MetalRates.ARMOR, new Object[]{items[10], items[11], items[12], items[13]}, temp, null, 0);
    }

    public static void addMetal(String fluid, String metal, int temp, ItemStack bonus, int chance) {
        RecipesSmelting.addRecipe(fluid, MetalRates.MATERIALS, new Object[]{"ore" + metal, "nugget" + metal, "ingot" + metal, "block" + metal, "dust" + metal}, temp, bonus, chance);
        RecipeHelper.addMetalCasting(fluid, metal);
    }

    public static void addMetalRecipes() {
        RecipesSmelting.addFullSet(FluidDictionary.iron, new Object[]{"oreIron", "nuggetIron", "ingotIron", "blockIron", "dustIron", Item.field_77696_g, Item.field_77695_f, Item.field_77708_h, Item.field_77716_q, Item.field_77689_P, Item.field_77812_ad, Item.field_77822_ae, Item.field_77824_af, Item.field_77818_ag}, iron, new ItemStack(Core.materials, 1, 11), 10);
        RecipeHelper.addMetalCasting(FluidDictionary.iron, "Iron");
        RecipesSmelting.addFullSet(FluidDictionary.gold, new Object[]{"oreGold", "nugetGold", "ingotGold", "blockGold", "dustGold", Item.field_77681_I, Item.field_77680_H, Item.field_77682_J, Item.field_77672_G, Item.field_77691_R, Item.field_77796_al, Item.field_77806_am, Item.field_77808_an, Item.field_77802_ao}, gold, new ItemStack(Core.materials, 1, 10), 10);
        RecipeHelper.addMetalCasting(FluidDictionary.gold, "Gold");
        RecipesSmelting.addRecipe(FluidDictionary.aluminum, MetalRates.MATERIALS, new Object[]{"oreAluminum", "nuggetAluminum", "ingotAluminum", "blockAluminum", "dustAluminum"}, aluminum, new ItemStack(Item.field_77757_aI), 5);
        RecipeHelper.addMetalCasting(FluidDictionary.aluminum, "Aluminum");
        RecipesSmelting.addRecipe(FluidDictionary.rutile, MetalRates.MATERIALS, new Object[]{"oreRutile", "nuggetRutile", "ingotRutile", "blockRutile", "dustRutile"}, titanium, new ItemStack(Core.ores, 1, 3), 2);
        RecipeHelper.addMetalCasting(FluidDictionary.rutile, "Rutile");
        RecipesSmelting.addRecipe(FluidDictionary.titanium, MetalRates.MATERIALS, new Object[]{"oreTitanium", "nuggetTitanium", "ingotTitanium", "blockTitanium", "dustTitanium"}, titanium, new ItemStack(Core.ores, 1, 3), 2);
        RecipeHelper.addMetalCasting(FluidDictionary.titanium, "Titanium");
        FluidStack moltenRutile = FluidRegistry.getFluidStack((String)FluidDictionary.rutile, (int)MetalRates.INGOT);
        FluidStack moltenMagnesium = FluidRegistry.getFluidStack((String)FluidDictionary.magnesium, (int)MetalRates.INGOT);
        FluidStack moltenTitanium = FluidRegistry.getFluidStack((String)FluidDictionary.titanium, (int)MetalRates.INGOT);
        RecipeHelper.addFluidAlloy(moltenRutile, moltenMagnesium, moltenTitanium, 6);
        RecipeHelper.addMeltingAlloy(new ItemStack(Core.materials, 1, 3), new ItemStack(Core.materials, 1, 1), titanium, RecipesSmelting.get(FluidDictionary.titanium));
        RecipeHelper.addMelting(Items.dustMagnesium, magnesium, RecipesSmelting.get(FluidDictionary.magnesium), Items.salt, 1);
        RecipeHelper.addMelting(new ItemStack(Block.field_94348_cl), gold, RecipesSmelting.gold(MetalRates.INGOT * 2));
        RecipeHelper.addMelting(new ItemStack(Item.field_77752_aS), gold, RecipesSmelting.gold(MetalRates.INGOT * 4), new ItemStack(Item.field_77767_aC), 2);
        RecipeHelper.addMelting(new ItemStack(Item.field_111216_cf), gold, RecipesSmelting.gold(MetalRates.INGOT * 6), new ItemStack(Item.field_77765_aA), 4);
        RecipeHelper.addMelting(new ItemStack(Item.field_77788_aw), iron, FluidDictionary.iron, MetalRates.INGOT * 3);
        RecipeHelper.addMelting(new ItemStack(Item.field_77766_aB), iron, FluidDictionary.iron, MetalRates.INGOT * 6);
        RecipeHelper.addMelting(new ItemStack(Block.field_72002_bp), iron, FluidDictionary.iron, (int)((double)MetalRates.INGOT * 0.25));
        RecipeHelper.addMelting(new ItemStack((Item)Item.field_77745_be), iron, FluidDictionary.iron, MetalRates.INGOT * 2);
        RecipeHelper.addMelting(new ItemStack(Block.field_82510_ck, 1, 0), iron, FluidDictionary.iron, MetalRates.INGOT * 31);
        RecipeHelper.addMelting(new ItemStack(Block.field_82510_ck, 1, 1), iron, FluidDictionary.iron, MetalRates.INGOT * 22);
        RecipeHelper.addMelting(new ItemStack(Block.field_82510_ck, 1, 2), iron, FluidDictionary.iron, MetalRates.INGOT * 13);
        RecipeHelper.addMelting(new ItemStack(Block.field_94345_cm), iron, FluidDictionary.iron, MetalRates.INGOT * 2);
        RecipeHelper.addMelting(new ItemStack(Item.field_77750_aQ), iron, RecipesSmelting.iron(MetalRates.INGOT * 4), new ItemStack(Item.field_77767_aC), 2);
        RecipeHelper.addMelting(new ItemStack((Block)Block.field_94340_cs), iron, RecipesSmelting.iron(MetalRates.INGOT * 5), new ItemStack((Block)Block.field_72077_au), 2);
        RecipeHelper.addMelting(new ItemStack(Item.field_77709_i), iron, RecipesSmelting.iron(MetalRates.INGOT));
        RecipeHelper.addMelting(new ItemStack(Item.field_111215_ce), iron, RecipesSmelting.iron(MetalRates.INGOT * 6), new ItemStack(Item.field_77765_aA), 4);
        RecipeHelper.addBlockCasting(RecipesSmelting.get(FluidDictionary.glass, 1000), new ItemStack(Block.field_71946_M));
        RecipeHelper.addMelting(new ItemStack(Block.field_71939_E), 1000, FluidDictionary.glass, 1000);
        RecipeHelper.addMelting(new ItemStack(Block.field_71946_M), 900, FluidDictionary.glass, 1000);
        RecipeHelper.addMelting(new ItemStack(Block.field_72003_bq), 500, FluidDictionary.glass, 375);
        RecipeHelper.addMelting(new ItemStack(Block.field_72036_aT), 1, "water", 1000);
        RecipeHelper.addMelting(new ItemStack(Block.field_72039_aU), 1, "water", 1000);
        RecipeHelper.addVatItemRecipe(new ItemStack(Block.field_71946_M), FluidDictionary.natural_gas, 1000, new ItemStack(Core.transparent, 1, 0), 5);
        if (FluidRegistry.getFluid((String)"bioethanol") != null) {
            RecipeHelper.addVatItemRecipe(new ItemStack(Block.field_71946_M), "bioethanol", 2500, new ItemStack(Core.transparent, 1, 0), 10);
        }
        RecipeHelper.addFluidAlloyResultItem(RecipesSmelting.get("water", 1000), RecipesSmelting.get("lava", 1000), new ItemStack(Block.field_72089_ap), 10);
        RecipeHelper.addFluidAlloyResultItemNFluid(RecipesSmelting.get("water", 3000), RecipesSmelting.get(FluidDictionary.quicklime, 4000), RecipesSmelting.get("water", 2000), Items.dustMagnesium, 10);
        RecipeHelper.addMelting(new ItemStack(Core.ores, 1, 3), 825, RecipesSmelting.get(FluidDictionary.quicklime, 900));
        RecipeHelper.addMelting(new ItemStack(Core.ores, 1, 5), 825, RecipesSmelting.get(FluidDictionary.quicklime, 1000));
        RecipeHelper.addMelting(new ItemStack(Core.materials, 1, 12), 801, RecipesSmelting.get(FluidDictionary.salt, 20));
        RecipeHelper.addMelting(new ItemStack(Core.materials, 1, 3), titanium, RecipesSmelting.get(FluidDictionary.rutile));
        RecipesSmelting.addRecipe(FluidDictionary.steel, MetalRates.CHAIN, new Object[]{new ItemStack((Item)Item.field_77694_Z), new ItemStack((Item)Item.field_77814_aa), new ItemStack((Item)Item.field_77816_ab), new ItemStack((Item)Item.field_77810_ac)}, steel, null, 0);
        RecipeHelper.addFluidAlloyNItemResultItem(RecipesSmelting.get(FluidDictionary.aluminum, MetalRates.NUGGET), RecipesSmelting.get(FluidDictionary.quicklime, 900), new ItemStack(Block.field_71946_M), new ItemStack(Core.glass, 1, 0), 15);
    }

    public static FluidStack gold(int vol) {
        return FluidRegistry.getFluidStack((String)FluidDictionary.gold, (int)vol);
    }

    public static FluidStack iron(int vol) {
        return FluidRegistry.getFluidStack((String)FluidDictionary.iron, (int)vol);
    }

    public static FluidStack get(String name, int vol) {
        return FluidRegistry.getFluidStack((String)name, (int)vol);
    }

    public static FluidStack get(String name) {
        return FluidRegistry.getFluidStack((String)name, (int)MetalRates.INGOT);
    }

    private static class LinkedMetal {
        public String ingot;
        public String fluid;
        public Integer chance;

        public LinkedMetal(String ingot, String fluid, Integer chance) {
            this.ingot = ingot;
            this.fluid = fluid;
            this.chance = chance;
        }
    }
}

