/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.logging.Level;
import mariculture.Mariculture;
import mariculture.aesthetics.Aesthetics;
import mariculture.api.core.MaricultureTab;
import mariculture.compatibility.Compat;
import mariculture.core.Core;
import mariculture.core.lib.BlockIds;
import mariculture.core.lib.Compatibility;
import mariculture.core.lib.EnchantIds;
import mariculture.core.lib.Extra;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.Modules;
import mariculture.core.lib.OreGeneration;
import mariculture.core.lib.RetroGeneration;
import mariculture.core.lib.WorldGeneration;
import mariculture.diving.Diving;
import mariculture.factory.Factory;
import mariculture.fishery.Fishery;
import mariculture.magic.Magic;
import mariculture.plugins.Plugins;
import mariculture.sealife.Sealife;
import mariculture.transport.Transport;
import mariculture.world.WorldPlus;
import net.minecraftforge.common.Configuration;

public class Config {
    public static void init(String dir) {
        Config.initOther(new Configuration(new File(dir, "other.cfg")));
        Config.initIDs(new Configuration(new File(dir, "ids.cfg")));
        Config.initMachines(new Configuration(new File(dir, "mechanics.cfg")));
        Config.initModules(new Configuration(new File(dir, "modules.cfg")));
        Config.initWorld(new Configuration(new File(dir, "worldgen.cfg")));
        Config.setupTabs();
    }

    private static void setupTabs() {
        MaricultureTab.tabFish = Modules.isActive(Modules.fishery) ? new MaricultureTab("fishTab") : null;
        MaricultureTab.tabMariculture = new MaricultureTab("maricultureTab");
        MaricultureTab.tabJewelry = Modules.isActive(Modules.magic) ? new MaricultureTab("jewelryTab") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initOther(Configuration config) {
        try {
            config.load();
            Extra.ENABLE_EDIBLE_BAIT = config.get("Other", "Enable Edible Bait", true).getBoolean(true);
            Extra.ENABLE_EASY_JEWELRY = config.get("Other", "Enable Iron and Diamond Jewelry", false).getBoolean(false);
            Extra.DISABLE_FISH = config.get("Other", "Disable Mariculture Live Fish in NEI", false).getBoolean(false);
            Extra.SPAWN_BOOKS = config.get("Other", "Spawn Books on First Action", true).getBoolean(true);
            if (!Loader.isModLoaded((String)"Enchiridion")) {
                Extra.SPAWN_BOOKS = false;
            }
            Extra.JEWELRY_TICK_RATE = config.get("Other", "Jewelry Tick Rate", 60, "This is how many ticks before the server will send an update to a player about what level enchant they have in their mirror inventory").getInt();
            Extra.HARDCORE_DIVING = config.get("Difficulty", "Hardcore Diving Setting", 0, "This causes your air to drop quicker, the higher the faster it will drop, set to 0 to turn off").getInt();
            Extra.REFRESH_CLIENT_RATE = config.get("Other", "Server-Client Refresh Rate", 30, "This is how many ticks before updates are sent to the client").getInt();
            Extra.DEBUG_ON = config.get("Other", "Debug Mode Enabled", false).getBoolean(false);
            Extra.METAL_RATE = config.get("Other", "Molten Metal Nugget mB Value", 16, "This is how many mB a Nugget is worth, the default value is the same as Tinker's Construct").getInt();
            Extra.FLUDD_WATER_ON = config.get("Client", "Enable FLUDD Animations", true, "Whether a server will tell the client to display the fludd animations").getBoolean(true);
            Extra.ENABLE_ENDER_SPAWN = config.get("Other", "Enable Ender Dragon Spawning", true, "This is whether players can Spawn the Ender Dragon with the Dragon Spawn Egg").getBoolean(true);
            Extra.DROP_JEWELRY = config.get("Other", "Jewelry Drops on Death", false).getBoolean(false);
            Extra.MOB_MAGNET = config.get("Other", "Mob Magnet Crafting Enabled", true).getBoolean(true);
            Extra.PERCENT_NEEDED = config.get("Other", "Percentage Needed for Timelord Enchant", 5).getInt();
            Extra.JEWELRY_OFFLINE = config.get("Other", "Enable Singleplayer Jewelry Offline Mode", false).getBoolean(false);
            Extra.BREEDING_MULTIPLIER = config.get("Other", "Breeding Multiplier", 1.0, "Breeding multiplier, set this to a higher double, to make breeding easier, setting to 2, will double the mutation chances for example").getDouble(1.0);
            Extra.IGNORE_BIOMES = config.get("Other", "Enable Catching of all fish in all biomes", false).getBoolean(false);
            Extra.WEAK_FISH_LIMIT = config.get("Other", "Bound Fishing Rod - Fish Limit Per Use (Weak)", 8).getInt();
            Extra.DEMON_FISH_LIMIT = config.get("Other", "Bound Fishing Rod - Fish Limit Per Use (Demon)", 64).getInt();
            Extra.DISABLE_DIRT_CRAFTING = config.get("Other", "Disable Crafting of Dirt from Molten Dirt", false).getBoolean(false);
            Extra.DISABLE_GRASS = config.get("Other", "Disable Crafting of Grass from Fish Droplets", false).getBoolean(false);
            Extra.ALIVE_MODIFIER = config.get("Other", "Fish Caught Alive Modifier", 1.15).getDouble(1.15);
            Compatibility.ENABLE_WHITELIST = config.get("Autodictionary", "AutoDictionary > Use Whitelist", false).getBoolean(false);
            Compatibility.BLACKLIST = config.get("Autodictionary", "AutoDictionary > Blacklist", Compatibility.BLACKLIST_DEFAULT, "Place Ore Dictionary names, to blacklist here (this only works if use white list is set to false)").getStringList();
            Compatibility.WHITELIST = config.get("Autodictionary", "AutoDictionary > Whitelist", Compatibility.WHITELIST_DEFAULT, "Place Ore Dictionary Prefixes here, that are acceptable to be converted").getStringList();
            Compatibility.BLACKLIST_PREFIX = config.get("Autodictionary", "AutoDictionary > Blacklist Prefixes", Compatibility.BLACKLIST_PREFIX_DEFAULT, "Add a list of prefixes you want to blacklist from the auto-dictionary").getStringList();
            Compatibility.BLACKLIST_ITEMS = config.get("Autodictionary", "AutoDictionary > Blacklist Items", Compatibility.BLACKLIST_ITEMS_DEFAULT, "This is a list of items to blacklist from being able to converted, format is either (itemid meta) or (unlocalizedname meta) (without the brackets)").getStringList();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Mariculture had a problem loading the other settings", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initWorld(Configuration config) {
        try {
            config.load();
            config.addCustomCategoryComment("Ore Generation", "This section let's you adjust where your ores will spawn and how much. Please note when it comes to 'chance', that LOWER = more common, as it's a x in this many chance.");
            config.addCustomCategoryComment("Retro-Gen", "Retro-Generation allows you to generate ores/other features in your existing worlds, without you having to go off and explore new areas. If you set all to true, it will override the individual settings for retro-gen");
            Extra.RIVER_FORCE = config.get("Biome Types", "River Biomes - Only Config", false).getBoolean(false);
            Extra.RIVER_BIOMES = config.get("Biome Types", "River Biomes", Extra.RIVERS_DEFAULT, "This is a list of biome ids, that Mariculture considers to be 'river' biomes (affects where limestone/rutile can spawn)").getIntList();
            Extra.OCEAN_FORCE = config.get("Biome Types", "Ocean Biomes - Only Config", false).getBoolean(false);
            Extra.OCEAN_BIOMES = config.get("Biome Types", "Ocean Biomes", Extra.OCEANS_DEFAULT, "This is a list of biome ids, that Mariculture considers to be 'ocean' biomes; (affects where natural gas/coral/kelp can spawn) Take note that Mariculture automatically asumes that BiomesOPlenty ocean types are indeed oceans").getIntList();
            OreGeneration.BAUXITE_ON = config.get("Ore Generation", "Bauxite > Generation", true).getBoolean(true);
            OreGeneration.BAUXITE_TOTAL = config.get("Ore Generation", "Bauxite > Number of Veins", 16).getInt();
            OreGeneration.BAUXITE_VEIN = config.get("Ore Generation", "Bauxite > Maximum Vein Size", 8).getInt();
            OreGeneration.BAUXITE_MIN = config.get("Ore Generation", "Bauxite > Minimum Y Height", 60).getInt();
            OreGeneration.BAUXITE_MAX = config.get("Ore Generation", "Bauxite > Maximum Y Height", 256).getInt();
            OreGeneration.COPPER_ON = config.get("Ore Generation", "Copper > Generation", true).getBoolean(true);
            OreGeneration.COPPER_TOTAL = config.get("Ore Generation", "Copper > Number of Veins", 8).getInt();
            OreGeneration.COPPER_VEIN = config.get("Ore Generation", "Copper > Maximum Vein Size", 3).getInt();
            OreGeneration.COPPER_MIN = config.get("Ore Generation", "Copper > Minimum Y Height", 1).getInt();
            OreGeneration.COPPER_MAX = config.get("Ore Generation", "Copper > Maximum Y Height", 64).getInt();
            OreGeneration.RUTILE = config.get("Ore Generation", "Rutile > Generation", true).getBoolean(true);
            OreGeneration.RUTILE_CHANCE = config.get("Ore Generation", "Rutile > 1 Vein Per This Many Limestone", 250).getInt();
            OreGeneration.LIMESTONE = config.get("Ore Generation", "Limestone > Generation", true).getBoolean(true);
            OreGeneration.LIMESTONE_CHANCE = config.get("Ore Generation", "Limestone > Number of Chances Per Chunk to Generate", 1).getInt();
            OreGeneration.LIMESTONE_VEIN = config.get("Ore Generation", "Limestone > Maximum Vein Size", 32).getInt();
            OreGeneration.LIMESTONE_MAX_DEPTH = config.get("Ore Generation", "Limestone > Maximum Depth (Y Height)", 40).getInt();
            OreGeneration.NATURAL_GAS_ON = config.get("Ore Generation", "Natural Gas > Generation", true).getBoolean(true);
            OreGeneration.NATURAL_GAS_CHANCE = config.get("Ore Generation", "Natural Gas > 1 Pocket Per This Many Chunks", 20).getInt();
            OreGeneration.NATURAL_GAS_VEIN = config.get("Ore Generation", "Natural Gas > Maximum Vein Size", 48).getInt();
            OreGeneration.NATURAL_GAS_MIN = config.get("Ore Generation", "Natural Gas > Minimum Y Height", 16).getInt();
            OreGeneration.NATURAL_GAS_MAX = config.get("Ore Generation", "Natural Gas > Maximum Y Height", 26).getInt();
            WorldGeneration.CORAL_EXPERIMENTAL = config.get("World Plus Generation", "Coral > 1.7.2 Gen > Enable Experimental", true, "Coral will use the generator from 1.7.2").getBoolean(true);
            WorldGeneration.CORAL_EXPERIMENTAL_EXTRA = config.get("World Plus Generation", "Coral > 1.7.2 Gen > Enable Harsher Generation", true, "If Coral generation is too heavy, disable this and it will generate less").getBoolean(true);
            WorldGeneration.CORAL_BIOMESOP = config.get("World Plus Generation", "Coral > Force in BOP Coral Biome", false, "If enabled this will force Coral to only generate in Coral Reef Biomes if they exist in a world, If disabled, will generate in all ocean biomes").getBoolean(false);
            WorldGeneration.CORAL_BIOMESOP_TYPES = config.get("World Plus Generation", "Coral > Force in Coral Biome Level Types", new String[]{"BIOMESOP"}).getStringList();
            WorldGeneration.CORAL_ENABLED = config.get("World Plus Generation", "Coral > Generation", true).getBoolean(true);
            WorldGeneration.CORAL_CHANCE = config.get("World Plus Generation", "Coral > 1 Reef Per this Many Chunks", 4).getInt();
            WorldGeneration.CORAL_DEPTH = config.get("World Plus Generation", "Coral > Maximum Depth", 25).getInt();
            WorldGeneration.KELP_CHANCE = config.get("World Plus Generation", "Kelp > 1 Forest Per This Many Chunks", 200).getInt();
            WorldGeneration.KELP_DEPTH = config.get("World Plus Generation", "Kelp > Maximum Depth", 35).getInt();
            WorldGeneration.KELP_HEIGHT = config.get("World Plus Generation", "Kelp > Maximum World Gen Height", 25).getInt();
            WorldGeneration.KELP_PATCH_ENABLED = config.get("World Plus Generation", "Kelp > Single Generation", true).getBoolean(true);
            WorldGeneration.KELP_PATCH_DENSITY = config.get("World Plus Generation", "Kelp > Single Density", 10).getInt();
            WorldGeneration.KELP_FOREST_ENABLED = config.get("World Plus Generation", "Kelp > Forest Generation", true).getBoolean(true);
            WorldGeneration.KELP_FOREST_DENSITY = config.get("World Plus Generation", "Kelp > Forest Density", 25).getInt();
            WorldGeneration.KELP_CHEST_CHANCE = config.get("World Plus Generation", "Kelp > 1 Treasure Chest Per This Many Kelp", 1024).getInt();
            WorldGeneration.KELP_BIOMESOP = config.get("World Plus Generation", "Kelp > (Forest) Force in BOP Kelp Biome", false, "If enabled this will force Coral to only generate in Coral Reef Biomes if they exist in a world, If disabled, will generate in all ocean biomes").getBoolean(false);
            WorldGeneration.KELP_BIOMESOP_TYPES = config.get("World Plus Generation", "Kelp > (Forest) Force in Kelp Biome Level Types", new String[]{"BIOMESOP"}).getStringList();
            WorldGeneration.DEEP_OCEAN = config.get("World Plus Generation", "Deep Oceans", false).getBoolean(false);
            WorldGeneration.WATER_CAVES = config.get("World Plus Generation", "Water Filled Caves in Oceans", false).getBoolean(false);
            WorldGeneration.WATER_RAVINES = config.get("World Plus Generation", "Water Filled Ravines in Oceans", true).getBoolean(true);
            WorldGeneration.RAVINE_CHANCE = config.get("World Plus Generation", "Water Ravine Chance (Lower = More Common)", 25).getInt();
            WorldGeneration.RAVINE_CHANCE = WorldGeneration.RAVINE_CHANCE < 1 ? 25 : WorldGeneration.RAVINE_CHANCE;
            WorldGeneration.NO_MINESHAFTS = config.get("World Plus Generation", "Remove Mineshafts in Oceans", true).getBoolean(true);
            WorldGeneration.OYSTER_ENABLED = config.get("World Plus Generation", "Pearl Oyster > Generation", true).getBoolean(true);
            WorldGeneration.OYSTER_PER_CHUNK = config.get("World Plus Generation", "Pearl Oyster > Number Chances to Gen Per Chunk", 3).getInt(3);
            WorldGeneration.OYSTER_CHANCE = config.get("World Plus Generation", "Pearl Oyster > 1 Oyster per This Many Blocks Per Chunk", 12).getInt();
            WorldGeneration.OYSTER_PEARL_CHANCE = config.get("World Plus Generation", "Pearl Oyster > 1 Natural Pearl Per this Many Oysters", 3).getInt();
            RetroGeneration.ENABLED = config.get("Retro-Gen", "Enable Retro-Gen", false).getBoolean(false);
            RetroGeneration.KEY = config.get("Retro-Gen", "Key", 555, "This key is what stops, retro gen from generating in chunks over and over, if you want to retro gen again, change the key to any other integer").getInt();
            RetroGeneration.ALL = config.get("Retro-Gen", "All", true).getBoolean(true);
            RetroGeneration.BAUXITE = config.get("Retro-Gen", "Bauxite", false).getBoolean(false);
            RetroGeneration.COPPER = config.get("Retro-Gen", "Copper", false).getBoolean(false);
            RetroGeneration.CORALREEF = config.get("Retro-Gen", "Coral Reef", false).getBoolean(false);
            RetroGeneration.GAS = config.get("Retro-Gen", "Natural Gas", false).getBoolean(false);
            RetroGeneration.KELPFOREST = config.get("Retro-Gen", "Kelp Forest", false).getBoolean(false);
            RetroGeneration.KELPPATCH = config.get("Retro-Gen", "Kelp Patch", false).getBoolean(false);
            RetroGeneration.LIMESTONE = config.get("Retro-Gen", "Limestone", false).getBoolean(false);
            RetroGeneration.OYSTER = config.get("Retro-Gen", "Oysters", false).getBoolean(false);
            RetroGeneration.RUTILE = config.get("Retro-Gen", "Rutile", false).getBoolean(false);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Oh dear, there was a problem with Mariculture loading it's world configuration", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initModules(Configuration config) {
        try {
            config.load();
            Mariculture.modules.setup(Core.class, true);
            Mariculture.modules.setup(Aesthetics.class, config.get("Modules", "Aesthetics", true).getBoolean(true));
            Mariculture.modules.setup(Diving.class, config.get("Modules", "Diving", true).getBoolean(true));
            Mariculture.modules.setup(Factory.class, config.get("Modules", "Factory", true).getBoolean(true));
            Mariculture.modules.setup(Fishery.class, config.get("Modules", "Fishery", true).getBoolean(true));
            Mariculture.modules.setup(Magic.class, config.get("Modules", "Magic", true).getBoolean(true));
            Mariculture.modules.setup(Sealife.class, false);
            Mariculture.modules.setup(Transport.class, config.get("Modules", "Transport", true).getBoolean(true));
            Mariculture.modules.setup(WorldPlus.class, config.get("Modules", "World Plus", true).getBoolean(true));
            Mariculture.modules.setup(Compat.class, true);
            Mariculture.modules.setup(Plugins.class, true);
            Extra.NERF_FOOD = Loader.isModLoaded((String)"HungerOverhaul");
            Extra.HAS_BOP = Loader.isModLoaded((String)"BiomesOPlenty");
            for (int i = 0; i < Plugins.plugins.size(); ++i) {
                Plugins.Plugin plugin = Plugins.plugins.get(i);
                if (config.get("Plugins", plugin.name, true).getBoolean(true)) continue;
                Plugins.plugins.remove(i);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Problem with Mariculture when copying over the module data", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMachines(Configuration config) {
        try {
            config.load();
            MachineSpeeds.autofisher = config.get("Machine Speeds", "Automatic Fisher", 2500).getInt();
            MachineSpeeds.dictionary = config.get("Machine Speeds", "Autodictionary", 1).getInt();
            MachineSpeeds.feeder = config.get("Machine Speeds", "Fish Feeder", 200).getInt();
            MachineSpeeds.incubator = config.get("Machine Speeds", "Incubator", 400).getInt();
            MachineSpeeds.liquifier = config.get("Machine Speeds", "Industrial Smelter", 40000).getInt();
            MachineSpeeds.net = config.get("Machine Speeds", "Fishing Net", 256).getInt();
            MachineSpeeds.sawmill = config.get("Machine Speeds", "Sawmill", 650).getInt();
            MachineSpeeds.settler = config.get("Machine Speeds", "Industrial Freezer", 60000).getInt();
            MachineSpeeds.oven = config.get("Machine Speeds", "Gas Oven", 450).getInt();
            Extra.GEYSER_ANIM = config.get("Client", "Geyser - Enable Particles", true).getBoolean(true);
            Extra.FLUDD_BLOCK_ANIM = config.get("Client", "FLUDD - Enable Particles", true).getBoolean(true);
            Extra.TURBINE_ANIM = config.get("Client", "Turbines - Enable Rotation", true).getBoolean(true);
            Extra.TURBINE_RATE = config.get("Other", "Turbines - Ticks between Packet Updates", 20).getInt();
            Extra.PURITY = config.get("Other", "Crucible Furnace > Nuggets Per Purity Upgrade Level", 2).getInt();
            Extra.ENDER_CONVERTER = config.get("Other", "Autodictionary > Enable Ender Pearl for Recipe", false).getBoolean(false);
            Extra.CAN_WORK_TICK = config.get("Other", "Can Work Tick", 20, "This is how many ticks before blocks check, whether they can perform their operations. This is what causes the delay for machines to start working").getInt();
            Extra.DRAGON_EGG_ETHEREAL = config.get("Other", "Incubator > Dragon Egg Chance - Ethereal", 48000, "Same as the normal chance but this is the chance when you have an ethereal upgrade in the incubator").getInt();
            Extra.DRAGON_EGG_BASE = config.get("Other", "Incubator > Dragon Egg Chance", 64000, "This is a 1 in this many chance for the chance to get a Spawn Ender Dragon from a Dragon Egg").getInt();
            Extra.EFFECT_TICK = config.get("Other", "Fish Feeder > Effect Tick", 20, "This is how many ticks for an effect to occur in a fish tank, such as poison or regen").getInt();
            Extra.FISH_FOOD_TICK = config.get("Other", "Fish Feeder > Ticks Between Fish Eating", 500).getInt();
            Extra.ACTIVATE_PUMP = config.get("Other", "Air Pump > Manual Power Enabled", true, "Whether or not the Air Pump can be activated by right clicking on it").getBoolean(true);
            Extra.REDSTONE_PUMP = config.get("Other", "Air Pump > Redstone Power Enabled", false, "Whether or not giving the Air Pump a Redstone Signal will cause it to provide air").getBoolean(false);
            Extra.BUILDCRAFT_PUMP = config.get("Other", "Air Pump > MJ/RF Power Enabled", true, "Whether an Air Pump can be powered by Redstone Flux").getBoolean(true);
            Extra.OVERWORLD = config.get("Other", "Crucible Furnace > Enable Overworld Burnt Brick Recipe", true).getBoolean(true);
            Extra.bait0 = config.get("Production", "Bait Quality 0 Chance", 20, "Ant - Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.bait1 = config.get("Production", "Bait Quality 1 Chance", 16, "Bread - Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.bait2 = config.get("Production", "Bait Quality 2 Chance", 11, "Maggot/Grasshopper - Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.bait3 = config.get("Production", "Bait Quality 3 Chance", 6, "Worm - Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.bait4 = config.get("Production", "Bait Quality 4 Chance", 3, "Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.bait5 = config.get("Production", "Bait Quality 5 Chance", 1, "Minnow - Chance of catching something in an autofisher with this bait - Lower = Better chance").getInt();
            Extra.CORAL_SPREAD_CHANCE = config.get("Production", "Coral Spread Chance", 75, "This is how fast coral will spread, lower = faster").getInt();
            Extra.KELP_SPREAD_CHANCE = config.get("Production", "Kelp Spread Moss Chance", 65, "This is how fast Kelp will spread moss to neaby blocks, lower = faster").getInt();
            Extra.KELP_GROWTH_CHANCE = config.get("Production", "Kelp Growth Chance", 200, "This is the speed that kelp will grow, lower = faster").getInt();
            Extra.GEN_ENDER_PEARLS = config.get("Other", "Pearl Oyster > Generate Ender Pearls", true).getBoolean(true);
            Extra.PEARL_GEN_CHANCE = config.get("Production", "Pearl Oyster > Pearl Generation Chance", 32, "This is the chance, that after the tick count is finished, oysters will generate a pearl. It's a X in this many chance, so lower = better chance").getInt();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"There was an issue with Mariculture when adjusting machine settings", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initIDs(Configuration config) {
        try {
            config.load();
            BlockIds.ores = config.getBlock("Ore Blocks", 750).getInt();
            BlockIds.util = config.getBlock("Machine Blocks", 751).getInt();
            BlockIds.singleBlocks = config.getBlock("Single Blocks", 752).getInt();
            BlockIds.doubleBlocks = config.getBlock("Double Blocks", 753).getInt();
            BlockIds.oyster = config.getBlock("Oyster", 754).getInt();
            BlockIds.sift = config.getBlock("Sifter", 755).getInt();
            BlockIds.woodBlocks = config.getBlock("Wooden Blocks", 756).getInt();
            BlockIds.tankBlocks = config.getBlock("Tank Blocks", 757).getInt();
            BlockIds.groundBlocks = config.getBlock("Earthy Blocks", 758).getInt();
            BlockIds.pearlBricks = config.getBlock("Pearl Bricks - Legacy", 759).getInt();
            BlockIds.limestone = config.getBlock("Limestone Variants", 759).getInt();
            BlockIds.lampsOn = config.getBlock("Neon Lamps On", 762).getInt();
            BlockIds.lampsOff = config.getBlock("Neon Lamps Off", 763).getInt();
            BlockIds.pearlBlock = config.getBlock("Pearl Bricks", 764).getInt();
            BlockIds.glassBlocks = config.getBlock("Glass Blocks", 765).getInt();
            BlockIds.coral = config.getBlock("Coral & Kelp", 766).getInt();
            BlockIds.airBlocks = config.getBlock("Air Blocks", 767).getInt();
            BlockIds.transparentBlocks = config.getBlock("Transparent Blocks", 768).getInt();
            BlockIds.customFlooring = config.getBlock("Custom Flooring", 780).getInt();
            BlockIds.customBlock = config.getBlock("Custom Blocks", 781).getInt();
            BlockIds.customStairs = config.getBlock("Custom Stairs", 782).getInt();
            BlockIds.customSlabs = config.getBlock("Custom Slabs Single", 783).getInt();
            BlockIds.customSlabsDouble = config.getBlock("Custom Slabs Double", 784).getInt();
            BlockIds.customFence = config.getBlock("Custom Fence", 785).getInt();
            BlockIds.customGate = config.getBlock("Custom Gate", 786).getInt();
            BlockIds.customWall = config.getBlock("Custom Wall", 787).getInt();
            BlockIds.customLight = config.getBlock("Custom Light", 788).getInt();
            BlockIds.customRFBlock = config.getBlock("Custom RF Block", 789).getInt();
            BlockIds.highPressureWater = config.getBlock("High Pressure Water", 800).getInt();
            ItemIds.metals = config.getItem("Materials", 29000).getInt();
            ItemIds.items = config.getItem("General Items", 29001).getInt();
            ItemIds.basicMirror = config.getItem("Basic Mirror", 29002).getInt();
            ItemIds.magicMirror = config.getItem("Magic Mirror", 29003).getInt();
            ItemIds.celestialMirror = config.getItem("Celestial Mirror", 29004).getInt();
            ItemIds.pearl = config.getItem("Pearls", 29005).getInt();
            ItemIds.batteryTitanium = config.getItem("Battery", 29006).getInt();
            ItemIds.food = config.getItem("Food", 29007).getInt();
            ItemIds.bait = config.getItem("Bait", 29008).getInt();
            ItemIds.rodReed = config.getItem("Fishing Rod - Reed", 29009).getInt();
            ItemIds.rodWood = config.getItem("Fishing Rod - Wood", 29010).getInt();
            ItemIds.rodTitanium = config.getItem("Fishing Rod - Titanium", 29011).getInt();
            ItemIds.fishy = config.getItem("Fish - Living", 29012).getInt();
            ItemIds.fishyFood = config.getItem("Fish - Raw", 29013).getInt();
            ItemIds.speedBoat = config.getItem("Speed Boat", 29014).getInt();
            ItemIds.aquaBPT1 = config.getItem("Aquatic Backpack T1", 29015).getInt();
            ItemIds.aquaBPT2 = config.getItem("Aquatic Backpack T2", 29016).getInt();
            ItemIds.ring = config.getItem("Rings", 29017).getInt();
            ItemIds.bracelet = config.getItem("Bracelets", 29018).getInt();
            ItemIds.necklace = config.getItem("Necklaces", 29019).getInt();
            ItemIds.divingHelmet = config.getItem("Diving - Helmet", 29020).getInt();
            ItemIds.divingTop = config.getItem("Diving - Breathing Tube", 29021).getInt();
            ItemIds.divingPants = config.getItem("Diving - Suit", 29022).getInt();
            ItemIds.divingBoots = config.getItem("Diving - Boots", 29023).getInt();
            ItemIds.scubaMask = config.getItem("Scuba - Mask", 29024).getInt();
            ItemIds.scubaTank = config.getItem("Scuba - Tank", 29025).getInt();
            ItemIds.scubaSuit = config.getItem("Scuba - Wetsuit", 29026).getInt();
            ItemIds.swimfin = config.getItem("Scuba - Flippers", 29027).getInt();
            ItemIds.liquidContainers = config.getItem("Liquid Containers", 29028).getInt();
            ItemIds.upgrade = config.getItem("Upgrades", 29029).getInt();
            ItemIds.net = config.getItem("Fishing Net", 29030).getInt();
            ItemIds.plans = config.getItem("Plans", 29031).getInt();
            ItemIds.fludd = config.getItem("FLUDD", 29032).getInt();
            ItemIds.paintbrush = config.getItem("Paintbrush", 29033).getInt();
            ItemIds.titanium_part_1 = config.getItem("TiC Titanium - Arrowhead", 29034).getInt();
            ItemIds.titanium_part_2 = config.getItem("TiC Titanium - Axe Head", 29035).getInt();
            ItemIds.titanium_part_3 = config.getItem("TiC Titanium - Sign Head", 29036).getInt();
            ItemIds.titanium_part_4 = config.getItem("TiC Titanium - Binding", 29037).getInt();
            ItemIds.titanium_part_5 = config.getItem("TiC Titanium - Chisel Head", 29038).getInt();
            ItemIds.titanium_part_6 = config.getItem("TiC Titanium - Shard", 29039).getInt();
            ItemIds.titanium_part_7 = config.getItem("TiC Titanium - Crossbar", 29040).getInt();
            ItemIds.titanium_part_8 = config.getItem("TiC Titanium - Excavator Head", 29041).getInt();
            ItemIds.titanium_part_9 = config.getItem("TiC Titanium - Pan", 29042).getInt();
            ItemIds.titanium_part_10 = config.getItem("TiC Titanium - Full Guard", 29043).getInt();
            ItemIds.titanium_part_11 = config.getItem("TiC Titanium - Hammer Head", 29044).getInt();
            ItemIds.titanium_part_12 = config.getItem("TiC Titanium - Knife Blade", 29045).getInt();
            ItemIds.titanium_part_13 = config.getItem("TiC Titanium - Wide Guard", 29046).getInt();
            ItemIds.titanium_part_14 = config.getItem("TiC Titanium - Large Sword Blade", 29047).getInt();
            ItemIds.titanium_part_15 = config.getItem("TiC Titanium - Large Plate", 29048).getInt();
            ItemIds.titanium_part_16 = config.getItem("TiC Titanium - Broad Axe Head", 29049).getInt();
            ItemIds.titanium_part_17 = config.getItem("TiC Titanium - Hand Guard", 29050).getInt();
            ItemIds.titanium_part_18 = config.getItem("TiC Titanium - Pickaxe Head", 29051).getInt();
            ItemIds.titanium_part_19 = config.getItem("TiC Titanium - Scythe Head", 29052).getInt();
            ItemIds.titanium_part_20 = config.getItem("TiC Titanium - Shovel Head", 29053).getInt();
            ItemIds.titanium_part_21 = config.getItem("TiC Titanium - Sword Blade", 29054).getInt();
            ItemIds.titanium_part_22 = config.getItem("TiC Titanium - Tool Rod", 29055).getInt();
            ItemIds.titanium_part_23 = config.getItem("TiC Titanium - Tough Binding", 29056).getInt();
            ItemIds.titanium_part_24 = config.getItem("TiC Titanium - Tough Rod", 29057).getInt();
            ItemIds.rodFlux = config.getItem("Fishing Rod - Flux", 29058).getInt();
            ItemIds.filter = config.getItem("Item Filter", 29059).getInt();
            ItemIds.turbineCopper = config.getItem("Rotor - Copper", 29060).getInt();
            ItemIds.turbineAluminum = config.getItem("Rotor - Aluminum", 29061).getInt();
            ItemIds.turbineTitanium = config.getItem("Rotor - Titanium", 29062).getInt();
            ItemIds.snorkel = config.getItem("Snorkel", 29063).getInt();
            ItemIds.hammer = config.getItem("Pearl Hammer", 29064).getInt();
            ItemIds.worked = config.getItem("Worked Item", 29065).getInt();
            ItemIds.batteryCopper = config.getItem("Battery(Copper)", 29066).getInt();
            ItemIds.guides = config.getItem("Guidebooks", 29067).getInt();
            ItemIds.ladle = config.getItem("Ladle", 29068).getInt();
            ItemIds.magnet = config.getItem("Magnet", 29069).getInt();
            ItemIds.bucket = config.getItem("Titanium Bucket", 29070).getInt();
            ItemIds.chalk = config.getItem("Chalk", 29071).getInt();
            ItemIds.rodBlood = config.getItem("Fishing Rod - Blood", 29072).getInt();
            ItemIds.wallArt = config.getItem("Wall Art", 29073).getInt();
            ItemIds.scanner = config.getItem("Fish Scanner", 29074).getInt();
            EnchantIds.blink = config.get("Enchantments", "Blink", 53).getInt();
            EnchantIds.clock = config.get("Enchantments", "Timelord", 54).getInt();
            EnchantIds.fall = config.get("Enchantments", "Fall Resistance", 55).getInt();
            EnchantIds.fire = config.get("Enchantments", "Inferno", 56).getInt();
            EnchantIds.flight = config.get("Enchantments", "Superman", 57).getInt();
            EnchantIds.glide = config.get("Enchantments", "Paraglide", 58).getInt();
            EnchantIds.health = config.get("Enchantments", "1 Up", 59).getInt();
            EnchantIds.jump = config.get("Enchantments", "Leapfrog", 60).getInt();
            EnchantIds.hungry = config.get("Enchantments", "Never Hungry", 61).getInt();
            EnchantIds.oneRing = config.get("Enchantments", "The One Ring", 62).getInt();
            EnchantIds.poison = config.get("Enchantments", "Poison Ivy", 63).getInt();
            EnchantIds.punch = config.get("Enchantments", "Power Punch", 64).getInt();
            EnchantIds.repair = config.get("Enchantments", "Restoration", 65).getInt();
            EnchantIds.resurrection = config.get("Enchantments", "Reaper", 66).getInt();
            EnchantIds.speed = config.get("Enchantments", "Sonic the Hedgehog", 67).getInt();
            EnchantIds.spider = config.get("Enchantments", "Spiderman", 68).getInt();
            EnchantIds.stepUp = config.get("Enchantments", "Step Up", 69).getInt();
            EnchantIds.luck = config.get("Enchantments", "Luck of the Irish", 70).getInt();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)e, (String)"Mariculture had a serious issue loading it's block/item/enchant ids", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
    }
}

