/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.crafttweaker.handlers;

import crafttweaker.CraftTweakerAPI;
import org.cyclops.cyclopscore.modcompat.crafttweaker.handlers.BaseListRemoval;
import org.cyclops.cyclopscore.modcompat.crafttweaker.handlers.RecipeRegistryAddition;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;

public class RecipeRegistryRemoval<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
extends BaseListRemoval<IRecipe<I, O, P>> {
    private final M machine;

    protected RecipeRegistryRemoval(String machineName, M machine, IRecipe<I, O, P> recipe) {
        super(machineName, machine.getRecipeRegistry().allRecipes());
        this.machine = machine;
        this.recipes.add(recipe);
    }

    protected RecipeRegistryRemoval(String machineName, M machine, O output) {
        super(machineName, machine.getRecipeRegistry().allRecipes());
        this.machine = machine;
        this.recipes.addAll(machine.getRecipeRegistry().findRecipesByOutput(output));
    }

    @Override
    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (IRecipe recipe : this.recipes) {
            if (recipe != null) {
                IRecipe removed = this.machine.getRecipeRegistry().unregisterRecipe(recipe);
                if (removed != null) {
                    this.successful.add(removed);
                    continue;
                }
                CraftTweakerAPI.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                continue;
            }
            CraftTweakerAPI.logError((String)String.format("Error removing %s Recipe: null object", this.name));
        }
    }

    @Override
    protected String getRecipeInfo(IRecipe<I, O, P> recipe) {
        return RecipeRegistryAddition.getRecipeInfo(this.name, recipe);
    }
}

