/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class PotionIngredient
extends Ingredient {
    @Nonnull
    final Potion potion;
    final int minLevel;

    public PotionIngredient(@Nonnull Potion potion, int minLevel) {
        super(PotionIngredient.getValidPotions(potion, minLevel));
        this.potion = potion;
        this.minLevel = minLevel;
    }

    public static Stream<ItemPotion> getPotions() {
        return Stream.of(Items.field_151068_bn, Items.field_185156_bI, Items.field_185155_bH);
    }

    public static ItemStack[] getValidPotions(@Nonnull Potion potion, int level) {
        boolean foundExact = false;
        List potiontypes = Streams.stream((Iterable)PotionType.field_185176_a).filter(s -> {
            if (s.func_185170_a().size() != 1) {
                return false;
            }
            PotionEffect potionEffect = (PotionEffect)s.func_185170_a().get(0);
            return potionEffect.func_188419_a() == potion && potionEffect.func_76458_c() >= level;
        }).collect(Collectors.toList());
        List stacks = potiontypes.stream().flatMap(t -> PotionIngredient.getPotions().map(ItemStack::new).map(s -> PotionUtils.func_185188_a((ItemStack)s, (PotionType)t))).collect(Collectors.toList());
        if (potiontypes.stream().map(PotionType::func_185170_a).map(t -> (PotionEffect)t.get(0)).noneMatch(s -> s.func_76458_c() == level)) {
            PotionIngredient.getPotions().map(ItemStack::new).map(s -> PotionUtils.func_185184_a((ItemStack)s, (Collection)ImmutableList.of((Object)new PotionEffect(potion, 200, level)))).forEach(stacks::add);
        }
        return (ItemStack[])stacks.stream().toArray(ItemStack[]::new);
    }

    public boolean apply(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)stack)) {
                if (effect.func_188419_a() != this.potion || effect.func_76458_c() < this.minLevel) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, @Nonnull JsonObject json) {
            String potionName = JsonUtils.func_151200_h((JsonObject)json, (String)"potion");
            Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(potionName));
            if (potion == null) {
                throw new JsonSyntaxException("Unable to find Potion - " + potionName);
            }
            int level = JsonUtils.func_151203_m((JsonObject)json, (String)"level");
            return new PotionIngredient(potion, level);
        }
    }
}

