/*
 * Decompiled with CFR 0.152.
 */
package com.astro.discordsuite;

import com.astro.discordsuite.Configuration;
import com.astro.discordsuite.DiscordSuite;
import com.astro.discordsuite.Modpack;
import com.astro.discordsuite.integration.Image;
import com.astro.discordsuite.integration.ModpackHandler;
import com.astro.discordsuite.rpc.DiscordEventHandlers;
import com.astro.discordsuite.rpc.DiscordRPC;
import com.astro.discordsuite.rpc.DiscordRichPresence;
import javax.annotation.Nonnull;

public class Client {
    public String CLIENT_ID;
    public long stamp;

    public Client(String clientId) {
        this.CLIENT_ID = clientId;
    }

    public synchronized void init() {
        DiscordEventHandlers handlers = new DiscordEventHandlers();
        DiscordRPC.Initialize(this.CLIENT_ID, handlers, false);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutDown));
    }

    public void updateTimestamp() {
        this.stamp = System.currentTimeMillis() / 1000L;
    }

    public void updatePresence(@Nonnull DiscordRichPresence presence) {
        Modpack modpack;
        if (Configuration.showTime) {
            presence.startTimestamp = this.stamp;
        }
        if (presence.largeImageKey == null || presence.largeImageKey.isEmpty()) {
            Image.MINECRAFT.withImage(presence);
        }
        if ((modpack = ModpackHandler.getModpack()) != ModpackHandler.NONE) {
            presence.smallImageKey = modpack.iconKey;
        }
        if (DiscordSuite.CURSE_MANIFEST != null && DiscordSuite.CURSE_MANIFEST.name != null && !DiscordSuite.CURSE_MANIFEST.name.isEmpty()) {
            if (modpack != ModpackHandler.NONE) {
                presence.smallImageText = DiscordSuite.CURSE_MANIFEST.name;
            }
            presence.details = presence.details + " | " + DiscordSuite.CURSE_MANIFEST.name;
        }
        DiscordRPC.UpdatePresence(presence);
    }

    public synchronized void shutDown() {
        DiscordRPC.Shutdown();
    }
}

