/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block.forgotten;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.oredict.OreDictionary;
import shadows.placebo.block.BlockEnum;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.StackPrimer;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumHarvestBush;
import shadows.plants2.data.enums.TheBigBookOfEnums;
import shadows.plants2.init.ModRegistry;

public class BlockBushLeaves
extends BlockEnum<TheBigBookOfEnums.BushSet>
implements IGrowable,
IShearable,
IHasRecipe {
    public BlockBushLeaves() {
        super("bush", Material.field_151584_j, SoundType.field_185850_c, 0.2f, 0.0f, TheBigBookOfEnums.BushSet.class, (RegistryInformation)Plants2.INFO);
        this.func_149675_a(true);
        this.func_149713_g(1);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)this.getProperty(), (Comparable)((Object)TheBigBookOfEnums.BushSet.BLACKBERRY)).func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
    }

    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.getProperty().func_177700_c().size(); ++i) {
            PlaceboUtil.sMRL((Block)this, (int)i, (String)("fruit=true,type=" + TheBigBookOfEnums.BushSet.values()[i].func_176610_l()));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || ((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).getHarvest().isEmpty()) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockEnumHarvestBush.FRUIT)).booleanValue()) {
            StackPrimer s = ((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).getHarvest();
            if (!player.func_191521_c(s.genStack()) && !world.field_72995_K) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s.genStack());
            }
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(false)));
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).ordinal();
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176473_a(world, pos, state, false)) {
            boolean couldGrow;
            boolean bl = couldGrow = rand.nextFloat() < 0.35f;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)couldGrow)) {
                this.func_176474_b(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < TheBigBookOfEnums.BushSet.values().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).ordinal() + ((Boolean)state.func_177229_b((IProperty)BlockEnumHarvestBush.FRUIT) != false ? 6 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.getProperty(), (Comparable)((Object)TheBigBookOfEnums.BushSet.values()[meta % 6])).func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(meta >= 6));
    }

    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getProperty(), BlockEnumHarvestBush.FRUIT});
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> k = new ArrayList<ItemStack>();
        if (((Boolean)state.func_177229_b((IProperty)BlockEnumHarvestBush.FRUIT)).booleanValue()) {
            k.add(((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).getHarvest().genStack());
        }
        if (ThreadLocalRandom.current().nextInt(5) == 0) {
            k.add(new ItemStack(ModRegistry.BUSHLING, 1, this.func_180651_a(state)));
        }
        return k;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        List<ItemStack> k = this.getDrops(world, pos, state, fortune);
        k.add(new ItemStack(state.func_177230_c(), 1, this.func_180651_a(state)));
        if (ThreadLocalRandom.current().nextInt(15) == 0) {
            k.clear();
            k.add(new ItemStack(ModRegistry.BUSHLING, 1, this.func_180651_a(state)));
        }
        return k;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !((TheBigBookOfEnums.BushSet)((Object)state.func_177229_b((IProperty)this.getProperty()))).getHarvest().isEmpty() && (Boolean)state.func_177229_b((IProperty)BlockEnumHarvestBush.FRUIT) == false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, false);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(true)));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }
}

