/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting;

import com.teamwizardry.wizardry.api.block.ICraftingPlateRecipe;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.crafting.craftingplaterecipes.FairyJarRecipe;
import com.teamwizardry.wizardry.crafting.craftingplaterecipes.PearlInfusionRecipe;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public final class CraftingPlateRecipeManager {
    private static final Set<ICraftingPlateRecipe> recipes = new HashSet<ICraftingPlateRecipe>();

    private CraftingPlateRecipeManager() {
    }

    @Nullable
    public static ICraftingPlateRecipe getRecipeForItem(ItemStack stack) {
        for (ICraftingPlateRecipe recipe : recipes) {
            if (!recipe.doesRecipeExistForItem(stack)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static ICraftingPlateRecipe getRecipe(World world, BlockPos pos, ItemStack stack) {
        for (ICraftingPlateRecipe recipe : recipes) {
            if (!recipe.doesRecipeExistForItem(stack) && !recipe.doesRecipeExistInWorld(world, pos)) continue;
            return recipe;
        }
        return null;
    }

    public static void addRecipe(ICraftingPlateRecipe recipe) {
        recipes.add(recipe);
    }

    public static boolean doesRecipeExistForItem(ItemStack stack) {
        for (ICraftingPlateRecipe recipe : recipes) {
            if (!recipe.doesRecipeExistForItem(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesRecipeExist(World world, BlockPos pos, ItemStack stack) {
        for (ICraftingPlateRecipe recipe : recipes) {
            if (!recipe.doesRecipeExistInWorld(world, pos) && !recipe.doesRecipeExistForItem(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean tick(World world, BlockPos pos, ItemStack input, ItemStackHandler inventoryHandler, Function<IManaCapability, Double> consumeMana) {
        ICraftingPlateRecipe recipe = null;
        for (ICraftingPlateRecipe search : recipes) {
            if (!search.doesRecipeExistInWorld(world, pos) && !search.doesRecipeExistForItem(input)) continue;
            recipe = search;
            break;
        }
        if (recipe == null) {
            return false;
        }
        if (recipe.isDone(world, pos, input)) {
            recipe.complete(world, pos, input, inventoryHandler);
            return true;
        }
        recipe.tick(world, pos, input, inventoryHandler, consumeMana);
        return false;
    }

    static {
        CraftingPlateRecipeManager.addRecipe(new PearlInfusionRecipe());
        CraftingPlateRecipeManager.addRecipe(new FairyJarRecipe());
    }
}

