/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.nemez;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.teamwizardry.wizardry.common.core.nemez.EntityMoment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class Moment {
    private final transient Map<String, EntityMoment> totalDifference = new HashMap<String, EntityMoment>();
    private final ListMultimap<String, EntityMoment> entities = ArrayListMultimap.create();
    private final ListMultimap<BlockPos, IBlockState> blocks = ArrayListMultimap.create();

    public static Moment fromNBT(NBTTagCompound nbt) {
        Moment newMoment = new Moment();
        NBTTagList blocksSerialized = nbt.func_150295_c("blocks", 10);
        NBTTagCompound entitiesSerialized = nbt.func_74775_l("entities");
        HashMap<String, EntityMoment> newTotal = new HashMap<String, EntityMoment>();
        ArrayListMultimap newEntities = ArrayListMultimap.create();
        ArrayListMultimap newBlocks = ArrayListMultimap.create();
        for (NBTBase blockUncast : blocksSerialized) {
            NBTTagCompound block = (NBTTagCompound)blockUncast;
            BlockPos pos = BlockPos.func_177969_a((long)block.func_74763_f("pos"));
            NBTTagList states = block.func_150295_c("states", 10);
            for (NBTBase stateUncast : states) {
                NBTTagCompound state = (NBTTagCompound)stateUncast;
                Block blockAt = Block.func_149684_b((String)state.func_74779_i("id"));
                if (blockAt == null) continue;
                byte meta = state.func_74771_c("data");
                newBlocks.put((Object)pos, (Object)blockAt.func_176203_a((int)meta));
            }
        }
        for (String key : entitiesSerialized.func_150296_c()) {
            NBTTagList moments = entitiesSerialized.func_150295_c(key, 10);
            EntityMoment total = EntityMoment.EMPTY;
            for (NBTBase momentUncast : moments) {
                NBTTagCompound momentCompound = (NBTTagCompound)momentUncast;
                EntityMoment moment = EntityMoment.fromNBT(momentCompound);
                total = total.withOverride(moment);
                newEntities.put((Object)key, (Object)moment);
            }
            newTotal.put(key, total);
        }
        newMoment.totalDifference.putAll(newTotal);
        newMoment.entities.putAll((Multimap)newEntities);
        newMoment.blocks.putAll((Multimap)newBlocks);
        for (String id : newMoment.entities.keySet()) {
            newMoment.capEntity(id);
        }
        for (BlockPos pos : newMoment.blocks.keySet()) {
            newMoment.capBlock(pos);
        }
        return newMoment;
    }

    public void addBlockSnapshot(BlockPos position, IBlockState newState) {
        List moments = this.blocks.get((Object)position);
        if (moments != null && !moments.isEmpty() && moments.get(moments.size() - 1) != newState) {
            return;
        }
        this.blocks.put((Object)position, (Object)newState);
        this.capBlock(position);
    }

    public void addEntitySnapshot(Entity entity) {
        String uuid = entity.func_189512_bd();
        EntityMoment total = this.totalDifference.get(uuid);
        EntityMoment newMoment = EntityMoment.fromPreviousMoment(entity, total);
        if (total == null) {
            this.totalDifference.put(uuid, newMoment);
        } else if (!total.matches(entity)) {
            this.totalDifference.put(uuid, total.withOverride(newMoment));
        } else {
            return;
        }
        this.entities.put((Object)entity.func_189512_bd(), (Object)new EntityMoment(entity));
        this.capEntity(entity);
    }

    private void capBlock(BlockPos pos) {
        List moments = this.blocks.get((Object)pos);
        if (moments.size() > 5) {
            ArrayList newMoments = Lists.newArrayList();
            int slice = moments.size() / 5;
            int remainder = moments.size() % 5;
            for (int i = 5; i > 0; --i) {
                newMoments.add(moments.get(slice * i + (i > remainder ? 1 : 0)));
            }
            this.blocks.replaceValues((Object)pos, (Iterable)newMoments);
        }
    }

    private void capEntity(Entity entity) {
        this.capEntity(entity.func_189512_bd());
    }

    private void capEntity(String id) {
        List moments = this.entities.get((Object)id);
        if (moments.size() > 5) {
            ArrayList newMoments = Lists.newArrayList();
            int slice = moments.size() / 5;
            int remainder = moments.size() % 5;
            for (int i = 5; i > 0; --i) {
                int startIndex = slice * i + (i > remainder ? 1 : 0);
                int endIndex = (slice - 1) * i;
                EntityMoment compiled = (EntityMoment)moments.get(startIndex);
                for (int subIndex = startIndex; subIndex > endIndex; --subIndex) {
                    compiled = compiled.withOverride((EntityMoment)moments.get(subIndex));
                }
                newMoments.add(compiled);
            }
            this.entities.replaceValues((Object)id, (Iterable)newMoments);
        }
    }

    public void collapse(Moment theNext) {
        this.entities.putAll(theNext.entities);
        this.blocks.putAll(theNext.blocks);
        for (String id : this.entities.keySet()) {
            this.capEntity(id);
        }
        for (BlockPos pos : this.blocks.keySet()) {
            this.capBlock(pos);
        }
    }

    public void apply(Entity entity) {
        List momentsOfEntity = this.entities.get((Object)entity.func_189512_bd());
        if (momentsOfEntity == null || momentsOfEntity.isEmpty()) {
            return;
        }
        ((EntityMoment)momentsOfEntity.get(0)).apply(entity);
    }

    public void apply(Entity entity, float partialTicks) {
        if (partialTicks == 0.0f) {
            this.apply(entity);
            return;
        }
        List momentsOfEntity = this.entities.get((Object)entity.func_189512_bd());
        if (momentsOfEntity == null || momentsOfEntity.isEmpty()) {
            return;
        }
        int stackIndexOfMoment = (int)((float)momentsOfEntity.size() * partialTicks);
        int indexOfMoment = momentsOfEntity.size() - stackIndexOfMoment;
        if (indexOfMoment == 0) {
            this.apply(entity);
            return;
        }
        EntityMoment momentToApply = (EntityMoment)momentsOfEntity.get(indexOfMoment);
        EntityMoment nextMoment = (EntityMoment)momentsOfEntity.get(indexOfMoment - 1);
        float subPartial = partialTicks * (float)momentsOfEntity.size() - (float)stackIndexOfMoment / (float)momentsOfEntity.size();
        momentToApply.apply(entity, nextMoment, subPartial);
    }

    public void apply(World world, BlockPos pos) {
        List momentsOfBlock = this.blocks.get((Object)pos);
        if (momentsOfBlock == null || momentsOfBlock.isEmpty()) {
            return;
        }
        world.func_175656_a(pos, (IBlockState)momentsOfBlock.get(0));
    }

    public void apply(World world, BlockPos pos, float partialTicks) {
        if (partialTicks == 0.0f) {
            this.apply(world, pos);
            return;
        }
        List momentsOfBlock = this.blocks.get((Object)pos);
        if (momentsOfBlock == null || momentsOfBlock.isEmpty()) {
            return;
        }
        int stackIndexOfMoment = (int)((float)momentsOfBlock.size() * partialTicks);
        int indexOfMoment = momentsOfBlock.size() - stackIndexOfMoment;
        world.func_175656_a(pos, (IBlockState)momentsOfBlock.get(indexOfMoment));
    }

    public void apply(World world, Collection<Entity> tracked) {
        for (BlockPos position : this.blocks.keySet()) {
            this.apply(world, position);
        }
        for (Entity entity : tracked) {
            this.apply(entity);
        }
    }

    public void apply(World world, Collection<Entity> tracked, float partialTicks) {
        for (BlockPos position : this.blocks.keySet()) {
            this.apply(world, position, partialTicks);
        }
        for (Entity entity : tracked) {
            this.apply(entity, partialTicks);
        }
    }

    public Moment snapshot() {
        for (String id : this.entities.keySet()) {
            this.capEntity(id);
        }
        for (BlockPos pos : this.blocks.keySet()) {
            this.capBlock(pos);
        }
        Moment moment = new Moment();
        moment.totalDifference.putAll(this.totalDifference);
        moment.entities.putAll(this.entities);
        moment.blocks.putAll(this.blocks);
        return moment;
    }

    public NBTTagCompound serializeNBT() {
        for (String id : this.entities.keySet()) {
            this.capEntity(id);
        }
        for (BlockPos pos : this.blocks.keySet()) {
            this.capBlock(pos);
        }
        NBTTagCompound momentSerialized = new NBTTagCompound();
        NBTTagList blocksSerialized = new NBTTagList();
        NBTTagCompound entitiesSerialized = new NBTTagCompound();
        momentSerialized.func_74782_a("blocks", (NBTBase)blocksSerialized);
        momentSerialized.func_74782_a("entities", (NBTBase)entitiesSerialized);
        for (BlockPos position : this.blocks.keySet()) {
            NBTTagList states = new NBTTagList();
            NBTTagCompound posCompound = new NBTTagCompound();
            posCompound.func_74772_a("pos", position.func_177986_g());
            posCompound.func_74782_a("states", (NBTBase)states);
            for (IBlockState state : this.blocks.get((Object)position)) {
                ResourceLocation regName = state.func_177230_c().getRegistryName();
                if (regName == null) continue;
                NBTTagCompound block = new NBTTagCompound();
                block.func_74778_a("id", regName.toString());
                block.func_74774_a("data", (byte)state.func_177230_c().func_176201_c(state));
                states.func_74742_a((NBTBase)block);
            }
            blocksSerialized.func_74742_a((NBTBase)posCompound);
        }
        for (String identifier : this.entities.keySet()) {
            NBTTagList moments = new NBTTagList();
            for (EntityMoment moment : this.entities.get((Object)identifier)) {
                moments.func_74742_a((NBTBase)moment.serializeNBT());
            }
            entitiesSerialized.func_74782_a(identifier, (NBTBase)moments);
        }
        return momentSerialized;
    }
}

