/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.block;

import com.teamwizardry.librarianlib.features.base.ModCreativeTab;
import com.teamwizardry.librarianlib.features.base.block.tile.BlockModContainer;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.entity.FairyData;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.common.tile.TileJar;
import com.teamwizardry.wizardry.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockJar
extends BlockModContainer {
    private static final AxisAlignedBB AABB_JAR = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);

    public BlockJar() {
        super("jar_block", Material.field_151592_s, new String[0]);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_149752_b(1.5f);
        this.func_149713_g(0);
    }

    public int getLightValue(@Nonnull IBlockState state, IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            return jar.fairy != null ? (int)(5.0 + 10.0 * jar.fairy.handler.getMana() / jar.fairy.handler.getMaxMana() * (double)(!jar.fairy.isDepressed ? 1 : 0)) : 0;
        }
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            jar.fairy = FairyData.deserialize(NBTHelper.getCompound((ItemStack)stack, (String)"fairy"));
            jar.func_70296_d();
            worldIn.func_175664_x(pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Item)ModItems.JAR_ITEM);
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            if (jar.fairy == null) {
                return stack;
            }
            stack = new ItemStack((Item)ModItems.JAR_ITEM);
            stack.func_77964_b(2);
            NBTHelper.setTag((ItemStack)stack, (String)"fairy", (NBTBase)jar.fairy.serializeNBT());
        }
        return stack;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
    }

    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        ItemStack stack = new ItemStack((Item)ModItems.JAR_ITEM);
        TileEntity entity = worldIn.func_175625_s(pos);
        if (entity instanceof TileJar) {
            TileJar jar = (TileJar)entity;
            if (jar.fairy == null) {
                return;
            }
            stack.func_77964_b(2);
            NBTHelper.setTag((ItemStack)stack, (String)"fairy", (NBTBase)jar.fairy.serializeNBT());
        }
        BlockJar.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        super.func_180663_b(worldIn, pos, state);
    }

    @Nullable
    public ItemBlock createItemForm() {
        return null;
    }

    public ModCreativeTab getCreativeTab() {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileJar) {
            TileJar jar = (TileJar)tile;
            if (jar.fairy != null) {
                ItemStack stack = playerIn.func_184586_b(hand);
                if (stack.func_190926_b() && playerIn.func_70093_af()) {
                    if (jar.fairy.isDepressed) {
                        ItemStack fairyStack = new ItemStack((Item)ModItems.FAIRY_ITEM);
                        NBTHelper.setCompound((ItemStack)fairyStack, (String)"fairy", (NBTTagCompound)jar.fairy.serializeNBT());
                        EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, fairyStack);
                        entityItem.func_174867_a(20);
                        worldIn.func_72838_d((Entity)entityItem);
                        jar.fairy = null;
                        jar.func_70296_d();
                    } else if (jar.fairy.handler.getMana() >= jar.fairy.handler.getMaxMana()) {
                        EntityFairy entity = new EntityFairy(worldIn, jar.fairy);
                        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        worldIn.func_72838_d((Entity)entity);
                        Explosion explosion = worldIn.func_72876_a((Entity)entity, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0f, true);
                        entity.func_70097_a(DamageSource.func_94539_a((Explosion)explosion), 5.0f);
                        jar.fairy = null;
                        jar.func_70296_d();
                    } else {
                        EntityFairy entity = new EntityFairy(worldIn, jar.fairy);
                        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        worldIn.func_72838_d((Entity)entity);
                        jar.fairy = null;
                        jar.func_70296_d();
                    }
                    worldIn.func_184138_a(pos, state, worldIn.func_180495_p(pos), 3);
                    worldIn.func_175664_x(pos);
                    return true;
                }
                if (stack.func_77973_b() == ModItems.SKY_DUST && !jar.fairy.isDepressed) {
                    jar.fairy.isDepressed = true;
                    jar.func_70296_d();
                    stack.func_190918_g(1);
                    worldIn.func_184138_a(pos, state, worldIn.func_180495_p(pos), 3);
                    worldIn.func_175664_x(pos);
                }
            }
        }
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_JAR;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState iBlockState) {
        return new TileJar();
    }
}

