/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.jei.fluid;

import com.google.common.collect.Lists;
import com.teamwizardry.librarianlib.features.utilities.client.TooltipHelper;
import com.teamwizardry.wizardry.client.jei.WizardryJEIPlugin;
import com.teamwizardry.wizardry.client.jei.fluid.FluidCraftingCategory;
import com.teamwizardry.wizardry.crafting.mana.FluidRecipeLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FluidRecipeJEI
implements IRecipeWrapper {
    private final FluidRecipeLoader.FluidCrafter builder;

    public FluidRecipeJEI(FluidRecipeLoader.FluidCrafter builder) {
        this.builder = builder;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ArrayList stacks = Lists.newArrayList();
        stacks.add(Lists.newArrayList((Object[])this.builder.getMainInput().func_193365_a()));
        for (Ingredient ingredient : this.builder.getInputs()) {
            stacks.add(Lists.newArrayList((Object[])ingredient.func_193365_a()));
        }
        if (!this.isFluidOutput()) {
            for (List stackList : stacks) {
                stackList.removeIf(arg_0 -> ((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.builder.getOutput()})).apply(arg_0));
            }
        }
        ingredients.setInputLists(ItemStack.class, (List)stacks);
        ingredients.setInput(FluidStack.class, (Object)new FluidStack(this.builder.getFluid(), 1000));
        if (this.isFluidOutput()) {
            ingredients.setOutput(FluidStack.class, (Object)this.builder.getFluidOutput());
        } else {
            ingredients.setOutput(ItemStack.class, (Object)this.builder.getOutput());
        }
    }

    public boolean isFluidOutput() {
        return this.builder.getFluidOutput() != null;
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        IDrawable info = WizardryJEIPlugin.manaCategory.info;
        if (mouseX >= 64 && mouseX <= 64 + info.getWidth() / 2 && mouseY >= 3 && mouseY <= 3 + info.getHeight() / 2) {
            ArrayList output = Lists.newArrayList();
            if (this.builder.isBlock()) {
                TooltipHelper.addToTooltip((List)output, (String)("jei.recipe.block." + WizardryJEIPlugin.manaCategory.getUid()), (Object[])new Object[0]);
            }
            if (this.builder.doesConsume() && (!this.builder.isBlock() || this.builder.getRequired() > 1)) {
                TooltipHelper.addToTooltip((List)output, (String)("jei.recipe.consumes." + WizardryJEIPlugin.manaCategory.getUid()), (Object[])new Object[0]);
            }
            if (this.builder.getRequired() > 1) {
                TooltipHelper.addToTooltip((List)output, (String)("jei.recipe.requires." + WizardryJEIPlugin.manaCategory.getUid()), (Object[])new Object[]{this.builder.getRequired()});
            }
            return output;
        }
        return Collections.emptyList();
    }

    public int rows() {
        return (this.builder.getInputs().size() + 2) / 3;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FluidCraftingCategory category = WizardryJEIPlugin.manaCategory;
        if (this.builder.isBlock() || this.builder.doesConsume() || this.builder.getRequired() > 1) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            category.info.draw(minecraft, 128, 6);
            GlStateManager.func_179121_F();
        }
        for (int i = 0; i < this.rows(); ++i) {
            category.slots.draw(minecraft, 11, 46 + 18 * i);
        }
    }
}

