/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class CommonWorktableModule
implements INBTSerializable<NBTTagCompound> {
    public ModuleInstance module;
    public Vec2d pos;
    @Nullable
    public CommonWorktableModule linksTo = null;
    @Nonnull
    public HashMap<ModuleInstanceModifier, Integer> modifiers = new HashMap();
    public int hash = -1;

    public CommonWorktableModule(int hash, ModuleInstance module, Vec2d pos, @Nullable CommonWorktableModule linksTo, @Nonnull HashMap<ModuleInstanceModifier, Integer> modifiers) {
        this.hash = hash;
        this.module = module;
        this.pos = pos;
        this.linksTo = linksTo;
        this.modifiers = modifiers;
    }

    private CommonWorktableModule() {
    }

    public static CommonWorktableModule deserailize(NBTTagCompound compound) {
        CommonWorktableModule worktableModule = new CommonWorktableModule();
        worktableModule.deserializeNBT(compound);
        return worktableModule;
    }

    public void addModifier(ModuleInstanceModifier moduleModifier, int count) {
        this.modifiers.put(moduleModifier, count);
    }

    public void setLinksTo(@Nullable CommonWorktableModule linksTo) {
        this.linksTo = linksTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonWorktableModule that = (CommonWorktableModule)o;
        return Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.hash != -1) {
            compound.func_74768_a("hash", this.hash);
        }
        if (this.module != null) {
            compound.func_74778_a("module", this.module.getNBTKey());
        }
        if (this.pos != null) {
            compound.func_74780_a("x", this.pos.getX());
            compound.func_74780_a("y", this.pos.getY());
        }
        if (this.linksTo != null) {
            compound.func_74782_a("linksTo", (NBTBase)this.linksTo.serializeNBT());
        }
        NBTTagCompound modifierNBT = new NBTTagCompound();
        for (ModuleInstanceModifier modifier : this.modifiers.keySet()) {
            int count = this.modifiers.get(modifier);
            modifierNBT.func_74768_a(modifier.getNBTKey(), count);
        }
        compound.func_74782_a("modifiers", (NBTBase)modifierNBT);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("module")) {
            this.module = ModuleInstance.deserialize(nbt.func_74779_i("module"));
        }
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y")) {
            this.pos = new Vec2d(nbt.func_74769_h("x"), nbt.func_74769_h("y"));
        }
        if (nbt.func_74764_b("linksTo")) {
            this.linksTo = CommonWorktableModule.deserailize(nbt.func_74775_l("linksTo"));
        }
        if (nbt.func_74764_b("modifiers")) {
            this.modifiers = new HashMap();
            for (String base : nbt.func_74775_l("modifiers").func_150296_c()) {
                ModuleInstance module = ModuleRegistry.INSTANCE.getModule(base);
                if (!(module instanceof ModuleInstanceModifier)) continue;
                int count = nbt.func_74775_l("modifiers").func_74762_e(base);
                this.modifiers.put((ModuleInstanceModifier)module, count);
            }
        }
        if (nbt.func_74764_b("hash")) {
            this.hash = nbt.func_74762_e("hash");
        }
    }
}

