/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.lifetimeobject;

import com.teamwizardry.wizardry.api.lifetimeobject.LifetimeObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class LifetimeObjectManager<T extends LifetimeObject> {
    private static final String NBT_KEY_TICK = "tick";
    private static final String NBT_KEY_ENTRIES = "entries";
    private static final String NBT_KEY_ENTRY_OBJECT = "object";
    private static final String NBT_KEY_ENTRY_TICK = "tick";
    private final Adapter<T> adapter;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final Deque<Entry> adds = new ArrayDeque<Entry>();
    private long tick;

    public LifetimeObjectManager(Adapter<T> adapter) {
        this.adapter = adapter;
    }

    public void add(T object, long lifespan) {
        this.adds.addLast(new Entry(this, object, lifespan));
    }

    public void tick(Consumer<Boolean> onChange) {
        Entry entry;
        while ((entry = this.adds.pollFirst()) != null) {
            onChange.accept(true);
            this.entries.add(entry);
            entry.object.start();
        }
        Iterator<Entry> it = this.entries.iterator();
        while (it.hasNext()) {
            Entry entry2 = it.next();
            if (--entry2.tick > 0L) {
                entry2.object.tick();
                continue;
            }
            entry2.object.stop();
            it.remove();
            onChange.accept(true);
        }
        ++this.tick;
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("tick", this.tick);
        NBTTagList entries = new NBTTagList();
        for (Entry e : this.entries) {
            this.adapter.toNbt(e.object, nbt -> {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74782_a(NBT_KEY_ENTRY_OBJECT, (NBTBase)nbt);
                entry.func_74772_a("tick", e.tick);
                entries.func_74742_a((NBTBase)entry);
            });
        }
        compound.func_74782_a(NBT_KEY_ENTRIES, (NBTBase)entries);
        return compound;
    }

    public void fromNbt(NBTTagCompound compound) {
        this.tick = compound.func_74763_f("tick");
        this.entries.clear();
        NBTTagList entries = compound.func_150295_c(NBT_KEY_ENTRIES, 10);
        for (int i = 0; i < entries.func_74745_c(); ++i) {
            NBTTagCompound entry = entries.func_150305_b(i);
            this.adapter.fromNbt(entry.func_74775_l(NBT_KEY_ENTRY_OBJECT), obj -> this.entries.add(new Entry(this, obj, entry.func_74763_f("tick"))));
        }
    }

    private final class Entry {
        private final T object;
        private long tick;
        final /* synthetic */ LifetimeObjectManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Entry(T tick, long l2) {
            void object;
            this.this$0 = (LifetimeObjectManager)l;
            this.object = object;
            this.tick = (long)tick;
        }
    }

    public static interface Adapter<T extends LifetimeObject> {
        public void toNbt(T var1, Consumer<NBTTagCompound> var2);

        public void fromNbt(NBTTagCompound var1, Consumer<T> var2);
    }
}

