/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.player.miscdata;

import com.teamwizardry.wizardry.api.capability.player.miscdata.DefaultMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.IMiscCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class MiscCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=IMiscCapability.class)
    public static final Capability<IMiscCapability> miscCapability = null;
    private final IMiscCapability capability;

    public MiscCapabilityProvider() {
        this.capability = new DefaultMiscCapability();
    }

    public MiscCapabilityProvider(IMiscCapability capability) {
        this.capability = capability;
    }

    @Nullable
    public static IMiscCapability getCap(Entity entity) {
        return (IMiscCapability)entity.getCapability(miscCapability, null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == miscCapability;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (miscCapability != null && capability == miscCapability) {
            return (T)this.capability;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.capability.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.capability.deserializeNBT((NBTBase)nbt);
    }
}

