/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import java.io.File;
import mods.waterstrainer.util.FileReaderLogFile;
import mods.waterstrainer.util.FileReaderLootTable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config {
    public static String directoryPath = null;
    public static boolean enableStrainerSurvivalist;
    public static boolean enableStrainerSurvivalistDense;
    public static boolean enableStrainerFisherman;
    public static boolean enableStrainerTypeReinforced;
    public static boolean enableStrainerTypeSolid;
    public static int durabilityNormalStrainer;
    public static int durabilityReinforcedStrainer;
    public static int durabilitySolidStrainer;
    public static int durabilityFishermansStrainer;
    public static int idleTime;
    public static int idleTimeDeviation;
    public static int bonusSolidEfficiency;
    public static int bonusReinforcedEfficiency;
    public static boolean miscEnableEfficiency;
    public static boolean miscEnableEnchanting;
    public static boolean miscShareLootTable;

    public static void init(FMLPreInitializationEvent event) {
        directoryPath = event.getModConfigurationDirectory() + "/waterstrainer/";
        Configuration config = new Configuration(new File(directoryPath + "waterstrainer.cfg"));
        config.load();
        bonusSolidEfficiency = config.get("bonus", "bonusSolidEfficiency", 10, "Bonus efficiency (in %) for Solid Strainers. Use 0 to disable bonus efficiency. [Default: 10]").getInt();
        bonusReinforcedEfficiency = config.get("bonus", "bonusReinforcedEfficiency", 25, "Bonus efficiency (in %) for Reinforced Strainers. Use 0 to disable bonus efficiency. [Default: 25]").getInt();
        enableStrainerSurvivalist = config.get("recipes", "enableStrainerSurvivalist", true).getBoolean();
        enableStrainerSurvivalistDense = config.get("recipes", "enableStrainerSurvivalistDense", true).getBoolean();
        enableStrainerFisherman = config.get("recipes", "enableStrainerFisherman", true).getBoolean();
        enableStrainerTypeSolid = config.get("recipes", "miscEnableStrainerTypeSolid", true).getBoolean();
        enableStrainerTypeReinforced = config.get("recipes", "miscEnableStrainerTypeReinforced", true).getBoolean();
        config.setCategoryComment("durability", "Set the max durability (uses) for each strainer type.\nUse 0 for infinite durability.\nDefault:\n- Fisherman's: 0 [Unbreakable]\n- Survivalist's - Normal: 120 [1 Hour]\n- Survivalist's - Solid: 720 [6 Hours]\n- Survivalist's - Reinforced: 5760 [2 Days]");
        durabilityNormalStrainer = Math.max(0, config.get("durability", "durabilityNormalStrainer", 120).getInt());
        durabilitySolidStrainer = Math.max(0, config.get("durability", "durabilitySolidStrainer", 720).getInt());
        durabilityReinforcedStrainer = Math.max(0, config.get("durability", "durabilityReinforcedStrainer", 5760).getInt());
        durabilityFishermansStrainer = Math.max(0, config.get("durability", "durabilityFishermansStrainer", 0).getInt());
        idleTime = Math.max(1, config.get("idleTime", "idleTime", 30, "Time (in seconds) until a strainer catches an item. [Default: 30]").getInt());
        idleTimeDeviation = Math.max(0, config.get("idleTime", "idleTimeDeviation", 5, "Adds a deviation to the idle time to make it more random. [Default: 5]").getInt());
        miscEnableEfficiency = config.get("misc", "miscEnableEfficiency", true, "Strainers are more or less efficient based on their placement [Default: true]").getBoolean();
        miscEnableEnchanting = config.get("misc", "miscEnableEnchanting", true, "Set if Reinforced Strainers can be enchanted. [Default: true]").getBoolean();
        miscShareLootTable = config.get("misc", "miscShareLootTable", true, "Normal, solid and reinforced strainers will share their loot table with each other. [Default: true]").getBoolean();
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static class Files {
        public static final FileReaderLootTable FILE_LOOTTABLE = new FileReaderLootTable();
        public static final FileReaderLogFile FILE_LOGFILE = new FileReaderLogFile();
    }
}

