/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.audio.MachineSound;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Sounds;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.lib.network.Packet;

public class PortableTapeDrive
implements IAudioSource {
    protected World world;
    protected Vec3d pos;
    protected Entity carrier;
    protected ItemStack self;
    protected int time = 0;
    private String storageName = "";
    private TapeDriveState state = new TapeDriveState();
    private ItemStack inventory = ItemStack.field_190927_a;
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;
    private ResourceLocation soundRes = new ResourceLocation("computronics", "tape_rewind");
    protected int clientId = -1;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(EnumFacing side) {
            return false;
        }

        @Override
        public World getSoundWorld() {
            return PortableTapeDrive.this.world;
        }

        @Override
        public Vec3d getSoundPos() {
            return PortableTapeDrive.this.pos;
        }

        @Override
        public int getSoundDistance() {
            return Config.PORTABLE_TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, @Nullable EnumFacing direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return "";
        }
    };
    public final IInventory fakeInventory = new IInventory(){

        public String func_70005_c_() {
            return "portabletapedrive.inventory";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            return PortableTapeDrive.this.inventory.func_190926_b();
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return false;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }

        public ItemStack func_70301_a(int slot) {
            if (slot != 0) {
                return ItemStack.field_190927_a;
            }
            return PortableTapeDrive.this.inventory;
        }

        public ItemStack func_70298_a(int slot, int amount) {
            if (slot != 0) {
                return ItemStack.field_190927_a;
            }
            if (!PortableTapeDrive.this.inventory.func_190926_b()) {
                if (PortableTapeDrive.this.inventory.func_190916_E() <= amount) {
                    ItemStack stack = PortableTapeDrive.this.inventory;
                    PortableTapeDrive.this.inventory = ItemStack.field_190927_a;
                    PortableTapeDrive.this.onInvUpdate();
                    return stack;
                }
                ItemStack stack = PortableTapeDrive.this.inventory.func_77979_a(amount);
                if (PortableTapeDrive.this.inventory.func_190916_E() == 0) {
                    PortableTapeDrive.this.inventory = ItemStack.field_190927_a;
                }
                PortableTapeDrive.this.onInvUpdate();
                return stack;
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            PortableTapeDrive.this.inventory = ItemStack.field_190927_a;
            PortableTapeDrive.this.onInvUpdate();
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            if (slot != 0) {
                return;
            }
            PortableTapeDrive.this.inventory = stack;
            PortableTapeDrive.this.onInvUpdate();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public void func_70296_d() {
        }
    };

    public void updateCarrier(Entity carrier, ItemStack self) {
        this.world = carrier.field_70170_p;
        this.pos = carrier.func_174791_d();
        this.carrier = carrier;
        this.self = self;
    }

    public TapeDriveState.State getEnumState() {
        return this.state.getState();
    }

    public void switchState(TapeDriveState.State s) {
        if (this.getEnumState() != s) {
            this.state.switchState(this.world, s);
            this.updateState();
        }
    }

    public void resetTime() {
        this.time = 0;
    }

    public void update() {
        if (this.world.field_72995_K) {
            this.updateSound();
        }
        TapeDriveState.State st = this.getEnumState();
        AudioPacket pkt = this.state.update(this, this.world);
        if (pkt != null) {
            this.internalSpeaker.receivePacket(pkt, null);
            pkt.sendPacket();
        }
        if (!this.world.field_72995_K && st != this.getEnumState()) {
            this.updateState();
        }
    }

    public NBTTagCompound getTag() {
        NBTTagCompound tag = this.self.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.self.func_77982_d(tag);
        }
        return tag;
    }

    public ItemStack getSelf() {
        return this.self;
    }

    protected void updateState() {
        if (this.world.field_72995_K) {
            return;
        }
        this.save(this.getTag());
        this.sendState();
    }

    protected void sendState() {
        String id = PortableDriveManager.INSTANCE.getID(this, this.world.field_72995_K);
        if (id != null) {
            try {
                Packet packet = Computronics.packet.create(PacketType.PORTABLE_TAPE_STATE.ordinal()).writeString(id).writeByte((byte)this.state.getState().ordinal()).writeInt(this.getSourceId());
                Computronics.packet.sendToAllAround(packet, this.carrier, 64.0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public float getVolume() {
        return 1.0f;
    }

    public float getPitch() {
        return 1.0f;
    }

    public boolean shouldRepeat() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSound() {
        if (this.shouldPlaySound()) {
            if (this.sound == null) {
                this.sound = new MachineSound(this.soundRes, (float)this.pos.field_72450_a, (float)this.pos.field_72448_b, (float)this.pos.field_72449_c, this.getVolume(), this.getPitch(), this.shouldRepeat()){

                    @Override
                    public void func_73660_a() {
                        this.field_147660_d = (float)PortableTapeDrive.this.pos.field_72450_a;
                        this.field_147661_e = (float)PortableTapeDrive.this.pos.field_72448_b;
                        this.field_147658_f = (float)PortableTapeDrive.this.pos.field_72449_c;
                    }
                };
                FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
            }
        } else if (this.sound != null) {
            this.sound.endPlaying();
            this.sound = null;
        }
    }

    public boolean shouldPlaySound() {
        switch (this.getEnumState()) {
            case REWINDING: 
            case FORWARDING: {
                return true;
            }
        }
        return false;
    }

    private void loadStorage() {
        ItemStack stack;
        if (this.world != null && this.world.field_72995_K) {
            return;
        }
        if (this.state.getStorage() != null) {
            this.unloadStorage();
        }
        if (!(stack = this.inventory).func_190926_b()) {
            NBTTagCompound tag;
            Item item = stack.func_77973_b();
            if (item instanceof IItemTapeStorage) {
                this.state.setStorage(((IItemTapeStorage)item).getStorage(stack));
            }
            this.storageName = stack.func_77978_p() != null ? ((tag = stack.func_77978_p()).func_74764_b("label") ? tag.func_74779_i("label") : "") : "";
        }
    }

    public void saveStorage() {
        this.unloadStorage();
    }

    private void unloadStorage() {
        if (this.world.field_72995_K || this.state.getStorage() == null) {
            return;
        }
        this.switchState(TapeDriveState.State.STOPPED);
        try {
            this.state.getStorage().onStorageUnload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.state.setStorage(null);
    }

    public void onInvUpdate() {
        if (this.inventory.func_190926_b()) {
            if (this.state.getStorage() != null) {
                this.world.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, Sounds.TAPE_EJECT.event, SoundCategory.BLOCKS, 1.0f, 0.0f);
            }
            this.unloadStorage();
        } else {
            this.loadStorage();
            if (this.inventory.func_77973_b() instanceof IItemTapeStorage) {
                this.world.func_184148_a(null, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, Sounds.TAPE_INSERT.event, SoundCategory.BLOCKS, 1.0f, 0.0f);
            }
        }
        this.save(this.getTag());
    }

    public void load(NBTTagCompound tag) {
        if (tag.func_74764_b("inv")) {
            this.inventory = new ItemStack(tag.func_74775_l("inv"));
        }
        if (tag.func_74764_b("state")) {
            this.state.setState(TapeDriveState.State.VALUES[tag.func_74771_c("state")]);
        }
        if (tag.func_74764_b("sp")) {
            this.state.packetSize = tag.func_74765_d("sp");
        }
        this.state.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
        if (tag.func_74764_b("cId")) {
            this.clientId = tag.func_74762_e("cId");
        }
        this.loadStorage();
    }

    public void save(NBTTagCompound tag) {
        NBTTagCompound inv = new NBTTagCompound();
        if (!this.inventory.func_190926_b()) {
            this.inventory.func_77955_b(inv);
        }
        tag.func_74782_a("inv", (NBTBase)inv);
        tag.func_74777_a("sp", (short)this.state.packetSize);
        tag.func_74774_a("state", (byte)this.state.getState().ordinal());
        if (this.state.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.state.soundVolume);
        }
        tag.func_74768_a("cId", this.clientId);
    }

    @Override
    public int getSourceId() {
        return this.state.getId();
    }

    public int getSourceIdClient() {
        return this.clientId;
    }

    public void setSourceIdClient(int clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean connectsAudio(EnumFacing side) {
        return true;
    }
}

