/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.IChargeBlock;
import mods.railcraft.api.core.IOwnable;
import mods.railcraft.common.blocks.interfaces.ITileCharge;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.items.RailcraftItems;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.gui.slot.PaperSlotFilter;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.network.Packet;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.railcraft.api.core.IOwnable", modid="railcraft")})
public class TileTicketMachine
extends TileEntityPeripheralBase
implements ITickable,
IOwnable,
ITileCharge {
    private GameProfile owner = new GameProfile((UUID)null, "[Railcraft]");
    private boolean isLocked = false;
    private boolean isSelectionLocked = false;
    private boolean isPrintLocked = false;
    private boolean lockChanged = false;
    private static final int paperSlot = 10;
    private static final int ticketSlot = 11;
    private int selectedSlot = 0;
    public static final Map<Charge, IChargeBlock.ChargeSpec> CHARGE_SPECS = Collections.singletonMap(Charge.distribution, new IChargeBlock.ChargeSpec(IChargeBlock.ConnectType.BLOCK, 0.1));
    private static final int powerUsage = 5;
    private int progress = 0;
    private ItemStack currentTicket = ItemStack.field_190927_a;
    private int ticketQueue = 0;
    private boolean isActive;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{10, 11};

    public TileTicketMachine() {
        super("ticket_machine");
        this.createInventory(12);
    }

    public Map<Charge, IChargeBlock.ChargeSpec> getChargeSpec() {
        return CHARGE_SPECS;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isSelectionLocked() {
        return this.isSelectionLocked;
    }

    public boolean isPrintLocked() {
        return this.isPrintLocked;
    }

    protected void sendLockChange() {
        try {
            int i = this.isLocked() ? 1 : 0;
            i |= this.isSelectionLocked() ? 2 : 0;
            i |= this.isPrintLocked() ? 4 : 0;
            Packet packet = Computronics.packet.create(PacketType.TICKET_SYNC.ordinal()).writeTileLocation(this).writeInt(i |= this.isActive ? 8 : 0).writeInt(this.selectedSlot);
            if (this.field_145850_b.field_72995_K) {
                Computronics.packet.sendToServer(packet);
            } else {
                Computronics.packet.sendToAllAround(packet, this, 64.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 20;
    }

    public void setActive(boolean active) {
        this.setActive(active, true);
    }

    public void setActive(boolean active, boolean causeUpdate) {
        this.isActive = active;
        if (causeUpdate) {
            this.markSaveDirty();
        }
    }

    public void func_73660_a() {
        super.update();
        if (this.lockChanged) {
            this.sendLockChange();
            this.lockChanged = false;
        }
        if (this.field_145850_b.field_72995_K || this.currentTicket.func_190926_b()) {
            return;
        }
        if (this.progress < this.getMaxProgress()) {
            if (this.consumeCharge(5.0)) {
                ++this.progress;
                this.setActive(true, this.isActive);
            } else {
                this.setActive(false, !this.isActive);
            }
        }
        if (this.progress >= this.getMaxProgress()) {
            ItemStack outputSlotStack = this.func_70301_a(11);
            if (!outputSlotStack.func_190926_b()) {
                if (!outputSlotStack.func_77973_b().equals(this.currentTicket.func_77973_b()) || !ItemStack.func_77970_a((ItemStack)outputSlotStack, (ItemStack)this.currentTicket)) {
                    return;
                }
                if (!outputSlotStack.func_77985_e() || outputSlotStack.func_190916_E() >= outputSlotStack.func_77976_d()) {
                    return;
                }
                this.func_70298_a(10, 1);
                outputSlotStack.func_190917_f(1);
            } else {
                this.func_70298_a(10, 1);
                this.func_70299_a(11, this.currentTicket);
            }
            --this.ticketQueue;
            this.progress = 0;
            if (this.ticketQueue <= 0) {
                this.currentTicket = ItemStack.field_190927_a;
                this.setActive(false);
            }
        }
    }

    private void markSaveDirty() {
        this.lockChanged = true;
    }

    public void setLocked(boolean locked) {
        this.setLocked(locked, true);
    }

    public void setLocked(boolean locked, boolean causeUpdate) {
        if (this.isLocked != locked) {
            this.isLocked = locked;
            if (causeUpdate) {
                this.markSaveDirty();
            }
        }
    }

    public void setSelectionLocked(boolean locked) {
        this.setSelectionLocked(locked, true);
    }

    public void setSelectionLocked(boolean locked, boolean causeUpdate) {
        if (this.isSelectionLocked() != locked) {
            this.isSelectionLocked = locked;
            if (causeUpdate) {
                this.markSaveDirty();
            }
        }
    }

    public void setPrintLocked(boolean locked) {
        this.setPrintLocked(locked, true);
    }

    public void setPrintLocked(boolean locked, boolean causeUpdate) {
        if (this.isPrintLocked() != locked) {
            this.isPrintLocked = locked;
            if (causeUpdate) {
                this.markSaveDirty();
            }
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int slot) {
        this.setSelectedSlot(slot, true);
    }

    public void setSelectedSlot(int slot, boolean causeUpdate) {
        if (slot >= 0 && slot <= 9) {
            this.selectedSlot = slot;
            if (causeUpdate) {
                this.markSaveDirty();
            }
        }
    }

    private void checkSlot(int slot) {
        if (slot < 0 || slot > 9) {
            throw new IllegalArgumentException("invalid slot: " + String.valueOf(slot + 1));
        }
    }

    private void checkAmount(ItemStack stack, int amount) {
        if (amount < 0 || amount > stack.func_77976_d()) {
            throw new IllegalArgumentException("invalid amount: " + amount);
        }
    }

    private void checkDestination(String dest) {
        if (dest.length() > 32) {
            throw new IllegalArgumentException("invalid destination");
        }
        if (this.owner == null || this.owner.getName().equals("")) {
            throw new IllegalArgumentException("invalid destination");
        }
    }

    public boolean consumeCharge(double amount) {
        if (!Config.TICKET_MACHINE_CONSUME_CHARGE) {
            return true;
        }
        return Charge.distribution.network(this.field_145850_b).access(this.field_174879_c).useCharge(amount);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    private Object[] tryConsumeEnergy(double v, String methodName) {
        int power;
        if (this.node() instanceof Connector && (power = this.tryConsumeEnergy(v)) < 0) {
            return new Object[]{null, null, power + ": " + methodName + ": not enough energy available: required" + v + ", found " + ((Connector)this.node()).globalBuffer()};
        }
        return null;
    }

    @Optional.Method(modid="opencomputers")
    private int tryConsumeEnergy(double v) {
        if (v < 0.0) {
            return -2;
        }
        v = -v;
        if (this.node() instanceof Connector) {
            Connector connector = (Connector)this.node();
            return connector.tryChangeBuffer(v) ? 1 : -1;
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("printer", "Ticket machine", "Railcraft, Inc.", "Dot matrix 3000", new String[0]);
    }

    public Object[] printTicket() {
        return this.printTicket(false);
    }

    public Object[] printTicket(boolean opencomputers) {
        return this.printTicket(this.getSelectedSlot() + 1, 1, opencomputers);
    }

    public Object[] printTicket(int amount, boolean opencomputers) {
        return this.printTicket(this.getSelectedSlot() + 1, amount, opencomputers);
    }

    public Object[] printTicket(int slot, int amount, boolean opencomputers) {
        Object[] error;
        if (this.field_145850_b.field_72995_K) {
            return new Object[0];
        }
        --slot;
        if (this.progress > 0) {
            return new Object[]{"machine is already printing"};
        }
        if (this.func_70301_a(10).func_190926_b() || this.func_70301_a(10).func_190916_E() < 1) {
            return new Object[]{false, "no paper found in paper slot"};
        }
        this.checkSlot(slot);
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return new Object[]{false, "no golden ticket in specified slot"};
        }
        ItemStack ticket = RailcraftItems.TICKET.getStack();
        if (ticket.func_190926_b()) {
            return new Object[]{false, "tickets not enabled in config"};
        }
        String destination = ItemTicket.getDestination((ItemStack)stack);
        this.checkDestination(destination);
        ItemTicket.setTicketData((ItemStack)ticket, (String)destination, (String)destination, (GameProfile)this.getOwner());
        if (opencomputers && Mods.isLoaded("opencomputers") && (error = this.tryConsumeEnergy(50.0, "printTicket")) != null) {
            return error;
        }
        if (Config.TICKET_MACHINE_CONSUME_CHARGE && !Charge.distribution.network(this.field_145850_b).access(this.field_174879_c).hasCapacity(5.0)) {
            return new Object[]{false, "not enough energy"};
        }
        this.checkAmount(ticket, amount);
        ItemStack outputSlotStack = this.func_70301_a(11);
        if (!outputSlotStack.func_190926_b()) {
            if (!outputSlotStack.func_77973_b().equals(ticket.func_77973_b()) || !ItemStack.func_77970_a((ItemStack)outputSlotStack, (ItemStack)ticket)) {
                return new Object[]{false, "output slot already contains ticket with different destination"};
            }
            if (!outputSlotStack.func_77985_e() || outputSlotStack.func_190916_E() + amount > outputSlotStack.func_77976_d()) {
                return new Object[]{false, "output slot is too full"};
            }
        }
        this.currentTicket = ticket;
        this.ticketQueue = amount;
        return new Object[]{true};
    }

    private Object[] setDestination(int slot, String destination, boolean opencomputers) {
        this.checkSlot(--slot);
        ItemStack ticket = this.func_70301_a(slot);
        if (ticket.func_77973_b() instanceof ItemTicketGold) {
            Object[] error;
            this.checkDestination(destination);
            if (opencomputers && Mods.isLoaded("opencomputers") && (error = this.tryConsumeEnergy(50.0, "printTicket")) != null) {
                return error;
            }
            ItemTicketGold.setTicketData((ItemStack)ticket, (String)destination, (String)destination, (GameProfile)this.getOwner());
            return new Object[]{true};
        }
        return new Object[]{false, "there is no golden ticket in that slot"};
    }

    private Object[] getDestination(int slot) {
        this.checkSlot(--slot);
        ItemStack ticket = this.func_70301_a(slot);
        if (ticket.func_77973_b() instanceof ItemTicketGold) {
            return new Object[]{ItemTicketGold.getDestination((ItemStack)ticket)};
        }
        return new Object[]{false, "there is no golden ticket in that slot"};
    }

    public Object[] setSelectedTicket(int slot) {
        this.checkSlot(--slot);
        this.setSelectedSlot(slot);
        return new Object[]{this.getSelectedSlot() + 1};
    }

    @Callback(doc="function([amount:number [, slot:number]]):boolean; Tries to print one or more tickets from the current or the specified ticket slot; amount may be nil; Returns true on success")
    @Optional.Method(modid="opencomputers")
    public Object[] printTicket(Context c, Arguments a) {
        if (a.count() >= 2) {
            return this.printTicket(a.checkInteger(1), a.checkAny(0) != null ? a.checkInteger(0) : 1, true);
        }
        if (a.count() >= 1) {
            return this.printTicket(a.checkAny(0) != null ? a.checkInteger(0) : 1, true);
        }
        return this.printTicket(true);
    }

    @Callback(doc="function(allowed:boolean):boolean; permits or prohibits manual printing; Returns true if manual printing is allowed")
    @Optional.Method(modid="opencomputers")
    public Object[] setManualPrintingAllowed(Context c, Arguments a) {
        this.setPrintLocked(!a.checkBoolean(0));
        return new Object[]{!this.isPrintLocked()};
    }

    @Callback(doc="function():boolean; Returns true if manual printing is allowed", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isManualPrintingAllowed(Context c, Arguments a) {
        return new Object[]{!this.isPrintLocked()};
    }

    @Callback(doc="function(allowed:boolean):boolean; permits or prohibits manually selecting a ticket; Returns true if manual ticket selection is allowed")
    @Optional.Method(modid="opencomputers")
    public Object[] setManualSelectionAllowed(Context c, Arguments a) {
        this.setSelectionLocked(!a.checkBoolean(0));
        return new Object[]{!this.isSelectionLocked()};
    }

    @Callback(doc="function():boolean; Returns true if manual ticket selection is allowed", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isManualSelectionAllowed(Context c, Arguments a) {
        return new Object[]{!this.isSelectionLocked()};
    }

    @Callback(doc="function([slot:number,] destination:string):string; Tries to set the destination of the currently selected or the specified ticket; Returns the new destination")
    @Optional.Method(modid="opencomputers")
    public Object[] setDestination(Context c, Arguments a) {
        if (a.count() >= 2) {
            return this.setDestination(a.checkInteger(0), a.checkString(1), true);
        }
        return this.setDestination(this.getSelectedSlot() + 1, a.checkString(0), true);
    }

    @Callback(doc="function([slot:number]):string; Returns the destination of the currently selected or the specified ticket")
    @Optional.Method(modid="opencomputers")
    public Object[] getDestination(Context c, Arguments a) {
        return this.getDestination(a.optInteger(0, this.getSelectedSlot() + 1));
    }

    @Callback(doc="function():number; Returns the index of the currently selected ticket", direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getSelectedTicket(Context c, Arguments a) {
        return new Object[]{this.getSelectedSlot() + 1};
    }

    @Callback(doc="function(slot:number):number; Sets the currently selected ticket slot; Returns the new selected slot")
    @Optional.Method(modid="opencomputers")
    public Object[] setSelectedTicket(Context c, Arguments a) {
        return this.setSelectedTicket(a.checkInteger(0));
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"printTicket", "setManualPrintingAllowed", "isManualPrintingAllowed", "setManualSelectionAllowed", "isManualSelectionAllowed", "getDestination", "setDestination", "getSelectedTicket", "setSelectedTicket"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            switch (method) {
                case 0: {
                    if (arguments.length < 1) {
                        return this.printTicket(false);
                    }
                    if (arguments[0] != null && !(arguments[0] instanceof Number)) {
                        throw new LuaException("first argument needs to be a number or nil");
                    }
                    if (arguments.length < 2) {
                        return this.printTicket(arguments[0] != null ? ((Number)arguments[0]).intValue() : 1, false);
                    }
                    if (!(arguments[1] instanceof Number)) {
                        throw new LuaException("second argument needs to be a number or non-existant");
                    }
                    return this.printTicket(((Number)arguments[1]).intValue(), arguments[0] != null ? ((Number)arguments[0]).intValue() : 1, false);
                }
                case 1: {
                    if (arguments.length < 1 || !(arguments[0] instanceof Boolean)) {
                        throw new LuaException("first argument needs to be a boolean");
                    }
                    this.setPrintLocked((Boolean)arguments[0] == false);
                    return new Object[]{!this.isPrintLocked()};
                }
                case 2: {
                    return new Object[]{!this.isPrintLocked()};
                }
                case 3: {
                    if (arguments.length < 1 || !(arguments[0] instanceof Boolean)) {
                        throw new LuaException("first argument needs to be a boolean");
                    }
                    this.setSelectionLocked((Boolean)arguments[0] == false);
                    return new Object[]{!this.isSelectionLocked()};
                }
                case 4: {
                    return new Object[]{!this.isSelectionLocked()};
                }
                case 5: {
                    if (arguments.length < 1) {
                        return this.getDestination(this.getSelectedSlot() + 1);
                    }
                    if (!(arguments[0] instanceof Number)) {
                        throw new LuaException("first argument needs to be a number or non-existant");
                    }
                    return this.getDestination(((Number)arguments[0]).intValue());
                }
                case 6: {
                    if (arguments.length < 1) {
                        throw new LuaException("first argument needs to be a number or string");
                    }
                    if (arguments.length < 2) {
                        if (!(arguments[0] instanceof String)) {
                            throw new LuaException("first argument needs to be a number or string");
                        }
                        return this.setDestination(this.getSelectedSlot() + 1, (String)arguments[0], false);
                    }
                    if (!(arguments[0] instanceof Number)) {
                        throw new LuaException("first argument needs to be a number or string");
                    }
                    if (!(arguments[1] instanceof String)) {
                        throw new LuaException("second argument needs to be a string or non-existant");
                    }
                    return this.setDestination(((Number)arguments[0]).intValue(), (String)arguments[1], false);
                }
                case 7: {
                    return new Object[]{this.getSelectedSlot() + 1};
                }
                case 8: {
                    if (arguments.length < 1 || !(arguments[0] instanceof Number)) {
                        throw new LuaException("first argument needs to be a number");
                    }
                    return this.setSelectedTicket(((Number)arguments[0]).intValue());
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        if (entityliving instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entityliving).func_146103_bH();
        }
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public String getLocalizationTag() {
        return this.func_145838_q().func_149739_a() + ".name";
    }

    public boolean isOwner(GameProfile player) {
        return TileTicketMachine.isSamePlayer(this.owner, player);
    }

    private static boolean isSamePlayer(GameProfile a, GameProfile b) {
        return a.getId() != null && b.getId() != null ? a.getId().equals(b.getId()) : a.getName() != null && a.getName().equals(b.getName());
    }

    @Override
    public String getSoundName() {
        return "ticket_print";
    }

    @Override
    public boolean shouldPlaySound() {
        return this.isActive;
    }

    @Override
    public float getVolume() {
        return 0.5f;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        String ownerName = "[Unknown]";
        if (tag.func_74764_b("owner")) {
            ownerName = tag.func_74779_i("owner");
        }
        UUID ownerUUID = null;
        if (tag.func_74764_b("ownerId")) {
            ownerUUID = UUID.fromString(tag.func_74779_i("ownerId"));
        }
        this.owner = new GameProfile(ownerUUID, ownerName);
        if (tag.func_74764_b("locked")) {
            this.isLocked = tag.func_74767_n("locked");
        }
        if (tag.func_74764_b("selectionLocked")) {
            this.isSelectionLocked = tag.func_74767_n("selectionLocked");
        }
        if (tag.func_74764_b("printLocked")) {
            this.isPrintLocked = tag.func_74767_n("printLocked");
        }
        if (tag.func_74764_b("selectedslot")) {
            this.selectedSlot = tag.func_74762_e("selectedslot");
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
            this.currentTicket = new ItemStack(tag.func_74775_l("currentTicket"));
            if (this.currentTicket.func_190926_b()) {
                this.progress = 0;
            }
            this.isActive = tag.func_74767_n("isActive");
            this.ticketQueue = tag.func_74762_e("ticketQueue");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        if (this.owner.getName() != null) {
            tag.func_74778_a("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            tag.func_74778_a("ownerId", this.owner.getId().toString());
        }
        tag.func_74757_a("locked", this.isLocked);
        tag.func_74757_a("selectionLocked", this.isSelectionLocked);
        tag.func_74757_a("printLocked", this.isPrintLocked);
        tag.func_74768_a("selectedslot", this.selectedSlot);
        tag.func_74768_a("progress", this.progress);
        tag.func_74757_a("isActive", this.isActive);
        if (!this.currentTicket.func_190926_b()) {
            NBTTagCompound currentTicketTag = new NBTTagCompound();
            this.currentTicket.func_77955_b(currentTicketTag);
            tag.func_74782_a("currentTicket", (NBTBase)currentTicketTag);
            tag.func_74768_a("ticketQueue", this.ticketQueue);
        }
        return tag;
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("owner");
        data.func_82580_o("ownerId");
        data.func_82580_o("locked");
        data.func_82580_o("selectionLocked");
        data.func_82580_o("printLocked");
        data.func_82580_o("selectedslot");
        data.func_82580_o("progress");
        data.func_82580_o("isActive");
        data.func_82580_o("currentTicket");
        data.func_82580_o("ticketQueue");
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        super.readFromRemoteNBT(tag);
        String ownerName = "[Unknown]";
        if (tag.func_74764_b("owner")) {
            ownerName = tag.func_74779_i("owner");
        }
        UUID ownerUUID = null;
        if (tag.func_74764_b("ownerId")) {
            ownerUUID = UUID.fromString(tag.func_74779_i("ownerId"));
        }
        this.owner = new GameProfile(ownerUUID, ownerName);
        if (tag.func_74764_b("locked")) {
            this.isLocked = tag.func_74767_n("locked");
        }
        if (tag.func_74764_b("selectionLocked")) {
            this.isSelectionLocked = tag.func_74767_n("selectionLocked");
        }
        if (tag.func_74764_b("printLocked")) {
            this.isPrintLocked = tag.func_74767_n("printLocked");
        }
        if (tag.func_74764_b("selectedslot")) {
            this.selectedSlot = tag.func_74762_e("selectedslot");
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
            this.isActive = tag.func_74767_n("isActive");
        }
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound tag) {
        tag = super.writeToRemoteNBT(tag);
        if (this.owner.getName() != null) {
            tag.func_74778_a("owner", this.owner.getName());
        }
        if (this.owner.getId() != null) {
            tag.func_74778_a("ownerId", this.owner.getId().toString());
        }
        tag.func_74757_a("locked", this.isLocked);
        tag.func_74757_a("selectionLocked", this.isSelectionLocked);
        tag.func_74757_a("printLocked", this.isPrintLocked);
        tag.func_74768_a("selectedslot", this.selectedSlot);
        tag.func_74768_a("progress", this.progress);
        tag.func_74757_a("isActive", this.isActive);
        return tag;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!super.func_94041_b(slot, stack)) {
            return false;
        }
        switch (slot) {
            case 10: {
                return PaperSlotFilter.FILTER.test(stack);
            }
        }
        return false;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return slot == 10;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return slot == 11;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return (int[])ACCESSIBLE_SLOTS.clone();
    }
}

