/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.charset.wires;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.computronics.integration.charset.wires.IntegrationCharsetWires;
import pl.asie.computronics.util.internal.IComputronicsPeripheral;
import pl.asie.lib.api.tile.IBundledRedstoneProvider;

public class ComputronicsBundledRedstoneIntegration {
    private static Capability<IBundledEmitter> CHARSET_EMITTER = null;
    private static Capability<IBundledReceiver> CHARSET_RECEIVER = null;
    private boolean registered = false;
    private static final ResourceLocation charsetBundledRedstoneID = new ResourceLocation("computronics", "charset_bundled_rs");

    @CapabilityInject(value=IBundledEmitter.class)
    private static void onBundledEmitterrInject(Capability<IBundledEmitter> c) {
        CHARSET_EMITTER = c;
        IntegrationCharsetWires.bundledRedstone.register();
    }

    @CapabilityInject(value=IBundledReceiver.class)
    private static void onBundledReceiverInject(Capability<IBundledReceiver> c) {
        CHARSET_RECEIVER = c;
        IntegrationCharsetWires.bundledRedstone.register();
    }

    public static boolean isEmitter(ICapabilityProvider tile, EnumFacing side) {
        return tile.hasCapability(CHARSET_EMITTER, side);
    }

    public static boolean isReceiver(ICapabilityProvider tile, EnumFacing side) {
        return tile.hasCapability(CHARSET_RECEIVER, side);
    }

    @Optional.Method(modid="CharsetAPI|Wires")
    public static IBundledEmitter getEmitter(ICapabilityProvider tile, EnumFacing side) {
        return (IBundledEmitter)tile.getCapability(CHARSET_EMITTER, side);
    }

    @Optional.Method(modid="CharsetAPI|Wires")
    public static IBundledReceiver getReceiver(ICapabilityProvider tile, EnumFacing side) {
        return (IBundledReceiver)tile.getCapability(CHARSET_RECEIVER, side);
    }

    private void register() {
        if (!this.registered) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered = true;
        }
    }

    @SubscribeEvent
    public void onCapabilityAttach(AttachCapabilitiesEvent<TileEntity> e) {
        if (e.getObject() instanceof IComputronicsPeripheral && e.getObject() instanceof IBundledRedstoneProvider) {
            e.addCapability(charsetBundledRedstoneID, (ICapabilityProvider)new CharsetCapabilityProvider((TileEntity)e.getObject()));
        }
    }

    private static class CharsetCapabilityProvider
    implements ICapabilityProvider {
        private final TileEntity tile;
        private final IBundledRedstoneProvider br;
        private final ComputronicsBundledEmitter[] EMITTERS = new ComputronicsBundledEmitter[7];
        private final ComputronicsBundledReceiver[] RECEIVERS = new ComputronicsBundledReceiver[7];

        public CharsetCapabilityProvider(TileEntity tile) {
            this.tile = tile;
            this.br = (IBundledRedstoneProvider)tile;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CHARSET_EMITTER && this.br.canBundledConnectToOutput(facing) || capability == CHARSET_RECEIVER && facing != null && this.br.canBundledConnectToInput(facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CHARSET_EMITTER && this.br.canBundledConnectToOutput(facing)) {
                return (T)CHARSET_EMITTER.cast((Object)this.getEmitter(facing));
            }
            if (capability == CHARSET_RECEIVER && facing != null && this.br.canBundledConnectToInput(facing)) {
                return (T)CHARSET_RECEIVER.cast((Object)this.getReceiver(facing));
            }
            return null;
        }

        private ComputronicsBundledEmitter getEmitter(@Nullable EnumFacing facing) {
            if (facing == null) {
                if (this.EMITTERS[6] == null) {
                    this.EMITTERS[6] = new ComputronicsBundledEmitter(this.tile, null);
                }
                return this.EMITTERS[6];
            }
            if (this.EMITTERS[facing.ordinal()] == null) {
                this.EMITTERS[facing.ordinal()] = new ComputronicsBundledEmitter(this.tile, facing);
            }
            return this.EMITTERS[facing.ordinal()];
        }

        private ComputronicsBundledReceiver getReceiver(EnumFacing facing) {
            if (this.RECEIVERS[facing.ordinal()] == null) {
                this.RECEIVERS[facing.ordinal()] = new ComputronicsBundledReceiver(this.tile, facing);
            }
            return this.RECEIVERS[facing.ordinal()];
        }
    }

    public static class ComputronicsBundledReceiver
    extends TileCache
    implements IBundledReceiver {
        protected ComputronicsBundledReceiver(TileEntity tile, EnumFacing side) {
            super(tile, side);
        }

        public void onBundledInputChange() {
            TileEntity tile = this.tile.func_145831_w().func_175625_s(this.tile.func_174877_v().func_177972_a(this.side));
            if (tile != null && ComputronicsBundledRedstoneIntegration.isEmitter((ICapabilityProvider)tile, this.side.func_176734_d())) {
                this.br.onBundledInputChange(this.side, ComputronicsBundledRedstoneIntegration.getEmitter((ICapabilityProvider)tile, this.side.func_176734_d()).getBundledSignal());
            }
        }
    }

    public static class ComputronicsBundledEmitter
    extends TileCache
    implements IBundledEmitter {
        protected ComputronicsBundledEmitter(TileEntity tile, @Nullable EnumFacing side) {
            super(tile, side);
        }

        public byte[] getBundledSignal() {
            return this.br.getBundledOutput(this.side);
        }
    }

    public static class TileCache {
        protected final EnumFacing side;
        protected final TileEntity tile;
        protected final IBundledRedstoneProvider br;

        protected TileCache(TileEntity tile, @Nullable EnumFacing side) {
            this.tile = tile;
            this.br = (IBundledRedstoneProvider)tile;
            this.side = side;
        }
    }
}

