/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="plustic")
public class OreRegisterPromise
extends CompletableFuture<ItemStack> {
    private static final Multimap<String, OreRegisterPromise> promises = MultimapBuilder.hashKeys().arrayListValues().build();
    private final String ore;

    public OreRegisterPromise(String ore) {
        this.ore = ore;
        this.whenComplete((T stack, U ex) -> promises.remove((Object)this.ore, (Object)this));
        NonNullList ores = OreDictionary.getOres((String)this.ore);
        if (ores.isEmpty()) {
            promises.put((Object)this.ore, (Object)this);
        } else {
            this.complete(ores.get(0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onOreRegister(OreDictionary.OreRegisterEvent event) {
        new ArrayList<OreRegisterPromise>(promises.get((Object)event.getName())).forEach(promise -> promise.complete(event.getOre()));
    }
}

