/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.sync;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.logistics.base.filters.INodeFilter;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class SyncStatementList
extends SyncPart {
    public List<INodeFilter> objs = new ArrayList<INodeFilter>();

    public SyncStatementList(int id) {
        super(id);
    }

    public List<INodeFilter> getObjects() {
        return this.objs;
    }

    public void setObjects(ArrayList<INodeFilter> list) {
        this.objs = list;
        this.markChanged();
    }

    public void addObject(INodeFilter object) {
        if (!this.objs.contains(object)) {
            this.objs.add(object);
            this.markChanged();
        }
    }

    public void removeObject(INodeFilter object) {
        if (this.objs.contains(object)) {
            this.objs.remove(object);
            this.markChanged();
        }
    }

    public void writeToBuf(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
    }

    public void readFromBuf(ByteBuf buf) {
        this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            ArrayList<INodeFilter> newObjs = new ArrayList<INodeFilter>();
            NBTTagList tagList = nbt.func_150295_c(this.getTagName(), 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                newObjs.add(InfoHelper.readFilterFromNBT(tagList.func_150305_b(i)));
            }
            this.objs = newObjs;
        } else if (nbt.func_74767_n(this.getTagName() + "E")) {
            this.objs = new ArrayList<INodeFilter>();
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList tagList = new NBTTagList();
        this.objs.forEach(obj -> {
            if (obj != null) {
                tagList.func_74742_a((NBTBase)InfoHelper.writeFilterToNBT(new NBTTagCompound(), obj, NBTHelper.SyncType.SAVE));
            }
        });
        if (!tagList.func_82582_d()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)tagList);
        } else {
            nbt.func_74757_a(this.getTagName() + "E", true);
        }
        return nbt;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SyncStatementList) {
            return ((SyncStatementList)((Object)obj)).getObjects().equals(this.objs);
        }
        return false;
    }
}

