/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;

public class PacketGSIInvalidate
implements IMessage {
    public int GSI_IDENTITY = -1;

    public PacketGSIInvalidate() {
    }

    public PacketGSIInvalidate(DisplayGSI gsi) {
        this.GSI_IDENTITY = gsi.getDisplayGSIIdentity();
    }

    public void fromBytes(ByteBuf buf) {
        this.GSI_IDENTITY = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.GSI_IDENTITY);
    }

    public static class Handler
    implements IMessageHandler<PacketGSIInvalidate, IMessage> {
        public IMessage onMessage(PacketGSIInvalidate message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    DisplayGSI gsi;
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player != null && (gsi = ClientInfoHandler.instance().getGSIMap().get(message.GSI_IDENTITY)) != null) {
                        gsi.invalidate();
                    }
                });
            }
            return null;
        }
    }
}

