/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.network.utils.ByteBufWritable;
import sonar.logistics.api.core.tiles.readers.IWirelessStorageReader;

public class PacketWirelessStorage
implements IMessage {
    public int id;
    public ByteBuf buf;
    public ByteBufWritable[] writables = null;
    public IWirelessStorageReader reader;
    public ItemStack readerStack;
    public EntityPlayer player;

    public PacketWirelessStorage() {
    }

    public PacketWirelessStorage(IWirelessStorageReader reader, ItemStack readerStack, EntityPlayer player, int id, ByteBufWritable ... writables) {
        this.reader = reader;
        this.readerStack = readerStack;
        this.player = player;
        this.id = id;
        this.writables = writables;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.buf = buf;
        buf.retain();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        if (this.writables != null) {
            boolean replaces = false;
            for (ByteBufWritable writable : this.writables) {
                writable.writeToBuf(buf);
                if (!writable.replacesDefaults) continue;
                replaces = true;
            }
            if (replaces) {
                return;
            }
        }
        this.reader.writePacket(this.readerStack, this.player, buf, this.id);
    }

    public static class Handler
    implements IMessageHandler<PacketWirelessStorage, IMessage> {
        public IMessage onMessage(PacketWirelessStorage message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                if (player == null || player.func_130014_f_().field_72995_K) {
                    return;
                }
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77973_b() instanceof IWirelessStorageReader) {
                    IWirelessStorageReader reader = (IWirelessStorageReader)stack.func_77973_b();
                    reader.readPacket(stack, player, message.buf, message.id);
                }
                message.buf.release();
            });
            return null;
        }
    }
}

