/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.network;

import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.ContainerChannelSelection;
import sonar.logistics.base.channels.GuiChannelSelection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.core.tiles.displays.info.types.progress.InfoProgressBar;
import sonar.logistics.core.tiles.readers.base.TileAbstractLogicReader;
import sonar.logistics.core.tiles.readers.info.ContainerInfoReader;
import sonar.logistics.core.tiles.readers.info.GuiInfoReader;
import sonar.logistics.core.tiles.readers.info.InfoSorter;
import sonar.logistics.core.tiles.readers.network.handling.NetworkWatcherHandler;

public class TileNetworkReader
extends TileAbstractLogicReader<IProvidableInfo> {
    public InfoSorter info_sorter = new InfoSorter();

    @Override
    public int getMaxInfo() {
        return 4;
    }

    @Override
    public AbstractChangeableList<IProvidableInfo> getViewableList(AbstractChangeableList<IProvidableInfo> updateList, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<IProvidableInfo>> channels, List<NodeConnection> usedChannels) {
        return updateList;
    }

    @Override
    public void setMonitoredInfo(AbstractChangeableList<IProvidableInfo> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        List selected = this.getSelectedInfo();
        List paired = this.getPairedInfo();
        for (int i = 0; i < this.getMaxInfo(); ++i) {
            IInfo<InfoProgressBar> latestInfo = null;
            InfoUUID id = new InfoUUID(this.getIdentity(), i);
            IMonitoredValue<IProvidableInfo> info = updateInfo.find((IProvidableInfo)selected.get(i));
            IMonitoredValue<IProvidableInfo> pair = updateInfo.find((IProvidableInfo)paired.get(i));
            if (info != null) {
                latestInfo = pair != null && InfoProgressBar.isStorableInfo(pair.getSaveableInfo()) && InfoProgressBar.isStorableInfo(info.getSaveableInfo()) ? new InfoProgressBar(info.getSaveableInfo(), pair.getSaveableInfo()) : (IInfo<InfoProgressBar>)info.getSaveableInfo();
            }
            ServerInfoHandler.instance().changeInfo(this, id, latestInfo);
        }
    }

    @Override
    public List<INetworkHandler> addValidHandlers(List<INetworkHandler> handlers) {
        handlers.add(NetworkWatcherHandler.INSTANCE);
        return handlers;
    }

    @Override
    public AbstractChangeableList<IProvidableInfo> sortMonitoredList(AbstractChangeableList<IProvidableInfo> updateInfo, int channelID) {
        return this.info_sorter.sortSaveableList(updateInfo);
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.SINGLE;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerInfoReader(player, this);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiInfoReader(player, this);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
        }
        return null;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.NETWORK_READER;
    }

    @Override
    public ILogicListSorter getSorter() {
        return this.info_sorter;
    }
}

