/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2Logging;
import sonar.logistics.api.core.tiles.connections.EnumCableConnection;
import sonar.logistics.api.core.tiles.connections.EnumCableConnectionType;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstonePowerProvider;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.connections.redstone.network.EmptyRedstoneNetwork;

public class TileRedstoneNode
extends TileSonarMultipart
implements IRedstoneConnectable,
IRedstonePowerProvider {
    public IRedstoneNetwork rNetwork = EmptyRedstoneNetwork.INSTANCE;
    private SyncTagType.INT identity = (SyncTagType.INT)new SyncTagType.INT("identity").setDefault((Object)-1);
    public SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(0).setDefault((Object)-1);
    private SyncTagType.INT power = new SyncTagType.INT("power");
    public boolean isSelfChecking = false;

    public TileRedstoneNode() {
        this.syncList.addParts(new IDirtyPart[]{this.identity, this.power});
    }

    public EnumFacing getCableFace() {
        return EnumFacing.field_82609_l[this.func_145832_p()];
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.INTERNAL;
    }

    @Override
    public int getIdentity() {
        if ((Integer)this.identity.getObject() == -1 && this.isServer()) {
            this.identity.setObject((Object)ServerInfoHandler.instance().getNextIdentity());
        }
        return (Integer)this.identity.getObject();
    }

    @Override
    public int getCurrentPower() {
        EnumFacing face = this.getCableFace();
        BlockPos adjPos = this.field_174879_c.func_177972_a(face);
        IBlockState state = this.field_145850_b.func_180495_p(adjPos);
        this.isSelfChecking = true;
        int power = RedstoneConnectionHelper.getPower(state, this.field_145850_b, adjPos, face.func_176734_d());
        this.isSelfChecking = false;
        return power;
    }

    @Override
    public EnumCableConnection canConnect(int registryID, EnumCableConnectionType type, EnumFacing dir, boolean internal) {
        EnumFacing toCheck = internal ? dir : dir.func_176734_d();
        return toCheck == this.getCableFace() ? EnumCableConnection.NETWORK : EnumCableConnection.NONE;
    }

    @Override
    public void onNetworkConnect(IRedstoneNetwork network) {
        if (!this.rNetwork.isValid() || ((Integer)this.networkID.getObject()).intValue() != network.getNetworkID()) {
            this.rNetwork = network;
            this.networkID.setObject((Object)network.getNetworkID());
        }
    }

    @Override
    public void onNetworkDisconnect(IRedstoneNetwork network) {
        if (((Integer)this.networkID.getObject()).intValue() == network.getNetworkID()) {
            this.rNetwork = EmptyRedstoneNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
        } else if ((Integer)this.networkID.getObject() != -1) {
            PL2Logging.disconnectFromWrongRedstoneNetwork(this, this.getRedstoneNetwork(), network);
        }
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getObject();
    }

    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public IRedstoneNetwork getRedstoneNetwork() {
        return this.rNetwork;
    }
}

