/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles.holographic;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.core.tiles.displays.tiles.ISmallDisplay;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.core.tiles.displays.tiles.holographic.EntityHolographicDisplay;

public abstract class TileAbstractHolographicDisplay
extends TileAbstractDisplay
implements ISmallDisplay {
    public static final int DEFAULT_COLOUR = FontHelper.getIntFromColor((int)50, (int)50, (int)100);
    public DisplayGSI gsi;
    public EntityHolographicDisplay entity;
    public SyncTagType.INT screenColour = (SyncTagType.INT)new SyncTagType.INT(3).setDefault((Object)DEFAULT_COLOUR);
    public int holographic_display_entity_id = -1;

    public TileAbstractHolographicDisplay() {
        this.syncList.addPart((IDirtyPart)this.screenColour);
    }

    public Optional<EntityHolographicDisplay> getHolographicEntity() {
        if ((this.entity == null || this.entity.field_70128_L) && this.identity != -1) {
            Entity entity = this.holographic_display_entity_id == -1 ? null : this.field_145850_b.func_73045_a(this.holographic_display_entity_id);
            this.entity = entity instanceof EntityHolographicDisplay ? (EntityHolographicDisplay)entity : this.spawnDisplayScreen();
        }
        return Optional.ofNullable(this.entity);
    }

    public EntityHolographicDisplay spawnDisplayScreen() {
        EntityHolographicDisplay display = new EntityHolographicDisplay(this.getActualWorld(), this);
        if (this.getActualWorld().func_72838_d((Entity)display)) {
            this.holographic_display_entity_id = display.func_145782_y();
        }
        return display;
    }

    @Override
    public DisplayGSI getGSI() {
        return this.gsi;
    }

    @Override
    public void setGSI(DisplayGSI gsi) {
        this.gsi = gsi;
    }

    public NBTHelper.SyncType getUpdateTagType() {
        return NBTHelper.SyncType.SAVE;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        if (this.isClient()) {
            this.getHolographicEntity().ifPresent(display -> display.setSizingFromDisplay(this));
        }
    }

    @Override
    public void onGSIValidate() {
        super.onGSIValidate();
        if (this.getActualWorld().field_72995_K) {
            this.getHolographicEntity().ifPresent(display -> display.setSizingFromDisplay(this));
        }
    }

    @Override
    public void onGSIInvalidate() {
        super.onGSIInvalidate();
        if (this.getActualWorld().field_72995_K) {
            this.getHolographicEntity().ifPresent(display -> display.func_70106_y());
        }
    }

    public abstract Vec3d getScreenOffset();

    @Override
    public Vec3d getScreenOrigin() {
        return new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5).func_178787_e(this.getScreenOffset());
    }

    public int getScreenColour() {
        return (Integer)this.screenColour.getObject();
    }

    public void setScreenColour(int colour) {
        this.screenColour.setObject((Object)colour);
    }

    public abstract void sendPropertiesToServer();
}

