/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.tiles;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenLook;

public class DisplayVectorHelper {
    public static final Vec3d X_VEC = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d Y_VEC = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d Z_VEC = new Vec3d(0.0, 0.0, 1.0);
    private static double distance;
    private static Vec3d playerV;
    private static Vec3d screenV;
    private static Vec3d lookOrigin;
    private static Vec3d origin;
    private static Vec3d intersect;
    private static Vec3d horizontal;
    private static Vec3d vertical;

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double toDegrees(double radians) {
        return radians / (Math.PI / 180);
    }

    public static Vec3d convertVector(Vec3i vec) {
        return new Vec3d((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p());
    }

    public static Vec3i convertVector(Vec3d vec) {
        return new Vec3i(Math.floor(vec.field_72450_a), Math.floor(vec.field_72448_b), Math.floor(vec.field_72449_c));
    }

    public static Vec3d readVec3d(String tagName, NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound vecTag = nbt.func_74775_l(tagName);
        return new Vec3d(vecTag.func_74769_h("x"), vecTag.func_74769_h("y"), vecTag.func_74769_h("z"));
    }

    public static NBTTagCompound writeVec3d(Vec3d vec, String tagName, NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound vecTag = new NBTTagCompound();
        vecTag.func_74780_a("x", vec.field_72450_a);
        vecTag.func_74780_a("y", vec.field_72448_b);
        vecTag.func_74780_a("z", vec.field_72449_c);
        nbt.func_74782_a(tagName, (NBTBase)vecTag);
        return nbt;
    }

    public static Vec3d getFaceOffset(EnumFacing face, double scale) {
        return DisplayVectorHelper.convertVector(face.func_176730_m()).func_186678_a(scale);
    }

    public static Vec3d getScreenRotation(EnumFacing f) {
        double pitch = f.func_96559_d() * 90;
        double yaw = f.func_176740_k().func_176722_c() ? (double)f.func_176734_d().func_185119_l() : (double)(f == EnumFacing.UP ? EnumFacing.NORTH.func_176734_d() : EnumFacing.NORTH).func_185119_l();
        double roll = 0.0;
        return new Vec3d(pitch, yaw, roll);
    }

    public static Vec3d getLookVector(double pitch, double yaw) {
        return DisplayVectorHelper.getLookVectorRadians(DisplayVectorHelper.toRadians(pitch), -DisplayVectorHelper.toRadians(yaw));
    }

    private static Vec3d getLookVectorRadians(double pitch, double yaw) {
        return new Vec3d(Math.cos(pitch) * Math.sin(yaw), -Math.sin(pitch), Math.cos(pitch) * Math.cos(yaw));
    }

    public static boolean isFacingScreen(Vec3d playerV, Vec3d screenV) {
        return playerV.func_72430_b(screenV) > 0.0;
    }

    public static double getDistanceToScreen(Vec3d lookOrigin, Vec3d screenOrigin, Vec3d playerV, Vec3d screenV) {
        return -lookOrigin.func_178788_d(screenOrigin).func_72430_b(screenV) / playerV.func_72430_b(screenV);
    }

    public static Vec3d getIntersection(Vec3d lookOrigin, Vec3d playerV, double distance) {
        return lookOrigin.func_178787_e(playerV.func_186678_a(distance));
    }

    public static Vec3d getHorizontalVector(Vec3d screenV, Vec3d rollV) {
        return screenV.func_72431_c(rollV).func_72432_b();
    }

    public static Vec3d getVerticalVector(Vec3d screenV, Vec3d hozV) {
        return screenV.func_72431_c(hozV).func_72432_b();
    }

    public static Vec3d getRollVector(Vec3d screenV, double roll, double pitch) {
        return Y_VEC.func_186678_a(Math.cos(roll)).func_178788_d(screenV.func_186678_a(Math.sin(pitch)).func_186678_a(1.0 - Math.cos(roll))).func_178787_e(screenV.func_72431_c(Y_VEC.func_186678_a(Math.sin(roll))));
    }

    public static Vec3d getHorizontalVectorSpecialCase(double yaw) {
        return X_VEC.func_186678_a(Math.cos(yaw)).func_178788_d(Z_VEC.func_186678_a(Math.sin(yaw)));
    }

    public static Vec3d getVerticalVectorSpecialCase(double yaw) {
        return X_VEC.func_186678_a(Math.sin(yaw)).func_178787_e(Z_VEC.func_186678_a(Math.cos(yaw)));
    }

    public static Vec3d[] getScreenVectors(IDisplay to, Vec3d screenV) {
        Vec3d vertical;
        Vec3d horizontal;
        if (to.getPitch() == 90.0 || to.getPitch() == -90.0) {
            double actualYaw = -DisplayVectorHelper.toRadians(to.getYaw() + (to.getPitch() == 90.0 ? to.getRoll() : -to.getRoll()));
            horizontal = DisplayVectorHelper.getHorizontalVectorSpecialCase(actualYaw);
            vertical = DisplayVectorHelper.getVerticalVectorSpecialCase(actualYaw);
            if (to.getPitch() == -90.0) {
                vertical = vertical.func_186678_a(-1.0);
            }
        } else {
            horizontal = DisplayVectorHelper.getHorizontalVector(screenV, DisplayVectorHelper.getRollVector(screenV, DisplayVectorHelper.toRadians(to.getRoll()), DisplayVectorHelper.toRadians(to.getPitch())).func_186678_a(-1.0));
            vertical = horizontal.equals((Object)Vec3d.field_186680_a) ? DisplayVectorHelper.getVerticalVectorSpecialCase(-DisplayVectorHelper.toRadians(to.getYaw())) : DisplayVectorHelper.getVerticalVector(screenV, horizontal);
        }
        return new Vec3d[]{horizontal, vertical};
    }

    public static Vec3d getTopLeft(Vec3d origin, Vec3d horizontal, Vec3d vertical, double screenWidth, double screenHeight) {
        return origin.func_178788_d(horizontal.func_186678_a(screenWidth / 2.0)).func_178787_e(vertical.func_186678_a(screenHeight / 2.0));
    }

    public static Vec3d getTopRight(Vec3d origin, Vec3d horizontal, Vec3d vertical, double screenWidth, double screenHeight) {
        return origin.func_178787_e(horizontal.func_186678_a(screenWidth / 2.0)).func_178787_e(vertical.func_186678_a(screenHeight / 2.0));
    }

    public static Vec3d getBottomLeft(Vec3d origin, Vec3d horizontal, Vec3d vertical, double screenWidth, double screenHeight) {
        return origin.func_178788_d(horizontal.func_186678_a(screenWidth / 2.0)).func_178788_d(vertical.func_186678_a(screenHeight / 2.0));
    }

    public static Vec3d getBottomRight(Vec3d origin, Vec3d horizontal, Vec3d vertical, double screenWidth, double screenHeight) {
        return origin.func_178787_e(horizontal.func_186678_a(screenWidth / 2.0)).func_178788_d(vertical.func_186678_a(screenHeight / 2.0));
    }

    @Nullable
    public static double[] getClickedPosition(IDisplay to, Vec3d origin, Vec3d intersect, Vec3d horizontal, Vec3d vertical) {
        Vec3d pos = intersect.func_178788_d(origin);
        double intersect_hoz = pos.func_72430_b(horizontal);
        double intersect_ver = pos.func_72430_b(vertical);
        if (-to.getWidth() / 2.0 < intersect_hoz && intersect_hoz < to.getWidth() / 2.0 && -to.getHeight() / 2.0 < intersect_ver && intersect_ver < to.getHeight() / 2.0) {
            return new double[]{to.getWidth() - (pos.func_72430_b(horizontal) + to.getWidth() / 2.0), to.getHeight() - (pos.func_72430_b(vertical) + to.getHeight() / 2.0)};
        }
        return null;
    }

    @Nullable
    public static double[] getDisplayLook(Entity from, IDisplay to, double maxDist) {
        if (from == null || to == null) {
            return null;
        }
        playerV = DisplayVectorHelper.getLookVector(from.field_70125_A, from.field_70177_z);
        if (DisplayVectorHelper.isFacingScreen(playerV, screenV = DisplayVectorHelper.getLookVector(to.getPitch(), to.getYaw())) && Math.abs(distance = DisplayVectorHelper.getDistanceToScreen(lookOrigin = from.func_174824_e(1.0f), origin = to.getScreenOrigin(), playerV, screenV)) < maxDist) {
            intersect = DisplayVectorHelper.getIntersection(lookOrigin, playerV, distance);
            Vec3d[] vectors = DisplayVectorHelper.getScreenVectors(to, screenV);
            horizontal = vectors[0];
            vertical = vectors[1];
            return DisplayVectorHelper.getClickedPosition(to, origin, intersect, horizontal, vertical);
        }
        return null;
    }

    @Nullable
    public static DisplayScreenClick createClick(EntityPlayer player, IDisplay display, BlockInteractionType type) {
        DisplayScreenClick position = new DisplayScreenClick();
        double[] clickPosition = DisplayVectorHelper.getDisplayLook((Entity)player, display, 8.0);
        if (clickPosition != null) {
            position.identity = display.getInfoContainerID();
            position.setClickPosition(clickPosition);
            position.gsi = display.getGSI();
            position.type = type;
            position.intersect = intersect;
            return position;
        }
        return null;
    }

    @Nullable
    public static DisplayScreenLook createLook(EntityPlayer player, IDisplay display) {
        DisplayScreenLook look = new DisplayScreenLook();
        double[] lookPosition = DisplayVectorHelper.getDisplayLook((Entity)player, display, 8.0);
        if (lookPosition != null) {
            look.identity = display.getInfoContainerID();
            look.setLookPosition(lookPosition);
            return look;
        }
        return null;
    }

    public static DisplayScreenClick createFakeClick(DisplayGSI gsi, double clickX, double clickY, boolean doubleClick, int key) {
        DisplayScreenClick fakeClick = new DisplayScreenClick();
        fakeClick.gsi = gsi;
        fakeClick.type = key == 0 ? BlockInteractionType.LEFT : BlockInteractionType.RIGHT;
        fakeClick.clickX = clickX;
        fakeClick.clickY = clickY;
        fakeClick.intersect = DisplayVectorHelper.convertVector((Vec3i)gsi.getDisplay().getActualDisplay().getCoords().getBlockPos());
        fakeClick.identity = gsi.getDisplayGSIIdentity();
        fakeClick.doubleClick = doubleClick;
        fakeClick.fakeGuiClick = true;
        return fakeClick;
    }
}

