/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.IDisplayAction;
import sonar.logistics.core.tiles.displays.info.InfoRenderHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.elements.buttons.ButtonElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public class DisplayElementHelper {
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int SCALE = 2;

    public static double[] scaleFromPercentage(double[] percentage, double[] toFit) {
        double[] scale = new double[percentage.length];
        int max = Math.min(percentage.length, toFit.length);
        for (int i = 0; i < max; ++i) {
            double p = percentage[i];
            double s = toFit[i];
            scale[i] = s / 100.0 * p;
        }
        return scale;
    }

    public static double[] percentageFromScale(double[] size, double[] maximum) {
        double[] percentage = new double[size.length];
        int max = Math.min(size.length, maximum.length);
        for (int i = 0; i < max; ++i) {
            double s = Math.min(size[i], maximum[i]);
            double m = Math.max(size[i], maximum[i]);
            percentage[i] = s / m * 100.0;
        }
        return percentage;
    }

    public static double[] toNearestPixel(double[] original, double[] max) {
        return DisplayElementHelper.toNearestMultiple(original, max, 0.0625);
    }

    public static double toNearestPixel(double original, double max) {
        return DisplayElementHelper.toNearestMultiple(original, max, 0.0625);
    }

    public static double[] toNearestMultiple(double[] original, double[] max, double multiple) {
        double[] scale = new double[original.length];
        for (int i = 0; i < scale.length; ++i) {
            scale[i] = DisplayElementHelper.toNearestMultiple(original[i], max[i], multiple);
        }
        return scale;
    }

    public static double toNearestMultiple(double original, double max, double multiple) {
        return Math.min(multiple * Math.floor(Math.abs(original / multiple)), max);
    }

    public static double[] scaleArray(double[] toScale, double scale) {
        double[] newScale = new double[toScale.length];
        for (int i = 0; i < newScale.length; ++i) {
            newScale[i] = toScale[i] * scale;
        }
        return newScale;
    }

    public static void renderElementStorageHolder(IElementStorageHolder holder) {
        holder.getElements().forEach(e -> DisplayElementHelper.renderElementInHolder(holder, e));
    }

    public static void renderElementInHolder(IElementStorageHolder holder, IDisplayElement e) {
        holder.startElementRender(e);
        GlStateManager.func_179094_E();
        DisplayElementHelper.align(holder.getAlignmentTranslation(e));
        if (e.getGSI().isErrored(e)) {
            List<IInfoError> errors = e.getGSI().getErrors(e);
            if (errors != null && !errors.isEmpty()) {
                InfoRenderHelper.renderCenteredStringsWithUniformScaling(errors.get(0).getDisplayMessage(), e.getActualScaling()[0], e.getActualScaling()[1], 0, 0.75, -1);
            }
        } else {
            double scale = e.getActualScaling()[2];
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            e.render();
        }
        GlStateManager.func_179121_F();
        holder.endElementRender(e);
    }

    public static double[] alignArray(double[] actualListScaling, double[] actualElementScaling, WidthAlignment width, HeightAlignment height) {
        double x = DisplayElementHelper.alignWidth(actualListScaling, actualElementScaling, width);
        double y = DisplayElementHelper.alignHeight(actualListScaling, actualElementScaling, height);
        double z = 0.0;
        return new double[]{x, y, z};
    }

    public static void align(double[] actualListScaling, double[] actualElementScaling, WidthAlignment width, HeightAlignment height) {
        double[] alignArray = DisplayElementHelper.alignArray(actualListScaling, actualElementScaling, width, height);
        DisplayElementHelper.align(alignArray);
    }

    public static void align(double[] align) {
        GlStateManager.func_179137_b((double)align[0], (double)align[1], (double)0.0);
    }

    public static double alignWidth(double[] actualListScaling, double[] actualElementScaling, WidthAlignment align) {
        switch (align) {
            case CENTERED: {
                return actualListScaling[0] / 2.0 - actualElementScaling[0] / 2.0;
            }
            case LEFT: {
                break;
            }
            case RIGHT: {
                return actualListScaling[0] - actualElementScaling[0];
            }
        }
        return 0.0;
    }

    public static double alignHeight(double[] actualListScaling, double[] actualElementScaling, HeightAlignment align) {
        switch (align) {
            case CENTERED: {
                return actualListScaling[1] / 2.0 - actualElementScaling[1] / 2.0;
            }
            case TOP: {
                break;
            }
            case BOTTOM: {
                return actualListScaling[1] - actualElementScaling[1];
            }
        }
        return 0.0;
    }

    public static double[] getScaling(int[] unscaled, double[] scaling, double percentageFill) {
        double actualElementScale = Math.min(scaling[0] / (double)unscaled[0], scaling[1] / (double)unscaled[1]);
        double actualElementWidth = (double)unscaled[0] * actualElementScale * percentageFill;
        double actualElementHeight = (double)unscaled[1] * actualElementScale * percentageFill;
        return new double[]{actualElementWidth, actualElementHeight, actualElementScale};
    }

    public static void drawGrid(double left, double top, double right, double bottom, double xSizing, double ySizing, int color) {
        int i;
        if (left < right) {
            double i2 = left;
            left = right;
            right = i2;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        int yElements = (int)(Math.max(top, bottom) / ySizing);
        int xElements = (int)(Math.max(left, right) / xSizing);
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (i = 0; i < yElements + 1; ++i) {
            bufferbuilder.func_181662_b(left, (double)i * ySizing - 0.015625, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(right, (double)i * ySizing - 0.015625, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(right, (double)i * ySizing + 0.015625, 0.0).func_181675_d();
            bufferbuilder.func_181662_b(left, (double)i * ySizing + 0.015625, 0.0).func_181675_d();
        }
        for (i = 0; i < xElements + 1; ++i) {
            bufferbuilder.func_181662_b((double)i * xSizing + 0.015625, bottom, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)i * xSizing - 0.015625, bottom, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)i * xSizing - 0.015625, top, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)i * xSizing + 0.015625, top, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    public static void drawRect(double left, double top, double right, double bottom, int color) {
        if (left < right) {
            double i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            double j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179140_f();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        RenderHelper.saveBlendState();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(left, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179117_G();
        RenderHelper.restoreBlendState();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    public static void renderPageButons(double[] scaling, int page, int pageCount) {
        double[] scale = DisplayElementHelper.getScaling(new int[]{1, 1}, DisplayElementHelper.scaleArray(scaling, 0.1), 1.0);
        GlStateManager.func_179137_b((double)0.0, (double)(scaling[1] - scaling[1] / 8.0), (double)0.0);
        GlStateManager.func_179139_a((double)scale[2], (double)scale[2], (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ButtonElement.BUTTON_TEX);
        RenderHelper.drawModalRectWithCustomSizedTexture((double)(scaling[0] / 8.0 * 2.0 / scale[2] - 0.5), (double)0.0, (double)14.5, (double)1.375, (double)1.0, (double)0.6, (double)16.0, (double)16.0);
        RenderHelper.drawModalRectWithCustomSizedTexture((double)((scaling[0] - scaling[0] / 8.0 * 2.0) / scale[2] - 0.5), (double)0.0, (double)14.5, (double)2.75, (double)1.0, (double)0.6, (double)16.0, (double)16.0);
        GlStateManager.func_179137_b((double)(scaling[0] / 2.0 / scale[2]), (double)0.0, (double)0.0);
        GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)1.0);
        GlStateManager.func_179140_f();
        String pageText = page + " / " + pageCount;
        int width = FontHelper.width((String)pageText);
        GlStateManager.func_179109_b((float)(-width / 2), (float)2.0f, (float)0.0f);
        FontHelper.text((String)pageText, (int)0, (int)0, (int)-1);
    }

    public static int doPageClick(double subClickX, double subClickY, double[] scaling, int page, int pageCount) {
        if (subClickY > scaling[1] - scaling[1] / 8.0) {
            if (subClickX < scaling[0] / 2.0) {
                if (page != 0) {
                    return page - 1;
                }
            } else if (page != pageCount) {
                return page + 1;
            }
        }
        return page;
    }

    public static int getRegisteredID(IDisplayElement info) {
        if (info == null || info.getRegisteredName() == null) {
            return -1;
        }
        Integer id = PL2ASMLoader.elementIDs.get(info.getRegisteredName());
        return id == null ? -1 : id;
    }

    public static Class<? extends IDisplayElement> getElementClass(int id) {
        return PL2ASMLoader.elementIClasses.get(id);
    }

    public static NBTTagCompound saveElement(NBTTagCompound tag, IDisplayElement info, NBTHelper.SyncType type) {
        tag.func_74768_a("EiD", DisplayElementHelper.getRegisteredID(info));
        return info.writeData(tag, type);
    }

    public static IDisplayElement loadElement(NBTTagCompound tag, IElementStorageHolder holder) {
        int elementID = tag.func_74762_e("EiD");
        return DisplayElementHelper.instanceDisplayElement(DisplayElementHelper.getElementClass(elementID), holder, tag);
    }

    @Nullable
    public static <T extends IDisplayElement> T instanceDisplayElement(Class<T> classType, IElementStorageHolder holder, NBTTagCompound tag) {
        IDisplayElement obj = null;
        try {
            if (classType != null) {
                obj = (IDisplayElement)classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
        }
        if (obj != null) {
            obj.setHolder(holder);
            obj.readData(tag, NBTHelper.SyncType.SAVE);
            return (T)obj;
        }
        return null;
    }

    public static int getRegisteredID(IStyledString info) {
        return PL2ASMLoader.sstringIDs.get(info.getRegisteredName());
    }

    public static Class<? extends IStyledString> getStyledStringClass(int id) {
        return PL2ASMLoader.sstringIClasses.get(id);
    }

    public static NBTTagCompound saveStyledString(NBTTagCompound tag, IStyledString string, NBTHelper.SyncType type) {
        if (!(string instanceof StyledString)) {
            tag.func_74768_a("SSiD", DisplayElementHelper.getRegisteredID(string));
        }
        return string.writeData(tag, type);
    }

    public static IStyledString loadStyledString(StyledStringLine line, NBTTagCompound tag) {
        int elementID = tag.func_74762_e("SSiD");
        Class clazz = elementID == 0 ? StyledString.class : DisplayElementHelper.getStyledStringClass(elementID);
        return DisplayElementHelper.instanceStyledString(clazz, line, tag);
    }

    @Nullable
    public static <T extends IStyledString> T instanceStyledString(Class<T> classType, StyledStringLine line, NBTTagCompound tag) {
        IStyledString obj = null;
        try {
            obj = (IStyledString)classType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
        }
        if (obj != null) {
            obj.setLine(line);
            obj.readData(tag, NBTHelper.SyncType.SAVE);
            return (T)obj;
        }
        return null;
    }

    public static int getRegisteredID(IDisplayAction info) {
        return PL2ASMLoader.displayActionIDs.get(info.getRegisteredName());
    }

    public static Class<? extends IDisplayAction> getDisplayActionClass(int id) {
        return PL2ASMLoader.displayActionIClasses.get(id);
    }

    public static NBTTagCompound saveDisplayAction(NBTTagCompound tag, IDisplayAction info, NBTHelper.SyncType type) {
        tag.func_74768_a("AiD", DisplayElementHelper.getRegisteredID(info));
        return info.writeData(tag, type);
    }

    public static IDisplayAction loadDisplayAction(NBTTagCompound tag) {
        int elementID = tag.func_74762_e("AiD");
        return DisplayElementHelper.instanceDisplayAction(DisplayElementHelper.getDisplayActionClass(elementID), tag);
    }

    @Nullable
    public static <T extends IDisplayAction> T instanceDisplayAction(Class<T> classType, NBTTagCompound tag) {
        IDisplayAction obj = null;
        try {
            obj = (IDisplayAction)classType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
        }
        if (obj != null) {
            obj.readData(tag, NBTHelper.SyncType.SAVE);
            return (T)obj;
        }
        return null;
    }
}

