/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.input.Keyboard;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.client.gui.GuiGridElement;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2Translate;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiAbstractEditGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GuiEditElementsList
extends GuiAbstractEditGSI
implements IGridGui {
    public Map<SelectionGrid, SonarScroller> grids = new HashMap<SelectionGrid, SonarScroller>();
    public List elements;
    public List<IDisplayElement> selected = new ArrayList<IDisplayElement>();
    private int defgridXStart = 4;
    private int defgridYStart = 154;
    private int defgridElementWidth = 218;
    private int defgridElementHeight = 14;
    private int defgridWidth = 1;
    private int defgridHeight = 5;

    public GuiEditElementsList(DisplayGSI gsi, TileAbstractDisplay display) {
        super(gsi, display);
        this.updateElementsList();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        HashMap<SelectionGrid, SonarScroller> newgrids = new HashMap<SelectionGrid, SonarScroller>();
        this.addGrids(newgrids);
        this.grids = newgrids;
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152 + 36, 32, 32, PL2Translate.BUTTON_DELETE.t(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152, 192, 0, PL2Translate.BUTTON_EDIT.t(), ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 2, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152 + 18, 192, 16, "Resize Element", ""));
        this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 3, this.field_147003_i + 4 + 176 + 54, this.field_147009_r + 152 + 54, 32, 32, PL2Translate.BUTTON_RESET.t(), ""));
    }

    public void updateElementsList() {
        ArrayList<INBTSyncable> elements = new ArrayList<INBTSyncable>();
        for (DisplayElementContainer c : this.gsi.containers.values()) {
            if (this.gsi.isEditContainer(c)) continue;
            elements.add(c);
            for (IDisplayElement e : c.getElements()) {
                elements.add(e);
            }
        }
        this.elements = elements;
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                List<Integer> toDelete = this.getSelectedElementIdentities();
                if (!toDelete.isEmpty()) {
                    GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createDeleteElementsPacket(toDelete), -1, this.gsi);
                    ArrayList elements = Lists.newArrayList((Iterable)this.elements);
                    this.selected.forEach(elements::remove);
                    this.selected.clear();
                    this.elements = elements;
                }
                return;
            }
            case 1: {
                Object editScreen;
                Optional<IDisplayElement> element;
                if (this.selected.isEmpty() || !(element = this.selected.stream().filter(Objects::nonNull).findFirst()).isPresent() || (editScreen = element.get().getClientEditGui(this.display, (Object)this, (World)this.field_146297_k.field_71441_e, (EntityPlayer)this.field_146297_k.field_71439_g)) == null) break;
                FMLClientHandler.instance().showGuiScreen(editScreen);
                break;
            }
            case 2: {
                Optional<IDisplayElement> element;
                if (this.selected.isEmpty() || !(element = this.selected.stream().filter(Objects::nonNull).findFirst()).isPresent()) break;
                this.gsi.grid_mode.startResizeSelectionMode(element.get().getHolder().getContainer().getContainerIdentity());
                this.field_146297_k.field_71439_g.func_71053_j();
                break;
            }
            case 3: {
                GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createResetGSIPacket(), -1, this.gsi);
            }
        }
    }

    public List<Integer> getSelectedElementIdentities() {
        ArrayList<Integer> identities = new ArrayList<Integer>();
        this.selected.forEach(e -> identities.add(e.getElementIdentity()));
        return identities;
    }

    public List<IDisplayElement> getGridList(int gridID) {
        if (gridID == 0) {
            return this.elements;
        }
        return null;
    }

    public void renderStrings(int x, int y) {
    }

    public float getCurrentScroll(SelectionGrid gridID) {
        return this.grids.get(gridID).getCurrentScroll();
    }

    @Override
    public void onDisplayElementClicked(IDisplayElement e, DisplayScreenClick fakeClick, double[] subClick) {
        if (e != null) {
            if (this.selected.contains(e)) {
                this.selected.removeIf(ee -> e == ee);
            } else {
                this.selected.add(e);
            }
        }
    }

    public void onGridClicked(int gridID, Object element, int x, int y, int pos, int button, boolean empty) {
        if (element instanceof IDisplayElement) {
            if (this.selected.contains(element)) {
                this.selected.remove(element);
            } else {
                this.selected.add((IDisplayElement)element);
            }
        }
    }

    public void renderGridElement(int gridID, Object obj, int x, int y, int slot) {
        if (obj instanceof IDisplayElement) {
            IDisplayElement element = (IDisplayElement)obj;
            if (this.selected.contains(element)) {
                GlStateManager.func_179140_f();
                GuiEditElementsList.drawTransparentRect((int)0, (int)0, (int)(this.defgridElementWidth - 2), (int)this.defgridElementHeight, (int)PL2Colours.getDefaultSelection().getRGB());
            }
            FontHelper.text((String)element.getRepresentiveString(), (int)4, (int)3, (int)-1);
            FontHelper.text((String)"", (int)92, (int)3, (int)-1);
            FontHelper.text((String)element.getRegisteredName(), (int)144, (int)3, (int)-1);
        } else if (obj instanceof DisplayElementContainer) {
            DisplayElementContainer element = (DisplayElementContainer)obj;
            GlStateManager.func_179140_f();
            GuiEditElementsList.drawTransparentRect((int)0, (int)0, (int)(this.defgridElementWidth - 2), (int)this.defgridElementHeight, (int)PL2Colours.category.getRGB());
            FontHelper.text((String)("Element Container: " + element.containerIdentity), (int)4, (int)3, (int)-1);
        }
    }

    public void renderElementToolTip(int gridID, Object element, int x, int y) {
    }

    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
        SonarScroller grid_scroller = new SonarScroller(this.defgridXStart + this.defgridElementWidth * this.defgridWidth, this.defgridYStart - 1, this.defgridElementHeight * this.defgridHeight + 2, 10);
        SelectionGrid grid = new SelectionGrid((IGridGui)this, 0, this.defgridXStart, this.defgridYStart, this.defgridElementWidth, this.defgridElementHeight, this.defgridWidth, this.defgridHeight);
        grids.put(grid, grid_scroller);
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || button == 1) {
            this.grids.forEach((grid, scroll) -> grid.mouseClicked((GuiSonar)this, x, y, button));
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.updateElementsList();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderStrings(x, y);
        GlStateManager.func_179145_e();
        for (Map.Entry<SelectionGrid, SonarScroller> entry : this.grids.entrySet()) {
            this.renderScroller(entry.getValue());
            entry.getKey().renderGrid((GuiSonar)this, x, y);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        DisplayElementHelper.align(this.getAlignmentTranslation());
        GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        GlStateManager.func_179139_a((double)this.getActualScaling()[2], (double)this.getActualScaling()[2], (double)1.0);
        for (DisplayElementContainer container : this.gsi.containers.values()) {
            boolean match = this.selected.stream().anyMatch(e -> e.getHolder().getContainer() == container);
            if (!match || !container.canRender() || this.gsi.isEditContainer(container)) continue;
            double[] translation = container.getTranslation();
            double[] scaling = container.getContainerMaxScaling();
            RenderHelper.saveBlendState();
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
            GlStateManager.func_179097_i();
            DisplayElementHelper.drawRect(translation[0], translation[1], translation[0] + scaling[0], translation[1] + scaling[1], new CustomColour(49, 145, 88).getRGB());
            GlStateManager.func_179084_k();
            RenderHelper.restoreBlendState();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public void startToolTipRender(int gridID, Object selection, int x, int y) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        this.renderElementToolTip(gridID, selection, x, y);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.grids.forEach((grid, scroll) -> scroll.handleMouse((GuiGridElement)grid));
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.grids.forEach((grid, scroll) -> {
            grid.setList((List)Lists.newArrayList(this.getGridList(grid.gridID)));
            scroll.drawScreen(x - this.field_147003_i, y - this.field_147009_r, grid.isScrollable());
        });
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        GlStateManager.func_179140_f();
        this.grids.forEach((grid, scroll) -> {
            GuiEditElementsList.drawTransparentRect((int)(this.field_147003_i + grid.xPos - 1), (int)(this.field_147009_r + grid.yPos - 1), (int)(this.field_147003_i + grid.xPos + grid.eWidth * grid.gWidth - 1), (int)(this.field_147009_r + grid.yPos + grid.eHeight * grid.gHeight - 1), (int)PL2Colours.grey_base.getRGB());
            GuiEditElementsList.drawTransparentRect((int)(this.field_147003_i + grid.xPos), (int)(this.field_147009_r + grid.yPos), (int)(this.field_147003_i + grid.xPos + grid.eWidth * grid.gWidth - 2), (int)(this.field_147009_r + grid.yPos + grid.eHeight * grid.gHeight - 2), (int)PL2Colours.blue_overlay.getRGB());
        });
    }
}

