/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data.convertors;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.data.AbstractDataConvertor;
import sonar.logistics.base.data.DataFactory;
import sonar.logistics.base.data.api.IDataHolder;
import sonar.logistics.base.data.api.IDataWatcher;
import sonar.logistics.base.data.sources.MultiDataSource;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.displays.info.types.InfoError;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.displays.info.types.progress.InfoProgressBar;
import sonar.logistics.core.tiles.readers.items.TileInventoryReader;
import sonar.logistics.core.tiles.readers.items.handling.ItemHelper;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkChannels;

public abstract class UpdaterInventoryReader
extends AbstractDataConvertor<TileInventoryReader> {
    public UpdaterInventoryReader(InfoUUID uuid, TileInventoryReader source) {
        super(uuid, source);
    }

    public ItemChangeableList getUUIDLatestList(InfoUUID uuid) {
        return (ItemChangeableList)ServerInfoHandler.instance().getChangeableListMap().compute(uuid, (v, l) -> {
            if (!(l instanceof ItemChangeableList)) {
                return ItemChangeableList.newChangeableList();
            }
            return l;
        });
    }

    public ItemNetworkChannels getChannel() {
        return (ItemNetworkChannels)((TileInventoryReader)this.getSourceTile()).getNetworkChannels();
    }

    public static class Storage
    extends UpdaterInventoryReader {
        public Storage(InfoUUID uuid, TileInventoryReader source) {
            super(uuid, source);
        }

        @Override
        public IInfo update(IInfo current) {
            ItemChangeableList list = this.getUUIDLatestList(this.getUUID());
            LogicInfo stored = LogicInfo.buildDirectInfo("item.storage", RegistryType.TILE, list.sizing.getStored());
            LogicInfo max = LogicInfo.buildDirectInfo("max", RegistryType.TILE, list.sizing.getMaxStored());
            return new InfoProgressBar(stored, max);
        }

        @Override
        public List<IDataHolder> getDataHolders() {
            return null;
        }
    }

    public static class SelectedStack
    extends UpdaterInventoryReader {
        public SelectedStack(InfoUUID uuid, TileInventoryReader source) {
            super(uuid, source);
        }

        @Override
        public IInfo update(IInfo current) {
            ItemChangeableList list = this.getUUIDLatestList(this.getUUID());
            ItemStack stack = ((TileInventoryReader)this.getSourceTile()).inventory.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                MonitoredItemStack dummyInfo = new MonitoredItemStack(new StoredItemStack(stack.func_77946_l(), 0L), ((TileInventoryReader)this.getSourceTile()).network.getNetworkID());
                IMonitoredValue<MonitoredItemStack> value = list.find(dummyInfo);
                return value == null ? dummyInfo : new MonitoredItemStack(value.getSaveableInfo().getStoredStack().copy(), ((TileInventoryReader)this.getSourceTile()).network.getNetworkID());
            }
            return new InfoError("NO ITEM SELECTED");
        }

        @Override
        public List<IDataHolder> getDataHolders() {
            return null;
        }
    }

    public static class InventorySlot
    extends UpdaterInventoryReader {
        public InventorySlot(InfoUUID uuid, TileInventoryReader source) {
            super(uuid, source);
        }

        @Override
        public IInfo update(IInfo current) {
            NodeConnection connection;
            ItemNetworkChannels channel = this.getChannel();
            List channels = (List)channel.usedChannels.get(((TileInventoryReader)this.getSourceTile()).getIdentity());
            StoredItemStack slotStack = null;
            if (!channels.isEmpty() && (connection = (NodeConnection)channels.get(0)) != null) {
                if (connection instanceof BlockConnection) {
                    slotStack = ItemHelper.getTileStack((BlockConnection)connection, (Integer)((TileInventoryReader)this.getSourceTile()).targetSlot.getObject());
                }
                if (connection instanceof EntityConnection) {
                    slotStack = ItemHelper.getEntityStack((EntityConnection)connection, (Integer)((TileInventoryReader)this.getSourceTile()).targetSlot.getObject());
                }
            }
            if (slotStack != null) {
                MonitoredItemStack newInfo = new MonitoredItemStack(slotStack);
                newInfo.setNetworkSource(((TileInventoryReader)this.getSourceTile()).network.getNetworkID());
                return newInfo;
            }
            return InfoError.noItem;
        }

        @Override
        public List<IDataHolder> getDataHolders() {
            return null;
        }
    }

    public static class ItemListIndex
    extends UpdaterInventoryReader {
        public ItemListIndex(InfoUUID uuid, TileInventoryReader source) {
            super(uuid, source);
        }

        @Override
        public IInfo update(IInfo current) {
            ItemChangeableList list = this.getUUIDLatestList(this.getUUID());
            int pos = (Integer)((TileInventoryReader)this.getSourceTile()).posSlot.getObject();
            if (pos < list.getValueCount()) {
                MonitoredItemStack posItem = ((MonitoredItemStack)list.getActualValue(pos)).copy();
                posItem.setNetworkSource(((TileInventoryReader)this.getSourceTile()).network.getNetworkID());
                return posItem;
            }
            return InfoError.noItem;
        }

        @Override
        public List<IDataHolder> getDataHolders() {
            return null;
        }
    }

    public static class ItemList
    extends UpdaterInventoryReader
    implements IDataWatcher {
        public MultiDataSource source = new MultiDataSource(((TileInventoryReader)this.getSourceTile()).getChannels(), (INetworkTile)this.getSourceTile());
        public IDataHolder<ItemChangeableList> list = DataFactory.instance().getOrCreateDataHolder(this.source, () -> ItemChangeableList.newChangeableList(), 20);
        public List<IDataHolder> holders = Lists.newArrayList((Object[])new IDataHolder[]{this.list});

        public ItemList(InfoUUID uuid, TileInventoryReader source) {
            super(uuid, source);
        }

        @Override
        public IInfo update(IInfo current) {
            if (current instanceof LogicInfoList && ((TileInventoryReader)this.getSourceTile()).sorting_changed) {
                ServerInfoHandler.instance().markChanged((ILogicListenable)this.getSourceTile(), this.getUUID());
                ((TileInventoryReader)this.getSourceTile()).sorting_changed = false;
                return current;
            }
            LogicInfoList list = new LogicInfoList(((TileInventoryReader)this.getSourceTile()).getIdentity(), "items", ((TileInventoryReader)this.getSourceTile()).getNetworkID());
            list.listSorter = ((TileInventoryReader)this.getSourceTile()).inventory_sorter;
            return list;
        }

        @Override
        public List<IDataHolder> getDataHolders() {
            return this.holders;
        }
    }
}

