/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.channels.handling;

import java.util.concurrent.ThreadLocalRandom;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;

public abstract class DefaultNetworkChannels
implements INetworkChannels {
    private final CacheHandler[] caches;
    public final ILogisticsNetwork network;
    private Integer updateTicks = null;

    public DefaultNetworkChannels(ILogisticsNetwork network, CacheHandler ... caches) {
        this.network = network;
        this.caches = caches;
        this.onCreated();
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.network;
    }

    @Override
    public CacheHandler[] getValidCaches() {
        return this.caches;
    }

    protected void tickChannels() {
    }

    private void tick() {
        if (this.updateTicks == null) {
            this.updateTicks = ThreadLocalRandom.current().nextInt(0, this.getUpdateRate() + 1);
            this.tickChannels();
        }
        if (this.updateTicks < this.getUpdateRate()) {
            Integer n = this.updateTicks;
            Integer n2 = this.updateTicks = Integer.valueOf(this.updateTicks + 1);
            return;
        }
        this.updateTicks = 0;
        this.tickChannels();
    }

    public abstract int getUpdateRate();

    @Override
    public void onChannelsChanged() {
    }

    @Override
    public void updateChannel() {
        this.tick();
    }

    @Override
    public void onDeleted() {
    }

    @Override
    public void addConnection(INetworkTile connection) {
    }

    @Override
    public void removeConnection(INetworkTile connection) {
    }
}

